/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.command.ProducerInfo;

public class CompositeDestinationBroker
extends BrokerFilter {
    public CompositeDestinationBroker(Broker next) {
        super(next);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        BESMQDestination destination = info.getDestination();
        if (destination != null && destination.isComposite()) {
            BESMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ProducerInfo copy = info.copy();
                copy.setDestination(destinations[i]);
                this.next.addProducer(context, copy);
            }
        } else {
            this.next.addProducer(context, info);
        }
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        BESMQDestination destination = info.getDestination();
        if (destination != null && destination.isComposite()) {
            BESMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ProducerInfo copy = info.copy();
                copy.setDestination(destinations[i]);
                this.next.removeProducer(context, copy);
            }
        } else {
            this.next.removeProducer(context, info);
        }
    }

    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        BESMQDestination destination = message.getDestination();
        if (destination.isComposite()) {
            BESMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                if (i != 0) {
                    message = message.copy();
                    message.setMemoryUsage(null);
                }
                message.setOriginalDestination(destination);
                message.setDestination(destinations[i]);
                this.next.send(producerExchange, message);
            }
        } else {
            this.next.send(producerExchange, message);
        }
    }
}

