/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.Connection;
import com.bes.mq.broker.Connector;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ProtocolFormatInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.XATransactionId;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.security.MessageAuthorizationPolicy;
import com.bes.mq.security.SecurityContext;
import com.bes.mq.state.ConnectionState;
import com.bes.mq.transaction.Transaction;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionContext {
    private Connection connection;
    private Connector connector;
    private Broker broker;
    private boolean inRecoveryMode;
    private Transaction transaction;
    private ConcurrentHashMap<TransactionId, Transaction> transactions;
    private SecurityContext securityContext;
    private ConnectionId connectionId;
    private String clientId;
    private String userName;
    private boolean reconnect;
    private ProtocolFormatInfo protocolFormatInfo;
    private Object longTermStoreContext;
    private boolean producerFlowControl = true;
    private MessageAuthorizationPolicy messageAuthorizationPolicy;
    private boolean networkConnection;
    private boolean faultTolerant;
    private final AtomicBoolean stopping = new AtomicBoolean();
    private final MessageEvaluationContext messageEvaluationContext;
    private boolean dontSendReponse;
    private boolean clientMaster = true;
    private ConnectionState connectionState;
    private XATransactionId xid;

    public ConnectionContext() {
        this.messageEvaluationContext = new MessageEvaluationContext();
    }

    public ConnectionContext(MessageEvaluationContext messageEvaluationContext) {
        this.messageEvaluationContext = messageEvaluationContext;
    }

    public ConnectionContext(ConnectionInfo info) {
        this();
        this.setClientId(info.getClientId());
        this.setUserName(info.getUserName());
        this.setConnectionId(info.getConnectionId());
    }

    public ConnectionContext copy() {
        ConnectionContext rc = new ConnectionContext(this.messageEvaluationContext);
        rc.connection = this.connection;
        rc.connector = this.connector;
        rc.broker = this.broker;
        rc.inRecoveryMode = this.inRecoveryMode;
        rc.transaction = this.transaction;
        rc.transactions = this.transactions;
        rc.securityContext = this.securityContext;
        rc.connectionId = this.connectionId;
        rc.clientId = this.clientId;
        rc.userName = this.userName;
        rc.reconnect = this.reconnect;
        rc.protocolFormatInfo = this.protocolFormatInfo;
        rc.longTermStoreContext = this.longTermStoreContext;
        rc.producerFlowControl = this.producerFlowControl;
        rc.messageAuthorizationPolicy = this.messageAuthorizationPolicy;
        rc.networkConnection = this.networkConnection;
        rc.faultTolerant = this.faultTolerant;
        rc.stopping.set(this.stopping.get());
        rc.dontSendReponse = this.dontSendReponse;
        rc.clientMaster = this.clientMaster;
        return rc;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext subject) {
        this.securityContext = subject;
        if (subject != null) {
            this.setUserName(subject.getUserName());
        } else {
            this.setUserName(null);
        }
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public MessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    public void setMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.messageAuthorizationPolicy = messageAuthorizationPolicy;
    }

    public boolean isInRecoveryMode() {
        return this.inRecoveryMode;
    }

    public void setInRecoveryMode(boolean inRecoveryMode) {
        this.inRecoveryMode = inRecoveryMode;
    }

    public ConcurrentHashMap<TransactionId, Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(ConcurrentHashMap<TransactionId, Transaction> transactions) {
        this.transactions = transactions;
    }

    public boolean isInTransaction() {
        return this.transaction != null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public ProtocolFormatInfo getProtocolFormatInfo() {
        return this.protocolFormatInfo;
    }

    public void setProtocolFormatInfo(ProtocolFormatInfo protocolFormatInfo) {
        this.protocolFormatInfo = protocolFormatInfo;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(ConnectionId connectionId) {
        this.connectionId = connectionId;
    }

    public String getUserName() {
        return this.userName;
    }

    protected void setUserName(String userName) {
        this.userName = userName;
    }

    public MessageEvaluationContext getMessageEvaluationContext() {
        return this.messageEvaluationContext;
    }

    public Object getLongTermStoreContext() {
        return this.longTermStoreContext;
    }

    public void setLongTermStoreContext(Object longTermStoreContext) {
        this.longTermStoreContext = longTermStoreContext;
    }

    public boolean isProducerFlowControl() {
        return this.producerFlowControl;
    }

    public void setProducerFlowControl(boolean disableProducerFlowControl) {
        this.producerFlowControl = disableProducerFlowControl;
    }

    public boolean isAllowedToConsume(MessageReference n) throws IOException {
        if (this.messageAuthorizationPolicy != null) {
            return this.messageAuthorizationPolicy.isAllowedToConsume(this, n.getMessage());
        }
        return true;
    }

    public synchronized boolean isNetworkConnection() {
        return this.networkConnection;
    }

    public synchronized void setNetworkConnection(boolean networkConnection) {
        this.networkConnection = networkConnection;
    }

    public AtomicBoolean getStopping() {
        return this.stopping;
    }

    public void setDontSendReponse(boolean b) {
        this.dontSendReponse = b;
    }

    public boolean isDontSendReponse() {
        return this.dontSendReponse;
    }

    public boolean isSlave() {
        return this.broker != null && this.broker.getBrokerService().isSlave() || !this.clientMaster;
    }

    public boolean isClientMaster() {
        return this.clientMaster;
    }

    public void setClientMaster(boolean clientMaster) {
        this.clientMaster = clientMaster;
    }

    public boolean isFaultTolerant() {
        return this.faultTolerant;
    }

    public void setFaultTolerant(boolean faultTolerant) {
        this.faultTolerant = faultTolerant;
    }

    public void setConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public void setXid(XATransactionId id) {
        this.xid = id;
    }

    public XATransactionId getXid() {
        return this.xid;
    }
}

