/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public final class JSSEKeyManager
extends X509ExtendedKeyManager {
    private X509KeyManager delegate;
    private String serverKeyAlias;

    public JSSEKeyManager(X509KeyManager mgr, String serverKeyAlias) {
        this.delegate = mgr;
        this.serverKeyAlias = serverKeyAlias;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.serverKeyAlias != null) {
            return this.serverKeyAlias;
        }
        return this.delegate.chooseServerAlias(keyType, issuers, socket);
    }

    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this.serverKeyAlias != null) {
            return this.serverKeyAlias;
        }
        return super.chooseEngineServerAlias(keyType, issuers, engine);
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.delegate.chooseClientAlias(keyType, issuers, socket);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.delegate.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegate.getServerAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.delegate.chooseClientAlias(keyType, issuers, null);
    }
}

