/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.broker.Lockable;
import com.bes.mq.broker.Locker;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import com.bes.mq.util.ThreadPoolUtils;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class LockableServiceSupport
extends ServiceSupport
implements Lockable,
BrokerServiceAware {
    private static final Logger LOG = LoggerFactory.getLogger(LockableServiceSupport.class);
    boolean useLock = true;
    Locker locker;
    long lockKeepAlivePeriod = 0L;
    private ScheduledFuture<?> keepAliveTicket;
    private ScheduledThreadPoolExecutor clockDaemon;
    private BrokerService brokerService;
    private volatile Lockable.LockerStatus status = Lockable.LockerStatus.None;

    public abstract void init() throws Exception;

    public void setUseLock(boolean useLock) {
        this.useLock = useLock;
    }

    public boolean isUseLock() {
        return this.useLock;
    }

    public void setLocker(Locker locker) throws IOException {
        this.locker = locker;
        if (this instanceof PersistenceAdapter) {
            this.locker.configure((PersistenceAdapter)((Object)this));
        }
    }

    public synchronized Locker getLocker() throws IOException {
        if (this.locker == null) {
            this.locker = this.createDefaultLocker();
        }
        return this.locker;
    }

    public void setLockKeepAlivePeriod(long lockKeepAlivePeriod) {
        this.lockKeepAlivePeriod = lockKeepAlivePeriod;
    }

    public void preStart() throws Exception {
        this.status = Lockable.LockerStatus.Acquiring;
        try {
            this.init();
            if (this.useLock) {
                if (this.getLocker() == null) {
                    LOG.warn("No locker configured");
                } else {
                    this.getLocker().start();
                    if (this.lockKeepAlivePeriod > 0L) {
                        this.keepAliveTicket = this.getScheduledThreadPoolExecutor().scheduleAtFixedRate(new Runnable(){

                            public void run() {
                                LockableServiceSupport.this.keepLockAlive();
                            }
                        }, this.lockKeepAlivePeriod, this.lockKeepAlivePeriod, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
        catch (Exception e) {
            this.status = Lockable.LockerStatus.Failed;
            throw e;
        }
        this.status = Lockable.LockerStatus.Acquired;
        if (this.brokerService != null) {
            this.brokerService.nowMasterBroker();
        }
    }

    public void postStop(ServiceStopper stopper) throws Exception {
        if (this.useLock) {
            if (this.keepAliveTicket != null) {
                this.keepAliveTicket.cancel(false);
                this.keepAliveTicket = null;
            }
            if (this.locker != null) {
                this.getLocker().stop();
            }
            ThreadPoolUtils.shutdown(this.clockDaemon);
        }
        this.status = Lockable.LockerStatus.Stopped;
    }

    protected void keepLockAlive() {
        boolean stop = false;
        try {
            Locker locker = this.getLocker();
            if (locker != null && !locker.keepAlive()) {
                stop = true;
            }
        }
        catch (IOException e) {
            LOG.warn("Locker keepalive resulted in: " + e, e);
        }
        if (stop) {
            this.status = Lockable.LockerStatus.Stopped;
            this.stopBroker();
        }
    }

    protected void stopBroker() {
        LOG.info(this.brokerService.getBrokerName() + ", no longer able to keep the exclusive lock so giving up being a master");
        try {
            this.brokerService.stop();
        }
        catch (Exception e) {
            LOG.warn("Failure occurred while stopping broker");
        }
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        if (this.clockDaemon == null) {
            this.clockDaemon = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "BESMQ Lock KeepAlive Timer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return this.clockDaemon;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public Lockable.LockerStatus getLockerStatus() {
        return this.status;
    }
}

