/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.Region;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.state.ProducerState;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class ProducerBrokerExchange {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerBrokerExchange.class);
    private ConnectionContext connectionContext;
    private Destination regionDestination;
    private Region region;
    private ProducerState producerState;
    private boolean mutable = true;
    private AtomicLong lastSendSequenceNumber = new AtomicLong(-1L);
    private boolean auditProducerSequenceIds;
    private boolean isNetworkProducer;
    private BrokerService brokerService;

    public ProducerBrokerExchange copy() {
        ProducerBrokerExchange rc = new ProducerBrokerExchange();
        rc.connectionContext = this.connectionContext.copy();
        rc.regionDestination = this.regionDestination;
        rc.region = this.region;
        rc.producerState = this.producerState;
        rc.mutable = this.mutable;
        return rc;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public Destination getRegionDestination() {
        return this.regionDestination;
    }

    public void setRegionDestination(Destination regionDestination) {
        this.regionDestination = regionDestination;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public ProducerState getProducerState() {
        return this.producerState;
    }

    public void setProducerState(ProducerState producerState) {
        this.producerState = producerState;
    }

    public boolean canDispatch(Message messageSend) {
        boolean canDispatch = true;
        if (this.auditProducerSequenceIds && messageSend.isPersistent()) {
            long producerSequenceId = messageSend.getMessageId().getProducerSequenceId();
            if (this.isNetworkProducer) {
                long lastStoredForMessageProducer = this.getStoredSequenceIdForMessage(messageSend.getMessageId());
                if (producerSequenceId <= lastStoredForMessageProducer) {
                    canDispatch = false;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Suppressing duplicate message send  [" + (LOG.isTraceEnabled() ? messageSend : messageSend.getMessageId()) + "] from network producer with producerSequenceId [" + producerSequenceId + "] less than last stored: " + lastStoredForMessageProducer);
                    }
                }
            } else if (producerSequenceId <= this.lastSendSequenceNumber.get()) {
                canDispatch = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Suppressing duplicate message send [" + (LOG.isTraceEnabled() ? messageSend : messageSend.getMessageId()) + "] with producerSequenceId [" + producerSequenceId + "] less than last stored: " + this.lastSendSequenceNumber);
                }
            } else {
                this.lastSendSequenceNumber.set(producerSequenceId);
            }
        }
        return canDispatch;
    }

    private long getStoredSequenceIdForMessage(MessageId messageId) {
        try {
            return this.brokerService.getPersistenceAdapter().getLastProducerSequenceId(messageId.getProducerId());
        }
        catch (IOException ignored) {
            LOG.debug("Failed to determine last producer sequence id for: " + messageId, ignored);
            return -1L;
        }
    }

    public void setLastStoredSequenceId(long l) {
        this.auditProducerSequenceIds = true;
        if (this.connectionContext.isNetworkConnection()) {
            this.brokerService = this.connectionContext.getBroker().getBrokerService();
            this.isNetworkProducer = true;
        }
        this.lastSendSequenceNumber.set(l);
        LOG.debug("Last stored sequence id set: " + l);
    }
}

