/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.BrokerFactoryHandler;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.util.IntrospectionSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class PropertiesBrokerFactory
implements BrokerFactoryHandler {
    public BrokerService createBroker(URI brokerURI) throws Exception {
        Map properties = this.loadProperties(brokerURI);
        BrokerService brokerService = this.createBrokerService(brokerURI, properties);
        IntrospectionSupport.setProperties(brokerService, properties);
        return brokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadProperties(URI brokerURI) throws IOException {
        String remaining = brokerURI.getSchemeSpecificPart();
        Properties properties = new Properties();
        File file = new File(remaining);
        InputStream inputStream = null;
        if (file.exists()) {
            inputStream = new FileInputStream(file);
        } else {
            URL url;
            block10: {
                url = null;
                try {
                    url = new URL(remaining);
                }
                catch (MalformedURLException e) {
                    inputStream = this.findResourceOnClassPath(remaining);
                    if (inputStream != null) break block10;
                    throw new IOException("File does not exist: " + remaining + ", could not be found on the classpath and is not a valid URL: " + e);
                }
            }
            if (inputStream == null && url != null) {
                inputStream = url.openStream();
            }
        }
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            {
            }
        }
        try {
            Properties systemProperties = System.getProperties();
            properties.putAll((Map<?, ?>)systemProperties);
        }
        catch (Exception e) {
            // empty catch block
        }
        return properties;
    }

    protected InputStream findResourceOnClassPath(String remaining) {
        InputStream answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(remaining);
        if (answer == null) {
            answer = this.getClass().getClassLoader().getResourceAsStream(remaining);
        }
        return answer;
    }

    protected BrokerService createBrokerService(URI brokerURI, Map properties) {
        return new BrokerService();
    }
}

