/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.TransportConnector;
import com.bes.mq.util.InetAddressUtil;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Locale;

public class PublishedAddressPolicy {
    private String clusterClientUriQuery;
    private PublishedHostStrategy publishedHostStrategy = PublishedHostStrategy.DEFAULT;

    public String getPublishableConnectString(TransportConnector connector) throws Exception {
        String[] params;
        URI connectorURI = connector.getConnectUri();
        if (connectorURI == null) {
            return null;
        }
        String scheme = connectorURI.getScheme();
        String userInfo = this.getPublishedUserInfoValue(connectorURI.getUserInfo());
        String host = this.getPublishedHostValue(connectorURI.getHost(), connector.getPublishHostname());
        int port = connectorURI.getPort();
        String path = this.getPublishedPathValue(connectorURI.getPath());
        String fragment = this.getPublishedFragmentValue(connectorURI.getFragment());
        String query = connectorURI.getQuery();
        StringBuffer newQuery = new StringBuffer();
        for (String param : params = query == null ? new String[]{} : query.split("&")) {
            if (!param.startsWith("enableSSL") && !param.startsWith("socketType")) continue;
            newQuery.append(param + "&");
        }
        if (newQuery.indexOf("&") > 0) {
            newQuery.deleteCharAt(newQuery.length() - 1);
        }
        query = newQuery.length() == 0 ? null : newQuery.toString();
        URI publishedURI = new URI(scheme, userInfo, host, port, path, query, fragment);
        return publishedURI.toString();
    }

    protected String getPublishedHostValue(String uriHostEntry, String publishHostname) throws UnknownHostException {
        if (publishHostname != null && publishHostname.length() > 0) {
            return publishHostname;
        }
        String result = uriHostEntry;
        if (this.publishedHostStrategy.equals((Object)PublishedHostStrategy.IPADDRESS)) {
            InetAddress address = InetAddress.getByName(uriHostEntry);
            result = address.getHostAddress();
        } else if (this.publishedHostStrategy.equals((Object)PublishedHostStrategy.HOSTNAME)) {
            InetAddress address = InetAddress.getByName(uriHostEntry);
            result = address.isAnyLocalAddress() ? InetAddressUtil.getLocalHostName() : address.getHostName();
        } else if (this.publishedHostStrategy.equals((Object)PublishedHostStrategy.FQDN)) {
            InetAddress address = InetAddress.getByName(uriHostEntry);
            result = address.isAnyLocalAddress() ? InetAddressUtil.getLocalHostName() : address.getCanonicalHostName();
        }
        return result;
    }

    protected String getPublishedPathValue(String uriPathEntry) {
        return uriPathEntry;
    }

    protected String getPublishedFragmentValue(String uriFragmentEntry) {
        return uriFragmentEntry;
    }

    protected String getPublishedUserInfoValue(String uriUserInfoEntry) {
        return uriUserInfoEntry;
    }

    public String getClusterClientUriQuery() {
        return this.clusterClientUriQuery;
    }

    public void setClusterClientUriQuery(String clusterClientUriQuery) {
        this.clusterClientUriQuery = clusterClientUriQuery;
    }

    public PublishedHostStrategy getPublishedHostStrategy() {
        return this.publishedHostStrategy;
    }

    public void setPublishedHostStrategy(PublishedHostStrategy strategy) {
        this.publishedHostStrategy = strategy;
    }

    public void setPublishedHostStrategy(String strategy) {
        this.publishedHostStrategy = PublishedHostStrategy.getValue(strategy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PublishedHostStrategy {
        DEFAULT,
        IPADDRESS,
        HOSTNAME,
        FQDN;


        public static PublishedHostStrategy getValue(String value) {
            return PublishedHostStrategy.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
    }
}

