/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.BESMQMessageAudit;
import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ConsumerBrokerExchange;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BaseCommand;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.LocalTransactionId;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.XATransactionId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.state.ProducerState;
import com.bes.mq.store.TransactionRecoveryListener;
import com.bes.mq.store.TransactionStore;
import com.bes.mq.transaction.LocalTransaction;
import com.bes.mq.transaction.Synchronization;
import com.bes.mq.transaction.Transaction;
import com.bes.mq.transaction.XATransaction;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.WrappedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;

public class TransactionBroker
extends BrokerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionBroker.class);
    private TransactionStore transactionStore;
    private Map<TransactionId, XATransaction> xaTransactions = new LinkedHashMap<TransactionId, XATransaction>();
    private BESMQMessageAudit audit;

    public TransactionBroker(Broker next, TransactionStore transactionStore) {
        super(next);
        this.transactionStore = transactionStore;
    }

    public void start() throws Exception {
        this.transactionStore.start();
        try {
            final ConnectionContext context = new ConnectionContext();
            context.setBroker(this);
            context.setInRecoveryMode(true);
            context.setTransactions(new ConcurrentHashMap<TransactionId, Transaction>());
            context.setProducerFlowControl(false);
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setMutable(true);
            producerExchange.setConnectionContext(context);
            producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
            ConsumerBrokerExchange consumerExchange = new ConsumerBrokerExchange();
            consumerExchange.setConnectionContext(context);
            this.transactionStore.recover(new TransactionRecoveryListener(){

                public void recover(XATransactionId xid, Message[] addedMessages, MessageAck[] aks) {
                    try {
                        int i;
                        TransactionBroker.this.beginTransaction(context, xid);
                        XATransaction transaction = (XATransaction)TransactionBroker.this.getTransaction(context, xid, false);
                        for (i = 0; i < addedMessages.length; ++i) {
                            TransactionBroker.this.forceDestinationWakeupOnCompletion(context, transaction, addedMessages[i].getDestination(), addedMessages[i]);
                        }
                        for (i = 0; i < aks.length; ++i) {
                            TransactionBroker.this.forceDestinationWakeupOnCompletion(context, transaction, aks[i].getDestination(), aks[i]);
                        }
                        transaction.setState((byte)2);
                        TransactionBroker.this.registerMBean(transaction);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Recovered prepared transaction: " + transaction.getTransactionId());
                        }
                    }
                    catch (Throwable e) {
                        throw new WrappedException(e);
                    }
                }
            });
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            throw IOExceptionSupport.create("Recovery failed: " + cause.getMessage(), cause);
        }
        this.next.start();
    }

    private void registerMBean(XATransaction transaction) {
        if (this.getBrokerService().getRegionBroker() instanceof ManagedRegionBroker) {
            ManagedRegionBroker managedRegionBroker = (ManagedRegionBroker)this.getBrokerService().getRegionBroker();
            managedRegionBroker.registerRecoveredTransactionMBean(transaction);
        }
    }

    private void forceDestinationWakeupOnCompletion(ConnectionContext context, Transaction transaction, BESMQDestination bmqDestination, BaseCommand ack) throws Exception {
        Destination destination = this.addDestination(context, bmqDestination, false);
        this.registerSync(destination, transaction, ack);
    }

    private void registerSync(Destination destination, Transaction transaction, BaseCommand command) {
        PreparedDestinationCompletion sync = new PreparedDestinationCompletion(destination, command.isMessage());
        Synchronization existing = transaction.findMatching(sync);
        if (existing != null) {
            ((PreparedDestinationCompletion)existing).incrementOpCount();
        } else {
            transaction.addSynchronization(sync);
        }
    }

    public void stop() throws Exception {
        this.transactionStore.stop();
        this.next.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        ArrayList<TransactionId> txs = new ArrayList<TransactionId>();
        Map<TransactionId, XATransaction> map = this.xaTransactions;
        synchronized (map) {
            for (Transaction transaction : this.xaTransactions.values()) {
                if (!transaction.isPrepared()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepared transaction: " + transaction.getTransactionId());
                }
                txs.add(transaction.getTransactionId());
            }
        }
        TransactionId[] rc = new XATransactionId[txs.size()];
        txs.toArray(rc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prepared transaction list size: " + rc.length);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        if (xid.isXATransaction()) {
            XATransaction transaction = null;
            Map<TransactionId, XATransaction> map = this.xaTransactions;
            synchronized (map) {
                transaction = this.xaTransactions.get(xid);
                if (transaction != null) {
                    return;
                }
                transaction = new XATransaction(this.transactionStore, (XATransactionId)xid, this, context.getConnectionId());
                this.xaTransactions.put(xid, transaction);
            }
        } else {
            ConcurrentHashMap<TransactionId, Transaction> transactionMap = context.getTransactions();
            Transaction transaction = (Transaction)transactionMap.get(xid);
            if (transaction != null) {
                throw new JMSException("Transaction '" + xid + "' has already been started.");
            }
            transaction = new LocalTransaction(this.transactionStore, (LocalTransactionId)xid, context);
            transactionMap.put(xid, transaction);
        }
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        Transaction transaction = this.getTransaction(context, xid, false);
        return transaction.prepare();
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        Transaction transaction = this.getTransaction(context, xid, true);
        transaction.commit(onePhase);
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        Transaction transaction = this.getTransaction(context, xid, true);
        transaction.rollback();
    }

    public void forgetTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        Transaction transaction = this.getTransaction(context, xid, true);
        transaction.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        ConnectionContext context = consumerExchange.getConnectionContext();
        Transaction originalTx = context.getTransaction();
        Transaction transaction = null;
        if (ack.isInTransaction()) {
            transaction = this.getTransaction(context, ack.getTransactionId(), false);
        }
        context.setTransaction(transaction);
        try {
            this.next.acknowledge(consumerExchange, ack);
            Object var7_6 = null;
            context.setTransaction(originalTx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            context.setTransaction(originalTx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ProducerBrokerExchange producerExchange, final Message message) throws Exception {
        ConnectionContext context = producerExchange.getConnectionContext();
        Transaction originalTx = context.getTransaction();
        Transaction transaction = null;
        Synchronization sync = null;
        if (message.getTransactionId() != null && (transaction = this.getTransaction(context, message.getTransactionId(), false)) != null) {
            sync = new Synchronization(){

                public void afterRollback() {
                    if (TransactionBroker.this.audit != null) {
                        TransactionBroker.this.audit.rollback(message);
                    }
                }
            };
            transaction.addSynchronization(sync);
        }
        if (this.audit == null || !this.audit.isDuplicate(message)) {
            context.setTransaction(transaction);
            try {
                this.next.send(producerExchange, message);
                Object var8_7 = null;
                context.setTransaction(originalTx);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                context.setTransaction(originalTx);
                throw throwable;
            }
        } else {
            if (sync != null && transaction != null) {
                transaction.removeSynchronization(sync);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring duplicate message " + message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        Iterator<Transaction> iter = context.getTransactions().values().iterator();
        while (iter.hasNext()) {
            try {
                Transaction transaction = iter.next();
                transaction.rollback();
            }
            catch (Exception e) {
                LOG.warn("Error during rolling back disconnected client's transactions: ", e);
            }
            iter.remove();
        }
        Map<TransactionId, XATransaction> map = this.xaTransactions;
        synchronized (map) {
            ArrayList<XATransaction> txs = new ArrayList<XATransaction>();
            for (XATransaction tx : this.xaTransactions.values()) {
                if (tx.getConnectionId() == null || !tx.getConnectionId().equals(info.getConnectionId()) || tx.isPrepared()) continue;
                txs.add(tx);
            }
            for (XATransaction tx : txs) {
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    LOG.warn("Error during rolling back disconnected client's xa transactions: ", e);
                }
            }
        }
        this.next.removeConnection(context, info, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction(ConnectionContext context, TransactionId xid, boolean mightBePrepared) throws JMSException, XAException {
        Map<TransactionId, XATransaction> transactionMap = null;
        Map<TransactionId, XATransaction> map = this.xaTransactions;
        synchronized (map) {
            transactionMap = xid.isXATransaction() ? this.xaTransactions : context.getTransactions();
        }
        Transaction transaction = transactionMap.get(xid);
        if (transaction != null) {
            return transaction;
        }
        if (xid.isXATransaction()) {
            XAException e = new XAException("Transaction '" + xid + "' has not been started.");
            e.errorCode = -4;
            throw e;
        }
        throw new JMSException("Transaction '" + xid + "' has not been started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(XATransactionId xid) {
        Map<TransactionId, XATransaction> map = this.xaTransactions;
        synchronized (map) {
            this.xaTransactions.remove(xid);
        }
    }

    public synchronized void brokerServiceStarted() {
        super.brokerServiceStarted();
        if (this.getBrokerService().isSupportFailOver() && this.audit == null) {
            this.audit = new BESMQMessageAudit();
        }
    }

    static class PreparedDestinationCompletion
    extends Synchronization {
        final Destination destination;
        final boolean messageSend;
        int opCount = 1;

        public PreparedDestinationCompletion(Destination destination, boolean messageSend) {
            this.destination = destination;
            this.messageSend = messageSend;
        }

        public void incrementOpCount() {
            ++this.opCount;
        }

        public int hashCode() {
            return System.identityHashCode(this.destination) + System.identityHashCode(this.messageSend);
        }

        public boolean equals(Object other) {
            return other instanceof PreparedDestinationCompletion && this.destination.equals(((PreparedDestinationCompletion)other).destination) && this.messageSend == ((PreparedDestinationCompletion)other).messageSend;
        }

        public void afterRollback() throws Exception {
            if (!this.messageSend) {
                this.destination.clearPendingMessages();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cleared pending from afterRollback : " + this.destination);
                }
            }
        }

        public void afterCommit() throws Exception {
            if (this.messageSend) {
                this.destination.clearPendingMessages();
                this.destination.getDestinationStatistics().getEnqueues().add(this.opCount);
                this.destination.getDestinationStatistics().getMessages().add(this.opCount);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cleared pending from afterCommit : " + this.destination);
                }
            } else {
                this.destination.getDestinationStatistics().getDequeues().add(this.opCount);
                this.destination.getDestinationStatistics().getMessages().subtract(this.opCount);
            }
        }
    }
}

