/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.Service;
import com.bes.mq.broker.TransportConnection;
import com.bes.mq.broker.TransportConnector;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

public class TransportStatusDetector
implements Service,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TransportStatusDetector.class);
    private TransportConnector connector;
    private Set<TransportConnection> collectionCandidates = new CopyOnWriteArraySet<TransportConnection>();
    private AtomicBoolean started = new AtomicBoolean(false);
    private Thread runner;

    TransportStatusDetector(TransportConnector connector) {
        this.connector = connector;
    }

    protected void doCollection() {
        for (TransportConnection tc : this.collectionCandidates) {
            if (tc.isMarkedCandidate()) {
                if (tc.isBlockedCandidate()) {
                    this.collectionCandidates.remove(tc);
                    this.doCollection(tc);
                    continue;
                }
                tc.doMark();
                continue;
            }
            this.collectionCandidates.remove(tc);
        }
    }

    protected void doSweep() {
        for (TransportConnection connection : this.connector.getConnections()) {
            if (!connection.isMarkedCandidate()) continue;
            connection.doMark();
            this.collectionCandidates.add(connection);
        }
    }

    protected void doCollection(TransportConnection tc) {
        LOG.warn("Found a blocked client - stopping: " + tc);
        try {
            tc.stop();
        }
        catch (Exception e) {
            LOG.error("Error stopping " + tc, e);
        }
    }

    public void run() {
        while (this.started.get()) {
            try {
                this.doCollection();
                this.doSweep();
                Thread.sleep(this.connector.getTransportStatusSweepInterval());
            }
            catch (Throwable e) {
                LOG.error("Failed to complete a sweep for blocked clients", e);
            }
        }
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.runner = new Thread((Runnable)this, "BESMQ Transport Status Monitor: " + this.connector);
            this.runner.setDaemon(true);
            this.runner.setPriority(9);
            this.runner.start();
        }
    }

    public void stop() throws Exception {
        this.started.set(false);
        if (this.runner != null) {
            this.runner.join(this.connector.getTransportStatusSweepInterval() * 5L);
        }
    }
}

