/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.command.Message;
import com.bes.mq.jaas.UserPrincipal;
import com.bes.mq.security.SecurityContext;
import java.security.Principal;
import java.util.Set;

public class UserIDBroker
extends BrokerFilter {
    boolean useAuthenticatePrincipal = false;

    public UserIDBroker(Broker next) {
        super(next);
    }

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        Set<Principal> principals;
        SecurityContext securityContext;
        ConnectionContext context = producerExchange.getConnectionContext();
        String userID = context.getUserName();
        if (this.isUseAuthenticatePrincipal() && (securityContext = context.getSecurityContext()) != null && (principals = securityContext.getPrincipals()) != null) {
            for (Principal candidate : principals) {
                if (!(candidate instanceof UserPrincipal)) continue;
                userID = ((UserPrincipal)candidate).getName();
                break;
            }
        }
        messageSend.setUserID(userID);
        super.send(producerExchange, messageSend);
    }

    public boolean isUseAuthenticatePrincipal() {
        return this.useAuthenticatePrincipal;
    }

    public void setUseAuthenticatePrincipal(boolean useAuthenticatePrincipal) {
        this.useAuthenticatePrincipal = useAuthenticatePrincipal;
    }
}

