/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.cluster;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerFilter;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class ConnectionSplitBroker
extends BrokerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionSplitBroker.class);
    private List<ConsumerInfo> networkConsumerList = new ArrayList<ConsumerInfo>();

    public ConnectionSplitBroker(Broker next) {
        super(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        BESMQDestination dest = info.getDestination();
        List<ConsumerInfo> list = this.networkConsumerList;
        synchronized (list) {
            if (info.isNetworkSubscription()) {
                this.networkConsumerList.add(info);
            } else if (!this.networkConsumerList.isEmpty()) {
                ArrayList<ConsumerInfo> gcList = new ArrayList<ConsumerInfo>();
                for (ConsumerInfo nc : this.networkConsumerList) {
                    if (nc.isNetworkConsumersEmpty()) continue;
                    for (ConsumerId id : nc.getNetworkConsumerIds()) {
                        if (!id.equals(info.getConsumerId())) continue;
                        nc.removeNetworkConsumerId(id);
                        if (!nc.isNetworkConsumersEmpty()) continue;
                        gcList.add(nc);
                    }
                }
                for (ConsumerInfo nc : gcList) {
                    this.networkConsumerList.remove(nc);
                    super.removeConsumer(context, nc);
                    LOG.warn("Removed stale network consumer " + nc);
                }
            }
        }
        return super.addConsumer(context, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        if (info.isNetworkSubscription()) {
            List<ConsumerInfo> list = this.networkConsumerList;
            synchronized (list) {
                this.networkConsumerList.remove(info);
            }
        }
        super.removeConsumer(context, info);
    }
}

