/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.file;

import com.bes.hsdb.util.IOHelper;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.TransportConnection;
import com.bes.mq.broker.file.FileSendMeta;
import com.bes.mq.broker.file.FileTransferManager;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQFileMessage;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.FileChunk;
import com.bes.mq.command.FileRequest;
import com.bes.mq.command.FileRequestAck;
import com.bes.mq.command.FileSend;
import com.bes.mq.command.FileSendAck;
import com.bes.mq.command.Response;
import com.bes.mq.file.FileTransferError;
import com.bes.mq.file.FileTransferException;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.hsdb.HSDBPersistenceAdapter;
import com.bes.mq.transport.Transport;
import com.bes.mq.util.JMSExceptionSupport;
import com.bes.mq.util.NamedTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;

public class DefaultFileTransferManager
implements FileTransferManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFileTransferManager.class);
    private static final String FT_META_FILE = "file-transfer.meta";
    private BrokerService brokerService = null;
    private Map<String, FileSendMeta> sendMetaMap = new ConcurrentHashMap<String, FileSendMeta>();
    private Map<String, RandomAccessFile> sendRafMap = new ConcurrentHashMap<String, RandomAccessFile>();
    private volatile boolean stopped = false;
    private SaveFileTransferMetaTask saveFileTransferMetaTask = new SaveFileTransferMetaTask();
    private CleanExpiredFilesTask cleanExpiredFilesTask = new CleanExpiredFilesTask();

    public DefaultFileTransferManager(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public synchronized void start() {
        File tmpFilesDirectory = this.brokerService.getMsgFilesDirectory();
        if (!tmpFilesDirectory.exists()) {
            tmpFilesDirectory.mkdirs();
        }
        this.load();
        this.clean();
        this.brokerService.getScheduler().schedualPeriodically(this.saveFileTransferMetaTask, this.brokerService.getFileTransferMetaFlushPeriodInMills());
        if (this.brokerService.getMsgFilesRetentionInMills() > 0L) {
            this.brokerService.getScheduler().schedualPeriodically(this.cleanExpiredFilesTask, this.brokerService.getFileTransferExpiredFilesCleanPeriodInMills());
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        this.brokerService.getScheduler().cancel(this.saveFileTransferMetaTask);
        if (this.brokerService.getMsgFilesRetentionInMills() > 0L) {
            this.brokerService.getScheduler().cancel(this.cleanExpiredFilesTask);
        }
        Iterator<RandomAccessFile> it = this.sendRafMap.values().iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            it.remove();
        }
        this.save();
    }

    public Response processFileSend(FileSend fileSend) throws Exception {
        FileSendAck ack = new FileSendAck();
        ack.setCorrelationId(fileSend.getCommandId());
        ack.setUid(fileSend.getUid());
        ack.setResume(false);
        ack.setResumePos(0L);
        if (fileSend.getResumeMode()) {
            FileSendMeta sendMeta = this.sendMetaMap.get(fileSend.getUid());
            boolean resume = sendMeta != null;
            resume = resume && sendMeta.getDestName().equals(fileSend.getDestination().getPhysicalName());
            resume = resume && sendMeta.getDeliveryMode() == fileSend.getDeliveryMode();
            boolean bl = resume = resume && sendMeta.getSize() == fileSend.getSize();
            if (resume) {
                File msgFile = this.findMessageFile(fileSend.getDestination(), fileSend.getDeliveryMode(), fileSend.getUid());
                boolean bl2 = resume = resume && msgFile.exists();
            }
            if (resume) {
                ack.setResume(true);
                ack.setResumePos(sendMeta.getPosition());
            } else {
                sendMeta = new FileSendMeta();
                sendMeta.setUid(fileSend.getUid());
                sendMeta.setSize(fileSend.getSize());
                sendMeta.setChecksum(fileSend.getChecksum());
                sendMeta.setPosition(0L);
                sendMeta.setResumeMode(true);
                sendMeta.setDeliveryMode(fileSend.getDeliveryMode());
                sendMeta.setDestType(fileSend.getDestination().getDestinationType());
                sendMeta.setDestName(fileSend.getDestination().getPhysicalName());
                this.sendMetaMap.put(fileSend.getUid(), sendMeta);
            }
        } else {
            this.sendMetaMap.remove(fileSend.getUid());
        }
        return ack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response processFileChunk(FileChunk fileChunk) throws IOException {
        FileSendMeta sendMeta = this.sendMetaMap.get(fileChunk.getUid());
        if (sendMeta == null) {
            throw new FileTransferException(FileTransferError.FILE_CHUNK_AHEAD_ERR.getErrCode(), FileTransferError.FILE_CHUNK_AHEAD_ERR.getErrMsg() + " uid " + fileChunk.getUid());
        }
        if (!sendMeta.getUid().equals(fileChunk.getUid())) {
            throw new FileTransferException(FileTransferError.FILE_UID_INVALID_ERR.getErrCode(), FileTransferError.FILE_UID_INVALID_ERR.getErrMsg() + " expect " + sendMeta.getUid() + " got " + fileChunk.getUid());
        }
        if (sendMeta.getPosition() != fileChunk.getPosition()) {
            throw new FileTransferException(FileTransferError.FILE_POSITION_INVALID_ERR.getErrCode(), FileTransferError.FILE_POSITION_INVALID_ERR.getErrMsg() + " expect " + sendMeta.getPosition() + " got " + fileChunk.getPosition());
        }
        RandomAccessFile raf = this.sendRafMap.get(fileChunk.getUid());
        if (raf == null) {
            File msgFile = this.findMessageFile(sendMeta.getDestType(), sendMeta.getDestName(), sendMeta.getDeliveryMode(), sendMeta.getUid());
            raf = new RandomAccessFile(msgFile, "rw");
            this.sendRafMap.put(fileChunk.getUid(), raf);
        }
        raf.seek(fileChunk.getPosition());
        raf.write(fileChunk.getContent());
        FileSendMeta fileSendMeta = sendMeta;
        synchronized (fileSendMeta) {
            sendMeta.setPosition(sendMeta.getPosition() + (long)fileChunk.getContent().length);
        }
        if (sendMeta.getPosition() == sendMeta.getSize()) {
            raf.close();
            this.sendMetaMap.remove(fileChunk.getUid());
            this.sendRafMap.remove(fileChunk.getUid());
        }
        return null;
    }

    public Response processFileRequest(final FileRequest fileRequest, final TransportConnection connection) throws Exception {
        final File msgFile = this.findMessageFile(fileRequest.getDestination(), fileRequest.getDeliveryMode(), fileRequest.getUid());
        boolean fileFound = msgFile.exists();
        FileRequestAck ack = new FileRequestAck();
        ack.setResultCode(fileFound ? (byte)0 : 1);
        ack.setUid(fileRequest.getUid());
        ack.setSize(msgFile.length());
        ack.setResumeMode(fileRequest.getResumeMode());
        ack.setChecksum(0L);
        connection.dispatchSync(ack);
        if (fileFound) {
            this.brokerService.getTaskRunnerFactory().execute(new Runnable(){

                public void run() {
                    try {
                        DefaultFileTransferManager.this.sendFileChunk(msgFile, fileRequest, connection);
                    }
                    catch (JMSException e) {
                        LOG.warn("Failed to send FileChunk, uid " + fileRequest.getUid(), e);
                    }
                }
            }, "Dispatch FileChunk " + fileRequest.getUid());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forwardNetworkFileMessage(BESMQFileMessage fileMessage, Transport remoteBroker) throws Exception {
        String uid = fileMessage.getStringProperty("BESMQ_FT_FILE_UID");
        if (uid == null || uid.isEmpty()) {
            LOG.warn("Cant forward network FileMessage " + fileMessage.getFileName() + ", uid is empty. MessageID: " + fileMessage.getMessageId());
            return;
        }
        File msgFile = this.findMessageFile(fileMessage.getDestination(), fileMessage.getJMSDeliveryMode(), uid);
        if (!msgFile.exists()) {
            LOG.warn("Cant forward network FileMessage " + fileMessage.getFileName() + ", the file attached not found. MessageID: " + fileMessage.getMessageId());
            return;
        }
        LOG.info("Start to forward FileMessage " + fileMessage.getFileName() + " uid " + uid + " to remote broker " + remoteBroker.getRemoteAddress());
        FileSend fileSend = new FileSend();
        fileSend.setResponseRequired(true);
        fileSend.setSize(msgFile.length());
        fileSend.setUid(uid);
        fileSend.setChecksum(0L);
        fileSend.setResumeMode(true);
        fileSend.setDeliveryMode(fileMessage.getJMSDeliveryMode());
        fileSend.setDestination(fileMessage.getDestination());
        long currentPos = 0L;
        long fileSize = msgFile.length();
        if (currentPos >= fileSize) return;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(msgFile, "r");
            boolean resendMeta = true;
            int resumeCount = 0;
            int chunkSize = this.brokerService.getFileTransferChunkSize();
            while (!this.stopped && currentPos < fileSize) {
                try {
                    int minLength;
                    byte[] content;
                    int read;
                    if (resendMeta) {
                        resendMeta = false;
                        fileSend.setPosition(currentPos);
                        FileSendAck fileSendAck = (FileSendAck)remoteBroker.request(fileSend);
                        currentPos = fileSendAck.getResume() ? fileSendAck.getResumePos() : 0L;
                        raf.seek(currentPos);
                    }
                    if ((read = raf.read(content = new byte[minLength = fileSize - currentPos > (long)chunkSize ? chunkSize : (int)(fileSize - currentPos)])) == -1) {
                        return;
                    }
                    FileChunk fileChunk = new FileChunk();
                    fileChunk.setUid(uid);
                    fileChunk.setPosition(currentPos);
                    fileChunk.setContent(content);
                    Response response = (Response)remoteBroker.request(fileChunk);
                    if (response.isException()) {
                        ExceptionResponse er = (ExceptionResponse)response;
                        if (er.getException() instanceof JMSException) {
                            throw (JMSException)er.getException();
                        }
                        JMSException jmsEx = null;
                        try {
                            jmsEx = JMSExceptionSupport.create(er.getException());
                        }
                        catch (Throwable e) {
                            throw new Exception("ForwardFileMessage Caught an exception trying to create a JMSException for " + er.getException(), e);
                        }
                        if (jmsEx != null) {
                            throw jmsEx;
                        }
                    }
                    currentPos += (long)read;
                }
                catch (Exception e) {
                    FileTransferException fte = null;
                    fte = FileTransferException.extract(e.getCause());
                    if (fte != null && (fte.getErrCode() == FileTransferError.FILE_CHUNK_AHEAD_ERR.getErrCode() || fte.getErrCode() == FileTransferError.FILE_POSITION_INVALID_ERR.getErrCode())) {
                        resendMeta = true;
                        LOG.warn("Forward file is break caused by: " + fte.getMessage() + ", transfer will resume " + ++resumeCount + "st");
                        continue;
                    }
                    LOG.error("Forward file error. pos " + currentPos, e);
                    throw e;
                    return;
                }
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException e1) {}
        }
    }

    public void fileMessageConsumed(BESMQFileMessage message, boolean onlyNonPersistent) {
        try {
            if (onlyNonPersistent && message.isPersistent()) {
                return;
            }
            String uid = message.getStringProperty("BESMQ_FT_FILE_UID");
            if (uid == null || uid.isEmpty()) {
                return;
            }
            File msgFile = this.findMessageFile(message.getDestination(), message.getJMSDeliveryMode(), uid);
            if (!msgFile.exists()) {
                return;
            }
            msgFile.delete();
            this.sendMetaMap.remove(uid);
        }
        catch (Exception e) {
            LOG.warn("Failed to clean consumed message file", e);
        }
    }

    private void sendFileChunk(File msgFile, FileRequest fileRequest, TransportConnection connection) throws JMSException {
        long currentPos;
        String uid = fileRequest.getUid();
        long fileSize = msgFile.length();
        int chunkSize = fileRequest.getChunkSize();
        if (currentPos < fileSize) {
            RandomAccessFile raf = null;
            try {
                int read;
                raf = new RandomAccessFile(msgFile, "r");
                raf.seek(currentPos);
                for (currentPos = fileRequest.getPosition(); currentPos < fileSize; currentPos += (long)read) {
                    int minLength = fileSize - currentPos > (long)chunkSize ? chunkSize : (int)(fileSize - currentPos);
                    byte[] content = new byte[minLength];
                    read = raf.read(content);
                    if (read == -1) {
                        break;
                    }
                    FileChunk fileChunk = new FileChunk();
                    fileChunk.setUid(uid);
                    fileChunk.setPosition(currentPos);
                    fileChunk.setContent(content);
                    connection.dispatchSync(fileChunk);
                }
            }
            catch (IOException e) {
                JMSException jmse = new JMSException("Failed to send file to client " + connection.getRemoteAddress());
                jmse.initCause(e);
                throw jmse;
            }
            finally {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException e1) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        HashMap<String, FileSendMeta> metaMapCopy = new HashMap<String, FileSendMeta>();
        for (Map.Entry<String, FileSendMeta> next : this.sendMetaMap.entrySet()) {
            String key = next.getKey();
            FileSendMeta value = next.getValue();
            if (!value.isResumeMode()) continue;
            FileSendMeta fileSendMeta = value;
            synchronized (fileSendMeta) {
                metaMapCopy.put(key, value.copy());
            }
        }
        File metaFile = new File(this.brokerService.getMsgFilesDirectory(), FT_META_FILE);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(metaFile));
            oos.writeObject(metaMapCopy);
        }
        catch (Exception e) {
            LOG.error("Failed to save file transfer meta", e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        File metaFile = new File(this.brokerService.getMsgFilesDirectory(), FT_META_FILE);
        if (metaFile.exists()) {
            ObjectInputStream ois = null;
            try {
                FileInputStream fos = new FileInputStream(metaFile);
                ois = new ObjectInputStream(fos);
                Map obj = (Map)ois.readObject();
                Iterator it = obj.values().iterator();
                if (it.hasNext()) {
                    LOG.info("Load file transfer meta: " + it.next());
                }
                this.sendMetaMap.putAll(obj);
            }
            catch (Exception e) {
                LOG.error("Failed to load file transfer meta", e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close meta file stream", e);
                    }
                }
            }
        }
    }

    private void clean() {
        long currentTime = System.currentTimeMillis();
        long retentionInMills = this.brokerService.getMsgFilesRetentionInMills();
        this.clean((byte)1, 2, currentTime, retentionInMills);
        this.clean((byte)1, 1, currentTime, retentionInMills);
        this.clean((byte)2, 2, currentTime, retentionInMills);
        this.clean((byte)2, 1, currentTime, retentionInMills);
        this.clean((byte)5, 2, currentTime, retentionInMills);
        this.clean((byte)5, 1, currentTime, retentionInMills);
        this.clean((byte)6, 2, currentTime, retentionInMills);
        this.clean((byte)6, 1, currentTime, retentionInMills);
    }

    private void clean(byte destType, int deliveryMode, long currentTime, long retentionInMills) {
        File destDir = new File(this.brokerService.getMsgFilesDirectory(), this.destType2Str(destType));
        File[] listFiles = destDir.listFiles();
        if (listFiles != null) {
            for (File dest : listFiles) {
                File[] msgFiles;
                File deliveryDir = new File(dest, String.valueOf(deliveryMode));
                if (!deliveryDir.exists() || (msgFiles = deliveryDir.listFiles()) == null) continue;
                for (File msgFile : msgFiles) {
                    long lastModified = msgFile.lastModified();
                    if (currentTime - lastModified <= retentionInMills) continue;
                    String uid = msgFile.getName();
                    if (msgFile.delete()) {
                        LOG.info("Delete expired message attached file " + msgFile.getAbsolutePath() + ", lastModified " + lastModified);
                        this.sendMetaMap.remove(uid);
                        continue;
                    }
                    LOG.warn("Failed to delete expired message attached file " + msgFile.getAbsolutePath() + ", lastModified " + lastModified);
                }
            }
        }
    }

    private String destType2Str(byte type) {
        switch (type) {
            case 1: {
                return "q";
            }
            case 2: {
                return "t";
            }
            case 5: {
                return "tq";
            }
            case 6: {
                return "tt";
            }
        }
        throw new IllegalArgumentException("Invalid default destination type: " + type);
    }

    private File findMessageFile(BESMQDestination dest, int deliveryMode, String uid) {
        return this.findMessageFile(dest.getDestinationType(), dest.getPhysicalName(), deliveryMode, uid);
    }

    private File findMessageFile(byte destType, String destName, int deliveryMode, String uid) {
        File deliveryModeDir;
        File destDir;
        File destParentDir = new File(this.brokerService.getMsgFilesDirectory(), this.destType2Str(destType));
        if (!destParentDir.exists()) {
            destParentDir.mkdirs();
        }
        if (!(destDir = new File(destParentDir, destName)).exists()) {
            destDir.mkdirs();
        }
        if (!(deliveryModeDir = new File(destDir, String.valueOf(deliveryMode))).exists()) {
            deliveryModeDir.mkdirs();
        }
        File msgFile = new File(deliveryModeDir, uid);
        return msgFile;
    }

    @Deprecated
    private class CleanDemoCode {
        private CleanDemoCode() {
        }

        private void clean(boolean cleanTempDest, boolean cleanNonPersisent) {
            if (cleanTempDest) {
                this.cleanTempDestFiles();
            }
            if (cleanNonPersisent) {
                this.cleanNonPersisentFiles();
            }
            try {
                this.cleanExpiredPersistentFiles();
            }
            catch (IOException e) {
                LOG.error("Failed to clean expired persistent files", e);
            }
        }

        private void cleanTempDestFiles() {
            IOHelper.delete((File)new File(DefaultFileTransferManager.this.brokerService.getMsgFilesDirectory(), DefaultFileTransferManager.this.destType2Str((byte)5)));
            IOHelper.delete((File)new File(DefaultFileTransferManager.this.brokerService.getMsgFilesDirectory(), DefaultFileTransferManager.this.destType2Str((byte)6)));
        }

        private void cleanNonPersisentFiles() {
            File destDir = new File(DefaultFileTransferManager.this.brokerService.getMsgFilesDirectory(), DefaultFileTransferManager.this.destType2Str((byte)1));
            File[] listFiles = destDir.listFiles();
            if (listFiles != null) {
                for (File dest : listFiles) {
                    IOHelper.delete((File)new File(dest, String.valueOf(1)));
                }
            }
            if ((listFiles = (destDir = new File(DefaultFileTransferManager.this.brokerService.getMsgFilesDirectory(), DefaultFileTransferManager.this.destType2Str((byte)2))).listFiles()) != null) {
                for (File dest : listFiles) {
                    IOHelper.delete((File)new File(dest, String.valueOf(1)));
                }
            }
        }

        private void cleanExpiredPersistentFiles(byte destType, long oldestJournalFileMT) {
            File destDir = new File(DefaultFileTransferManager.this.brokerService.getMsgFilesDirectory(), DefaultFileTransferManager.this.destType2Str(destType));
            File[] listFiles = destDir.listFiles();
            if (listFiles != null) {
                for (File dest : listFiles) {
                    File[] persistentFiles;
                    File persistentDir = new File(dest, String.valueOf(2));
                    if (!persistentDir.exists() || (persistentFiles = persistentDir.listFiles()) == null) continue;
                    for (File pFile : persistentFiles) {
                        if (pFile.lastModified() >= oldestJournalFileMT) continue;
                        String uid = pFile.getName();
                        if (pFile.delete()) {
                            LOG.info("Delete expired persistent message file " + pFile.getAbsolutePath() + ", oldestJournalFileMT is " + oldestJournalFileMT);
                            DefaultFileTransferManager.this.sendMetaMap.remove(uid);
                            continue;
                        }
                        LOG.info("Failed to delete expired persistent message file " + pFile.getAbsolutePath() + ", oldestJournalFileMT is " + oldestJournalFileMT);
                    }
                }
            }
        }

        private void cleanExpiredPersistentFiles() throws IOException {
            long oldestJournalFileMT = this.getOldestJournalFileMT();
            if (oldestJournalFileMT == 0L) {
                return;
            }
            this.cleanExpiredPersistentFiles((byte)1, oldestJournalFileMT);
            this.cleanExpiredPersistentFiles((byte)2, oldestJournalFileMT);
        }

        private long getOldestJournalFileMT() throws IOException {
            PersistenceAdapter persistenceAdapter = DefaultFileTransferManager.this.brokerService.getPersistenceAdapter();
            if (!(persistenceAdapter instanceof HSDBPersistenceAdapter)) {
                return 0L;
            }
            final File hsdbDir = persistenceAdapter.getDirectory();
            File[] files = hsdbDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String n) {
                    return dir.equals(hsdbDir) && n.startsWith("db-") && n.endsWith(".log");
                }
            });
            if (files != null && files.length > 0) {
                ArrayList<File> dataFiles = new ArrayList<File>(Arrays.asList(files));
                Collections.sort(dataFiles, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        String name1 = f1.getName();
                        int num1 = Integer.parseInt(name1.substring("db-".length(), name1.length() - ".log".length()));
                        String name2 = f2.getName();
                        int num2 = Integer.parseInt(name2.substring("db-".length(), name2.length() - ".log".length()));
                        return num1 - num2;
                    }
                });
                return ((File)dataFiles.get(0)).lastModified();
            }
            return 0L;
        }
    }

    private class CleanExpiredFilesTask
    extends NamedTask {
        public CleanExpiredFilesTask() {
            super("CleanExpiredFilesTask");
        }

        protected void doRun() {
            DefaultFileTransferManager.this.clean();
        }
    }

    private class SaveFileTransferMetaTask
    extends NamedTask {
        public SaveFileTransferMetaTask() {
            super("SaveFileTransferMetaTask");
        }

        protected void doRun() {
            DefaultFileTransferManager.this.save();
        }
    }
}

