/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.ft;

import com.bes.mq.broker.Connection;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ConsumerBrokerExchange;
import com.bes.mq.broker.InsertableMutableBrokerFilter;
import com.bes.mq.broker.MutableBrokerFilter;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionControl;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessageDispatchNotification;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.RemoveInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.command.TransactionInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.MutexTransport;
import com.bes.mq.transport.ResponseCorrelator;
import com.bes.mq.transport.Transport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class MasterBroker
extends InsertableMutableBrokerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MasterBroker.class);
    private Transport slave;
    private AtomicBoolean started = new AtomicBoolean(false);
    private Map<ConsumerId, ConsumerId> consumers = new ConcurrentHashMap<ConsumerId, ConsumerId>();

    public MasterBroker(MutableBrokerFilter parent, Transport transport) {
        super(parent);
        this.slave = transport;
        this.slave = new MutexTransport(this.slave);
        this.slave = new ResponseCorrelator(this.slave);
        this.slave.setTransportListener(transport.getTransportListener());
    }

    public void startProcessing() {
        this.started.set(true);
        try {
            Connection[] connections = this.getClients();
            ConnectionControl command = new ConnectionControl();
            command.setFaultTolerant(true);
            if (connections != null) {
                for (int i = 0; i < connections.length; ++i) {
                    if (!connections[i].isActive() || !connections[i].isManageable()) continue;
                    connections[i].dispatchAsync(command);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get Connections", e);
        }
    }

    public void stop() throws Exception {
        this.stopProcessing();
    }

    public void stopProcessing() {
        if (this.started.compareAndSet(true, false)) {
            this.remove();
        }
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        super.addConnection(context, info);
        this.sendAsyncToSlave(info);
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        this.sendAsyncToSlave(new RemoveInfo(info.getConnectionId()));
    }

    public void addSession(ConnectionContext context, SessionInfo info) throws Exception {
        super.addSession(context, info);
        this.sendAsyncToSlave(info);
    }

    public void removeSession(ConnectionContext context, SessionInfo info) throws Exception {
        super.removeSession(context, info);
        this.sendAsyncToSlave(new RemoveInfo(info.getSessionId()));
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.addProducer(context, info);
        this.sendAsyncToSlave(info);
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        super.removeProducer(context, info);
        this.sendAsyncToSlave(new RemoveInfo(info.getProducerId()));
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        this.sendSyncToSlave(info);
        this.consumers.put(info.getConsumerId(), info.getConsumerId());
        return super.addConsumer(context, info);
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        super.removeConsumer(context, info);
        this.consumers.remove(info.getConsumerId());
        this.sendSyncToSlave(new RemoveInfo(info.getConsumerId()));
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        super.removeSubscription(context, info);
        this.sendAsyncToSlave(info);
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        super.addDestinationInfo(context, info);
        if (info.getDestination().isTemporary()) {
            this.sendAsyncToSlave(info);
        }
    }

    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        super.removeDestinationInfo(context, info);
        if (info.getDestination().isTemporary()) {
            this.sendAsyncToSlave(info);
        }
    }

    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 0);
        this.sendAsyncToSlave(info);
        super.beginTransaction(context, xid);
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 1);
        this.sendSyncToSlave(info);
        int result = super.prepareTransaction(context, xid);
        return result;
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 4);
        this.sendAsyncToSlave(info);
        super.rollbackTransaction(context, xid);
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 2);
        this.sendSyncToSlave(info);
        super.commitTransaction(context, xid, onePhase);
    }

    public void forgetTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        TransactionInfo info = new TransactionInfo(context.getConnectionId(), xid, 6);
        this.sendAsyncToSlave(info);
        super.forgetTransaction(context, xid);
    }

    public void preProcessDispatch(MessageDispatch messageDispatch) {
        super.preProcessDispatch(messageDispatch);
        MessageDispatchNotification mdn = new MessageDispatchNotification();
        mdn.setConsumerId(messageDispatch.getConsumerId());
        mdn.setDeliverySequenceId(messageDispatch.getDeliverySequenceId());
        mdn.setDestination(messageDispatch.getDestination());
        if (messageDispatch.getMessage() != null) {
            Message msg = messageDispatch.getMessage();
            mdn.setMessageId(msg.getMessageId());
            if (this.consumers.containsKey(messageDispatch.getConsumerId())) {
                this.sendSyncToSlave(mdn);
            }
        }
    }

    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        this.sendSyncToSlave(message.copy());
        super.send(producerExchange, message);
    }

    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        this.sendToSlave(ack);
        super.acknowledge(consumerExchange, ack);
    }

    public boolean isFaultTolerantConfiguration() {
        return true;
    }

    protected void sendToSlave(Message message) {
        if (message.isResponseRequired()) {
            this.sendSyncToSlave(message);
        } else {
            this.sendAsyncToSlave(message);
        }
    }

    protected void sendToSlave(MessageAck ack) {
        if (ack.isResponseRequired()) {
            this.sendAsyncToSlave(ack);
        } else {
            this.sendSyncToSlave(ack);
        }
    }

    protected void sendAsyncToSlave(Command command) {
        try {
            this.slave.oneway(command);
        }
        catch (Throwable e) {
            LOG.error("Slave Failed", e);
            this.stopProcessing();
        }
    }

    protected void sendSyncToSlave(Command command) {
        try {
            Response response = (Response)this.slave.request(command);
            if (response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                LOG.error("Slave Failed", er.getException());
            }
        }
        catch (Throwable e) {
            LOG.error("Slave Failed", e);
        }
    }
}

