/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.ft;

import com.bes.mq.Service;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.BrokerServiceAware;
import com.bes.mq.broker.TransportConnector;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.ShutdownInfo;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.DefaultTransportListener;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportDisposedIOException;
import com.bes.mq.transport.TransportFactory;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.ServiceStopper;
import com.bes.mq.util.ServiceSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MasterConnector
implements Service,
BrokerServiceAware {
    private static final Logger LOG = LoggerFactory.getLogger(MasterConnector.class);
    private BrokerService broker;
    private URI remoteURI;
    private URI localURI;
    private Transport localBroker;
    private Transport remoteBroker;
    private TransportConnector connector;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stoppedBeforeStart = new AtomicBoolean(false);
    private final IdGenerator idGenerator = new IdGenerator();
    private String userName;
    private String password;
    private ConnectionInfo connectionInfo;
    private SessionInfo sessionInfo;
    private ProducerInfo producerInfo;
    private final AtomicBoolean masterActive = new AtomicBoolean();
    private BrokerInfo brokerInfo;
    private boolean firstConnection = true;
    private boolean failedToStart;

    public MasterConnector() {
    }

    public MasterConnector(String remoteUri) throws URISyntaxException {
        this.remoteURI = new URI(remoteUri);
    }

    public void setBrokerService(BrokerService broker) {
        List<TransportConnector> transportConnectors;
        this.broker = broker;
        if (this.localURI == null) {
            this.localURI = broker.getVmConnectorURI();
        }
        if (this.connector == null && !(transportConnectors = broker.getTransportConnectors()).isEmpty()) {
            this.connector = transportConnectors.get(0);
        }
    }

    public boolean isSlave() {
        return this.masterActive.get();
    }

    protected void restartBridge() throws Exception {
        this.localBroker.oneway(this.connectionInfo);
        this.remoteBroker.oneway(this.connectionInfo);
        this.localBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.producerInfo);
        this.remoteBroker.oneway(this.brokerInfo);
    }

    public void start() throws Exception {
        block6: {
            if (!this.started.compareAndSet(false, true)) {
                return;
            }
            if (this.remoteURI == null) {
                throw new IllegalArgumentException("You must specify a remoteURI");
            }
            this.localBroker = TransportFactory.connect(this.localURI);
            this.remoteBroker = TransportFactory.connect(this.remoteURI);
            LOG.info("Starting a slave connection between " + this.localBroker + " and " + this.remoteBroker);
            this.localBroker.setTransportListener(new DefaultTransportListener(){

                public void onCommand(Object command) {
                }

                public void onException(IOException error) {
                    if (MasterConnector.this.started.get()) {
                        MasterConnector.this.serviceLocalException(error);
                    }
                }
            });
            this.remoteBroker.setTransportListener(new DefaultTransportListener(){

                public void onCommand(Object o) {
                    Command command = (Command)o;
                    if (MasterConnector.this.started.get()) {
                        MasterConnector.this.serviceRemoteCommand(command);
                    }
                }

                public void onException(IOException error) {
                    if (MasterConnector.this.started.get()) {
                        MasterConnector.this.serviceRemoteException(error);
                    }
                }

                public void transportResumed() {
                    try {
                        if (!MasterConnector.this.firstConnection) {
                            MasterConnector.this.localBroker = TransportFactory.connect(MasterConnector.this.localURI);
                            MasterConnector.this.localBroker.setTransportListener(new DefaultTransportListener(){

                                public void onCommand(Object command) {
                                }

                                public void onException(IOException error) {
                                    if (MasterConnector.this.started.get()) {
                                        MasterConnector.this.serviceLocalException(error);
                                    }
                                }
                            });
                            MasterConnector.this.localBroker.start();
                            MasterConnector.this.restartBridge();
                            LOG.info("Slave connection between " + MasterConnector.this.localBroker + " and " + MasterConnector.this.remoteBroker + " has been reestablished.");
                        } else {
                            MasterConnector.this.firstConnection = false;
                        }
                    }
                    catch (IOException e) {
                        LOG.error("MasterConnector failed to send BrokerInfo in transportResumed:", e);
                    }
                    catch (Exception e) {
                        LOG.error("MasterConnector failed to restart localBroker in transportResumed:", e);
                    }
                }
            });
            try {
                this.localBroker.start();
                this.remoteBroker.start();
                this.startBridge();
                this.masterActive.set(true);
            }
            catch (Exception e) {
                this.masterActive.set(false);
                if (!this.stoppedBeforeStart.get()) {
                    LOG.error("Failed to start network bridge: " + e, e);
                } else {
                    LOG.info("Slave stopped before connected to the master.");
                }
                this.setFailedToStart(true);
                this.shutDown();
                if (!this.broker.isShutdownOnMasterFailure()) break block6;
                throw e;
            }
        }
    }

    protected void startBridge() throws Exception {
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
        this.connectionInfo.setClientId(this.idGenerator.generateId());
        this.connectionInfo.setUserName(this.userName);
        this.connectionInfo.setPassword(this.password);
        this.connectionInfo.setBrokerMasterConnector(true);
        this.sessionInfo = new SessionInfo(this.connectionInfo, 1L);
        this.producerInfo = new ProducerInfo(this.sessionInfo, 1L);
        this.producerInfo.setResponseRequired(false);
        this.brokerInfo = this.connector != null ? this.connector.getBrokerInfo() : new BrokerInfo();
        this.brokerInfo.setBrokerName(this.broker.getBrokerName());
        this.brokerInfo.setPeerBrokerInfos(this.broker.getBroker().getPeerBrokerInfos());
        this.brokerInfo.setSlaveBroker(true);
        this.brokerInfo.setPassiveSlave(this.broker.isPassiveSlave());
        this.restartBridge();
        LOG.info("Slave connection between " + this.localBroker + " and " + this.remoteBroker + " has been established.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws Exception {
        ServiceStopper ss2222;
        if (!this.started.compareAndSet(true, false)) return;
        if (!this.masterActive.get()) {
            return;
        }
        this.masterActive.set(false);
        try {
            try {
                this.remoteBroker.oneway(new ShutdownInfo());
                this.localBroker.oneway(new ShutdownInfo());
            }
            catch (IOException e) {
                LOG.debug("Caught exception stopping", e);
                Object var3_2 = null;
                ServiceStopper ss2222 = new ServiceStopper();
                ss2222.stop(this.localBroker);
                ss2222.stop(this.remoteBroker);
                ss2222.throwFirstException();
                return;
            }
            Object var3_1 = null;
            ss2222 = new ServiceStopper();
            ss2222.stop(this.localBroker);
            ss2222.stop(this.remoteBroker);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ServiceStopper ss2222 = new ServiceStopper();
            ss2222.stop(this.localBroker);
            ss2222.stop(this.remoteBroker);
            ss2222.throwFirstException();
            throw throwable;
        }
        ss2222.throwFirstException();
    }

    public void stopBeforeConnected() throws Exception {
        this.masterActive.set(false);
        this.started.set(false);
        this.stoppedBeforeStart.set(true);
        ServiceStopper ss = new ServiceStopper();
        ss.stop(this.localBroker);
        ss.stop(this.remoteBroker);
    }

    protected void serviceRemoteException(IOException error) {
        LOG.error("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage(), error);
        this.shutDown();
    }

    protected void serviceRemoteCommand(Command command) {
        try {
            if (command.isMessageDispatch()) {
                MessageDispatch md = (MessageDispatch)command;
                command = md.getMessage();
            }
            if (command.getDataStructureType() == 17) {
                LOG.warn("The Master has shutdown");
                this.shutDown();
            } else {
                boolean responseRequired = command.isResponseRequired();
                int commandId = command.getCommandId();
                if (responseRequired) {
                    Response response = (Response)this.localBroker.request(command);
                    response.setCorrelationId(commandId);
                    this.remoteBroker.oneway(response);
                } else {
                    this.localBroker.oneway(command);
                }
            }
        }
        catch (IOException e) {
            this.serviceRemoteException(e);
        }
    }

    protected void serviceLocalException(Throwable error) {
        if (!(error instanceof TransportDisposedIOException) || this.localBroker.isDisposed()) {
            LOG.info("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage(), error);
            ServiceSupport.dispose(this);
        } else {
            LOG.info(error.getMessage());
        }
    }

    public URI getLocalURI() {
        return this.localURI;
    }

    public void setLocalURI(URI localURI) {
        this.localURI = localURI;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public void setRemoteURI(URI remoteURI) {
        this.remoteURI = remoteURI;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private void shutDown() {
        this.masterActive.set(false);
        this.broker.masterFailed();
        ServiceSupport.dispose(this);
    }

    public boolean isStoppedBeforeStart() {
        return this.stoppedBeforeStart.get();
    }

    public boolean isFailedToStart() {
        return this.failedToStart;
    }

    public void setFailedToStart(boolean failedToStart) {
        this.failedToStart = failedToStart;
    }
}

