/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.jmx.AbortSlowConsumerStrategyViewMBean;
import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.jmx.OpenTypeSupport;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.AbortSlowConsumerStrategy;
import com.bes.mq.broker.region.policy.SlowConsumerEntry;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class AbortSlowConsumerStrategyView
implements AbortSlowConsumerStrategyViewMBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbortSlowConsumerStrategyView.class);
    private ManagedRegionBroker broker;
    private AbortSlowConsumerStrategy strategy;

    public AbortSlowConsumerStrategyView(ManagedRegionBroker managedRegionBroker, AbortSlowConsumerStrategy slowConsumerStrategy) {
        this.broker = managedRegionBroker;
        this.strategy = slowConsumerStrategy;
    }

    public long getMaxSlowCount() {
        return this.strategy.getMaxSlowCount();
    }

    public void setMaxSlowCount(long maxSlowCount) {
        this.strategy.setMaxSlowCount(maxSlowCount);
    }

    public long getMaxSlowDuration() {
        return this.strategy.getMaxSlowDuration();
    }

    public void setMaxSlowDuration(long maxSlowDuration) {
        this.strategy.setMaxSlowDuration(maxSlowDuration);
    }

    public long getCheckPeriod() {
        return this.strategy.getCheckPeriod();
    }

    public TabularData getSlowConsumers() throws OpenDataException {
        OpenTypeSupport.OpenTypeFactory factory = OpenTypeSupport.getFactory(SlowConsumerEntry.class);
        CompositeType ct = factory.getCompositeType();
        TabularType tt = new TabularType("SlowConsumers", "Table of current slow Consumers", ct, new String[]{"subscription"});
        TabularDataSupport rc = new TabularDataSupport(tt);
        boolean index = false;
        Map<Subscription, SlowConsumerEntry> slowConsumers = this.strategy.getSlowConsumers();
        for (Map.Entry<Subscription, SlowConsumerEntry> entry : slowConsumers.entrySet()) {
            entry.getValue().setSubscription(this.broker.getSubscriberObjectName(entry.getKey()));
            rc.put(OpenTypeSupport.convert(entry.getValue()));
        }
        return rc;
    }

    public void abortConsumer(ObjectName consumerToAbort) {
        Subscription sub = this.broker.getSubscriber(consumerToAbort);
        if (sub != null) {
            LOG.info("Aborting consumer via jmx: " + sub.getConsumerInfo().getConsumerId());
            this.strategy.abortConsumer(sub, false);
        } else {
            LOG.warn("Cannot resolve subscription matching name: " + consumerToAbort);
        }
    }

    public void abortConnection(ObjectName consumerToAbort) {
        Subscription sub = this.broker.getSubscriber(consumerToAbort);
        if (sub != null) {
            LOG.info("Aborting consumer connection via jmx: " + sub.getConsumerInfo().getConsumerId().getConnectionId());
            this.strategy.abortConsumer(sub, true);
        } else {
            LOG.warn("Cannot resolve subscription matching name: " + consumerToAbort);
        }
    }

    public void abortConsumer(String objectNameOfConsumerToAbort) {
        this.abortConsumer(this.toObjectName(objectNameOfConsumerToAbort));
    }

    public void abortConnection(String objectNameOfConsumerToAbort) {
        this.abortConnection(this.toObjectName(objectNameOfConsumerToAbort));
    }

    private ObjectName toObjectName(String objectName) {
        ObjectName result = null;
        try {
            result = new ObjectName(objectName);
        }
        catch (Exception e) {
            LOG.warn("Cannot create subscription ObjectName to abort, from string: " + objectName);
        }
        return result;
    }
}

