/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.jmx.AnnotatedMBean;
import com.bes.mq.broker.jmx.ManagementContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAnnotatedMBean
extends AnnotatedMBean {
    private ExecutorService executor;
    private long timeout = 0L;

    public <T> AsyncAnnotatedMBean(ExecutorService executor, long timeout, T impl, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(impl, mbeanInterface);
        this.executor = executor;
        this.timeout = timeout;
    }

    protected AsyncAnnotatedMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    protected Object asyncInvole(String s, Object[] objects, String[] strings) throws MBeanException, ReflectionException {
        return super.invoke(s, objects, strings);
    }

    public static void registerMBean(ExecutorService executor, long timeout, ManagementContext context, Object object, ObjectName objectName) throws Exception {
        if (timeout < 0L && executor != null) {
            throw new IllegalArgumentException("Async timeout cannot be negative.");
        }
        if (timeout > 0L && executor == null) {
            throw new NullPointerException("Timeout given but no ExecutorService instance given.");
        }
        String mbeanName = object.getClass().getName() + "MBean";
        for (Class<?> c : object.getClass().getInterfaces()) {
            if (!mbeanName.equals(c.getName())) continue;
            if (timeout == 0L) {
                context.registerMBean(new AnnotatedMBean(object, c), objectName);
            } else {
                context.registerMBean(new AsyncAnnotatedMBean(executor, timeout, object, c), objectName);
            }
            return;
        }
        context.registerMBean(object, objectName);
    }

    @Override
    public Object invoke(String s, Object[] objects, String[] strings) throws MBeanException, ReflectionException {
        final String action = s;
        final Object[] params = objects;
        final String[] signature = strings;
        Future<Object> task = this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return AsyncAnnotatedMBean.this.asyncInvole(action, params, signature);
            }
        });
        try {
            Object object = task.get(this.timeout, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MBeanException) {
                throw (MBeanException)e.getCause();
            }
            throw new MBeanException(e);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        finally {
            if (!task.isDone()) {
                task.cancel(true);
            }
        }
    }
}

