/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.BESMQConnectionMetaData;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.TransportConnector;
import com.bes.mq.broker.jmx.BrokerViewMBean;
import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.jmx.jvm.JvmUsageGetter;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.network.NetworkConnector;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.util.BrokerSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerView
implements BrokerViewMBean {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerView.class);
    ManagedRegionBroker broker;
    private final BrokerService brokerService;
    private final AtomicInteger sessionIdCounter = new AtomicInteger(0);
    private ObjectName jmsJobScheduler;

    public BrokerView(BrokerService brokerService, ManagedRegionBroker managedBroker) throws Exception {
        this.brokerService = brokerService;
        this.broker = managedBroker;
    }

    public ManagedRegionBroker getBroker() {
        return this.broker;
    }

    public void setBroker(ManagedRegionBroker broker) {
        this.broker = broker;
    }

    @Override
    public String getBrokerId() {
        if (this.broker == null) {
            return null;
        }
        return this.safeGetBroker().getBrokerId().toString();
    }

    @Override
    public String getBrokerName() {
        if (this.broker == null) {
            return null;
        }
        return this.safeGetBroker().getBrokerName();
    }

    @Override
    public String getBrokerVersion() {
        return BESMQConnectionMetaData.PROVIDER_VERSION;
    }

    @Override
    public String getUptime() {
        return this.brokerService.getUptime();
    }

    @Override
    public void gc() throws Exception {
        this.brokerService.getBroker().gc();
        try {
            this.brokerService.getPersistenceAdapter().checkpoint(true);
        }
        catch (IOException e) {
            LOG.error("Failed to checkpoint persistence adapter on gc request, reason:" + e, e);
        }
    }

    @Override
    public void start() throws Exception {
        this.brokerService.start();
    }

    @Override
    public void stop() throws Exception {
        this.brokerService.stop();
    }

    @Override
    public void stopGracefully(String connectorName, String queueName, long timeout, long pollInterval) throws Exception {
        this.brokerService.stopGracefully(connectorName, queueName, timeout, pollInterval);
    }

    @Override
    public long getTotalEnqueueCount() {
        if (this.broker == null) {
            return 0L;
        }
        return this.safeGetBroker().getDestinationStatistics().getEnqueues().getCount();
    }

    @Override
    public long getTotalDequeueCount() {
        if (this.broker == null) {
            return 0L;
        }
        return this.safeGetBroker().getDestinationStatistics().getDequeues().getCount();
    }

    @Override
    public long getTotalConsumerCount() {
        if (this.broker == null) {
            return 0L;
        }
        return this.safeGetBroker().getDestinationStatistics().getConsumers().getCount();
    }

    @Override
    public long getTotalProducerCount() {
        if (this.broker == null) {
            return 0L;
        }
        return this.safeGetBroker().getDestinationStatistics().getProducers().getCount();
    }

    @Override
    public long getTotalMessageCount() {
        if (this.broker == null) {
            return 0L;
        }
        return this.safeGetBroker().getDestinationStatistics().getMessages().getCount();
    }

    public long getTotalMessagesCached() {
        if (this.broker == null) {
            return 0L;
        }
        return this.safeGetBroker().getDestinationStatistics().getMessagesCached().getCount();
    }

    @Override
    public double getMemoryPercentUsage() {
        return BrokerView.format(this.brokerService.getSystemUsage().getMemoryUsage().getAccuratePercentUsage());
    }

    @Override
    public long getMemoryLimit() {
        return this.brokerService.getSystemUsage().getMemoryUsage().getLimit();
    }

    @Override
    public void setMemoryLimit(long limit) {
        this.brokerService.getSystemUsage().getMemoryUsage().setLimit(limit);
    }

    @Override
    public long getStoreLimit() {
        return this.brokerService.getSystemUsage().getStoreUsage().getLimit();
    }

    @Override
    public double getStorePercentUsage() {
        return BrokerView.format(this.brokerService.getSystemUsage().getStoreUsage().getAccuratePercentUsage());
    }

    @Override
    public long getTempLimit() {
        return this.brokerService.getSystemUsage().getTempUsage().getLimit();
    }

    @Override
    public double getTempPercentUsage() {
        return BrokerView.format(this.brokerService.getSystemUsage().getTempUsage().getAccuratePercentUsage());
    }

    @Override
    public void setStoreLimit(long limit) {
        this.brokerService.getSystemUsage().getStoreUsage().setLimit(limit);
    }

    @Override
    public void setTempLimit(long limit) {
        this.brokerService.getSystemUsage().getTempUsage().setLimit(limit);
    }

    @Override
    public void resetStatistics() {
        this.safeGetBroker().getDestinationStatistics().reset();
    }

    @Override
    public void enableStatistics() {
        this.safeGetBroker().getDestinationStatistics().setEnabled(true);
    }

    @Override
    public void disableStatistics() {
        this.safeGetBroker().getDestinationStatistics().setEnabled(false);
    }

    @Override
    public boolean isStatisticsEnabled() {
        if (this.broker != null) {
            return this.safeGetBroker().getDestinationStatistics().isEnabled();
        }
        return false;
    }

    @Override
    public boolean isPersistent() {
        return this.brokerService.isPersistent();
    }

    @Override
    public boolean isSlave() {
        return this.brokerService.isSlave();
    }

    @Override
    public void terminateJVM(int exitCode) {
        System.exit(exitCode);
    }

    @Override
    public ObjectName[] getTopics() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTopics();
    }

    @Override
    public ObjectName[] getQueues() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getQueues();
    }

    @Override
    public ObjectName[] getTemporaryTopics() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTemporaryTopics();
    }

    @Override
    public ObjectName[] getTemporaryQueues() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTemporaryQueues();
    }

    @Override
    public ObjectName[] getTopicSubscribers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTopicSubscribers();
    }

    @Override
    public ObjectName[] getDurableTopicSubscribers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getDurableTopicSubscribers();
    }

    @Override
    public ObjectName[] getQueueSubscribers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getQueueSubscribers();
    }

    @Override
    public ObjectName[] getTemporaryTopicSubscribers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTemporaryTopicSubscribers();
    }

    @Override
    public ObjectName[] getTemporaryQueueSubscribers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTemporaryQueueSubscribers();
    }

    @Override
    public ObjectName[] getInactiveDurableTopicSubscribers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getInactiveDurableTopicSubscribers();
    }

    @Override
    public ObjectName[] getTopicProducers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTopicProducers();
    }

    @Override
    public ObjectName[] getQueueProducers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getQueueProducers();
    }

    @Override
    public ObjectName[] getTemporaryTopicProducers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTemporaryTopicProducers();
    }

    @Override
    public ObjectName[] getTemporaryQueueProducers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getTemporaryQueueProducers();
    }

    @Override
    public ObjectName[] getDynamicDestinationProducers() {
        if (this.broker == null) {
            return new ObjectName[0];
        }
        return this.safeGetBroker().getDynamicDestinationProducers();
    }

    @Override
    public String addConnector(String discoveryAddress) throws Exception {
        TransportConnector connector = this.brokerService.addConnector(discoveryAddress);
        if (connector == null) {
            throw new NoSuchElementException("No connector matched the given name: " + discoveryAddress);
        }
        connector.start();
        return connector.getName();
    }

    @Override
    public String addNetworkConnector(String discoveryAddress) throws Exception {
        NetworkConnector connector = this.brokerService.addNetworkConnector(discoveryAddress);
        if (connector == null) {
            throw new NoSuchElementException("No connector matched the given name: " + discoveryAddress);
        }
        connector.start();
        return connector.getName();
    }

    @Override
    public boolean removeConnector(String connectorName) throws Exception {
        TransportConnector connector = this.brokerService.getConnectorByName(connectorName);
        if (connector == null) {
            throw new NoSuchElementException("No connector matched the given name: " + connectorName);
        }
        connector.stop();
        return this.brokerService.removeConnector(connector);
    }

    @Override
    public boolean removeNetworkConnector(String connectorName) throws Exception {
        NetworkConnector connector = this.brokerService.getNetworkConnectorByName(connectorName);
        if (connector == null) {
            throw new NoSuchElementException("No connector matched the given name: " + connectorName);
        }
        connector.stop();
        return this.brokerService.removeNetworkConnector(connector);
    }

    @Override
    public void addTopic(String name) throws Exception {
        this.safeGetBroker().getContextBroker().addDestination(BrokerSupport.getConnectionContext(this.safeGetBroker().getContextBroker()), new BESMQTopic(name), true);
    }

    @Override
    public void addQueue(String name) throws Exception {
        this.safeGetBroker().getContextBroker().addDestination(BrokerSupport.getConnectionContext(this.safeGetBroker().getContextBroker()), new BESMQQueue(name), true);
    }

    @Override
    public void removeTopic(String name) throws Exception {
        this.safeGetBroker().getContextBroker().removeDestination(BrokerSupport.getConnectionContext(this.safeGetBroker().getContextBroker()), new BESMQTopic(name), 1000L);
    }

    @Override
    public void removeQueue(String name) throws Exception {
        this.safeGetBroker().getContextBroker().removeDestination(BrokerSupport.getConnectionContext(this.safeGetBroker().getContextBroker()), new BESMQQueue(name), 1000L);
    }

    @Override
    public ObjectName createDurableSubscriber(String clientId, String subscriberName, String topicName, String selector) throws Exception {
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.safeGetBroker());
        context.setClientId(clientId);
        ConsumerInfo info = new ConsumerInfo();
        ConsumerId consumerId = new ConsumerId();
        consumerId.setConnectionId(clientId);
        consumerId.setSessionId(this.sessionIdCounter.incrementAndGet());
        consumerId.setValue(0L);
        info.setConsumerId(consumerId);
        info.setDestination(new BESMQTopic(topicName));
        info.setSubscriptionName(subscriberName);
        info.setSelector(selector);
        Subscription subscription = this.safeGetBroker().addConsumer(context, info);
        this.safeGetBroker().removeConsumer(context, info);
        if (subscription != null) {
            return subscription.getObjectName();
        }
        return null;
    }

    @Override
    public void destroyDurableSubscriber(String clientId, String subscriberName) throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(clientId);
        info.setSubscriptionName(subscriberName);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.safeGetBroker());
        context.setClientId(clientId);
        this.safeGetBroker().removeSubscription(context, info);
    }

    @Override
    public void reloadLog4jProperties() throws Throwable {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> logManagerClass = cl.loadClass("org.apache.log4j.LogManager");
            Method resetConfiguration = logManagerClass.getMethod("resetConfiguration", new Class[0]);
            resetConfiguration.invoke(null, new Object[0]);
            String configurationOptionStr = System.getProperty("log4j.configuration");
            URL log4jprops = null;
            if (configurationOptionStr != null) {
                try {
                    log4jprops = new URL(configurationOptionStr);
                }
                catch (MalformedURLException ex) {
                    log4jprops = cl.getResource("log4j.properties");
                }
            } else {
                log4jprops = cl.getResource("log4j.properties");
            }
            if (log4jprops != null) {
                Class<?> propertyConfiguratorClass = cl.loadClass("org.apache.log4j.PropertyConfigurator");
                Method configure = propertyConfiguratorClass.getMethod("configure", URL.class);
                configure.invoke(null, log4jprops);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @Override
    public Map<String, String> getTransportConnectors() {
        HashMap<String, String> answer = new HashMap<String, String>();
        try {
            for (TransportConnector connector : this.brokerService.getTransportConnectors()) {
                answer.put(connector.getName(), connector.getConnectUri().toString());
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to read URI to build transport connectors map", e);
        }
        return answer;
    }

    @Override
    public String getTransportConnectorByType(String type) {
        return this.brokerService.getTransportConnectorURIsAsMap().get(type);
    }

    @Override
    @Deprecated
    public String getBESMPURL() {
        String answer = this.brokerService.getTransportConnectorURIsAsMap().get("tcp");
        return answer != null ? answer : "";
    }

    @Override
    @Deprecated
    public String getStompURL() {
        String answer = this.brokerService.getTransportConnectorURIsAsMap().get("stomp");
        return answer != null ? answer : "";
    }

    @Override
    @Deprecated
    public String getSslURL() {
        String answer = this.brokerService.getTransportConnectorURIsAsMap().get("ssl");
        return answer != null ? answer : "";
    }

    @Override
    @Deprecated
    public String getStompSslURL() {
        String answer = this.brokerService.getTransportConnectorURIsAsMap().get("stomp+ssl");
        return answer != null ? answer : "";
    }

    @Override
    public String getVMURL() {
        URI answer = this.brokerService.getVmConnectorURI();
        return answer != null ? answer.toString() : "";
    }

    @Override
    public String getDataDirectory() {
        File file = this.brokerService.getDataDirectoryFile();
        try {
            return file != null ? file.getCanonicalPath() : "";
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public ObjectName getJMSJobScheduler() {
        return this.jmsJobScheduler;
    }

    public void setJMSJobScheduler(ObjectName name) {
        this.jmsJobScheduler = name;
    }

    private ManagedRegionBroker safeGetBroker() {
        if (this.broker == null) {
            throw new IllegalStateException("No Access: Broker is not yet started or broker is a slave broker.");
        }
        return this.broker;
    }

    @Override
    public double getCpuPercentUsage() {
        return BrokerView.format(JvmUsageGetter.getCpuUsage());
    }

    @Override
    public double getHeapMemoryPercentUsage() {
        return BrokerView.format(JvmUsageGetter.getMemoryUsage());
    }

    private static double format(double d) {
        NumberFormat ni = NumberFormat.getNumberInstance();
        ni.setMaximumFractionDigits(2);
        return Double.valueOf(ni.format(d));
    }
}

