/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.Service;
import com.bes.mq.broker.jmx.MBeanInfo;
import java.util.Map;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BrokerViewMBean
extends Service {
    @MBeanInfo(value="The unique id of the broker.")
    public String getBrokerId();

    @MBeanInfo(value="The name of the broker.")
    public String getBrokerName();

    @MBeanInfo(value="The version of the broker.")
    public String getBrokerVersion();

    @MBeanInfo(value="Uptime of the broker.")
    public String getUptime();

    @MBeanInfo(value="Runs the Garbage Collector.", impact=1)
    public void gc() throws Exception;

    @MBeanInfo(value="Reset all broker statistics.", impact=1)
    public void resetStatistics();

    @MBeanInfo(value="Enable broker statistics.", impact=1)
    public void enableStatistics();

    @MBeanInfo(value="Disable broker statistics.", impact=1)
    public void disableStatistics();

    @MBeanInfo(value="Broker statistics enabled.")
    public boolean isStatisticsEnabled();

    @MBeanInfo(value="Number of messages that have been sent to the broker.")
    public long getTotalEnqueueCount();

    @MBeanInfo(value="Number of messages that have been acknowledged on the broker.")
    public long getTotalDequeueCount();

    @MBeanInfo(value="Number of message consumers subscribed to destinations on the broker.")
    public long getTotalConsumerCount();

    @MBeanInfo(value="Number of message producers active on destinations on the broker.")
    public long getTotalProducerCount();

    @MBeanInfo(value="Number of unacknowledged messages on the broker.")
    public long getTotalMessageCount();

    @MBeanInfo(value="Percent of memory limit used.")
    public double getMemoryPercentUsage();

    @MBeanInfo(value="Memory limit, in bytes, used for holding undelivered messages before paging to temporary storage.")
    public long getMemoryLimit();

    public void setMemoryLimit(@MBeanInfo(value="bytes") long var1);

    @MBeanInfo(value="Percent of store limit used.")
    public double getStorePercentUsage();

    @MBeanInfo(value="Disk limit, in bytes, used for persistent messages before producers are blocked.")
    public long getStoreLimit();

    public void setStoreLimit(@MBeanInfo(value="bytes") long var1);

    @MBeanInfo(value="Percent of temp limit used.")
    public double getTempPercentUsage();

    @MBeanInfo(value="Disk limit, in bytes, used for non-persistent messages and temporary date before producers are blocked.")
    public long getTempLimit();

    public void setTempLimit(@MBeanInfo(value="bytes") long var1);

    @MBeanInfo(value="Messages are synchronized to disk.")
    public boolean isPersistent();

    @MBeanInfo(value="Slave broker.")
    public boolean isSlave();

    @MBeanInfo(value="Shuts down the JVM.", impact=1)
    public void terminateJVM(@MBeanInfo(value="exitCode") int var1);

    @Override
    @MBeanInfo(value="Stop the broker and all its components.", impact=1)
    public void stop() throws Exception;

    @MBeanInfo(value="Poll for queues matching queueName are empty before stopping", impact=1)
    public void stopGracefully(String var1, String var2, long var3, long var5) throws Exception;

    @MBeanInfo(value="Topics (broadcasted 'queues'); generally system information.")
    public ObjectName[] getTopics();

    @MBeanInfo(value="Standard Queues containing AIE messages.")
    public ObjectName[] getQueues();

    @MBeanInfo(value="Temporary Topics; generally unused.")
    public ObjectName[] getTemporaryTopics();

    @MBeanInfo(value="Temporary Queues; generally temporary message response holders.")
    public ObjectName[] getTemporaryQueues();

    @MBeanInfo(value="Topic Subscribers")
    public ObjectName[] getTopicSubscribers();

    @MBeanInfo(value="Durable (persistent) topic subscribers")
    public ObjectName[] getDurableTopicSubscribers();

    @MBeanInfo(value="Inactive (disconnected persistent) topic subscribers")
    public ObjectName[] getInactiveDurableTopicSubscribers();

    @MBeanInfo(value="Queue Subscribers.")
    public ObjectName[] getQueueSubscribers();

    @MBeanInfo(value="Temporary Topic Subscribers.")
    public ObjectName[] getTemporaryTopicSubscribers();

    @MBeanInfo(value="Temporary Queue Subscribers.")
    public ObjectName[] getTemporaryQueueSubscribers();

    @MBeanInfo(value="Topic Producers.")
    public ObjectName[] getTopicProducers();

    @MBeanInfo(value="Queue Producers.")
    public ObjectName[] getQueueProducers();

    @MBeanInfo(value="Temporary Topic Producers.")
    public ObjectName[] getTemporaryTopicProducers();

    @MBeanInfo(value="Temporary Queue Producers.")
    public ObjectName[] getTemporaryQueueProducers();

    @MBeanInfo(value="Dynamic Destination Producers.")
    public ObjectName[] getDynamicDestinationProducers();

    @MBeanInfo(value="Adds a Connector to the broker.", impact=1)
    public String addConnector(@MBeanInfo(value="discoveryAddress") String var1) throws Exception;

    @MBeanInfo(value="Adds a Cluster Connector to the broker.", impact=1)
    public String addNetworkConnector(@MBeanInfo(value="discoveryAddress") String var1) throws Exception;

    @MBeanInfo(value="Removes a Connector from the broker.", impact=1)
    public boolean removeConnector(@MBeanInfo(value="connectorName") String var1) throws Exception;

    @MBeanInfo(value="Removes a Cluster Connector from the broker.", impact=1)
    public boolean removeNetworkConnector(@MBeanInfo(value="connectorName") String var1) throws Exception;

    @MBeanInfo(value="Adds a Topic destination to the broker.", impact=1)
    public void addTopic(@MBeanInfo(value="name") String var1) throws Exception;

    @MBeanInfo(value="Adds a Queue destination to the broker.", impact=1)
    public void addQueue(@MBeanInfo(value="name") String var1) throws Exception;

    @MBeanInfo(value="Removes a Topic destination from the broker.", impact=1)
    public void removeTopic(@MBeanInfo(value="name") String var1) throws Exception;

    @MBeanInfo(value="Removes a Queue destination from the broker.", impact=1)
    public void removeQueue(@MBeanInfo(value="name") String var1) throws Exception;

    @MBeanInfo(value="Creates a new durable topic subscriber.", impact=1)
    public ObjectName createDurableSubscriber(@MBeanInfo(value="clientId") String var1, @MBeanInfo(value="subscriberName") String var2, @MBeanInfo(value="topicName") String var3, @MBeanInfo(value="selector") String var4) throws Exception;

    @MBeanInfo(value="Destroys a durable subscriber.", impact=1)
    public void destroyDurableSubscriber(@MBeanInfo(value="clientId") String var1, @MBeanInfo(value="subscriberName") String var2) throws Exception;

    @MBeanInfo(value="Reloads log4j.properties from the classpath.", impact=1)
    public void reloadLog4jProperties() throws Throwable;

    @Deprecated
    @MBeanInfo(value="The url of the besmp connector - deprecated, use getTransportConnectors or getTransportConnectorByType instead")
    public String getBESMPURL();

    @Deprecated
    @MBeanInfo(value="The url of the stomp connector - deprecated, use getTransportConnectors or getTransportConnectorByType instead")
    public String getStompURL();

    @Deprecated
    @MBeanInfo(value="The url of the SSL connector - deprecated, use getTransportConnectors or getTransportConnectorByType instead")
    public String getSslURL();

    @Deprecated
    @MBeanInfo(value="The url of the Stomp SSL connector - deprecated, use getTransportConnectors or getTransportConnectorByType instead")
    public String getStompSslURL();

    @MBeanInfo(value="The url of the VM connector")
    public String getVMURL();

    @MBeanInfo(value="The map of all defined transport connectors, with transport name as a key")
    public Map<String, String> getTransportConnectors();

    @MBeanInfo(value="The url of transport connector by it's type; e.g. tcp, stomp, ssl, etc.")
    public String getTransportConnectorByType(String var1);

    @MBeanInfo(value="The location of the data directory")
    public String getDataDirectory();

    @MBeanInfo(value="JMSJobScheduler")
    public ObjectName getJMSJobScheduler();

    @MBeanInfo(value="getCpuPercentUsage")
    public double getCpuPercentUsage();

    @MBeanInfo(value="getHeapMemoryPercentUsage")
    public double getHeapMemoryPercentUsage();
}

