/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.Connection;
import com.bes.mq.broker.jmx.ConnectionViewMBean;
import com.bes.mq.broker.jmx.ManagementContext;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.JMXSupport;
import java.io.IOException;
import java.util.Set;
import javax.management.ObjectName;

public class ConnectionView
implements ConnectionViewMBean {
    private final Connection connection;
    private final ManagementContext managementContext;
    private String userName;

    public ConnectionView(Connection connection) {
        this(connection, null);
    }

    public ConnectionView(Connection connection, ManagementContext managementContext) {
        this.connection = connection;
        this.managementContext = managementContext;
    }

    public void start() throws Exception {
        this.connection.start();
    }

    public void stop() throws Exception {
        this.connection.stop();
    }

    public boolean isSlow() {
        return this.connection.isSlow();
    }

    public boolean isBlocked() {
        return this.connection.isBlocked();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public boolean isActive() {
        return this.connection.isActive();
    }

    public int getDispatchQueueSize() {
        return this.connection.getDispatchQueueSize();
    }

    public void resetStatistics() {
        this.connection.getStatistics().reset();
    }

    public String getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public String getConnectionId() {
        return this.connection.getConnectionId();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ObjectName[] getConsumers() {
        ObjectName[] result = null;
        if (this.connection != null && this.managementContext != null) {
            try {
                ObjectName query = this.createConsumerQueury(this.connection.getConnectionId());
                Set<ObjectName> names = this.managementContext.queryNames(query, null);
                result = names.toArray(new ObjectName[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public ObjectName[] getProducers() {
        ObjectName[] result = null;
        if (this.connection != null && this.managementContext != null) {
            try {
                ObjectName query = this.createProducerQueury(this.connection.getConnectionId());
                Set<ObjectName> names = this.managementContext.queryNames(query, null);
                result = names.toArray(new ObjectName[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private ObjectName createConsumerQueury(String clientId) throws IOException {
        try {
            return new ObjectName(this.managementContext.getJmxDomainName() + ":" + "BrokerName=*," + "Type=Subscription,persistentMode=*," + "destinationType=*,destinationName=*," + "clientId=" + JMXSupport.encodeObjectNamePart(clientId) + "," + "consumerId=*");
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }

    private ObjectName createProducerQueury(String clientId) throws IOException {
        try {
            return new ObjectName(this.managementContext.getJmxDomainName() + ":" + "BrokerName=*," + "Type=Producer," + "destinationType=*,destinationName=*," + "clientId=" + JMXSupport.encodeObjectNamePart(clientId) + "," + "producerId=*");
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }
}

