/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.jmx.DurableSubscriptionViewMBean;
import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.jmx.SubscriptionView;
import com.bes.mq.broker.region.DurableTopicSubscription;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.cursors.StoreDurableSubscriberCursor;
import com.bes.mq.command.RemoveSubscriptionInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public class DurableSubscriptionView
extends SubscriptionView
implements DurableSubscriptionViewMBean {
    protected ManagedRegionBroker broker;
    protected String subscriptionName;
    protected DurableTopicSubscription durableSub;

    public DurableSubscriptionView(ManagedRegionBroker broker, String clientId, String userName, Subscription sub) {
        super(clientId, userName, sub);
        this.broker = broker;
        this.durableSub = (DurableTopicSubscription)sub;
        if (sub != null) {
            this.subscriptionName = sub.getConsumerInfo().getSubscriptionName();
        }
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public CompositeData[] browse() throws OpenDataException {
        return this.broker.browse(this);
    }

    public TabularData browseAsTable() throws OpenDataException {
        return this.broker.browseAsTable(this);
    }

    public void destroy() throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(this.clientId);
        info.setSubscriptionName(this.subscriptionName);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(this.clientId);
        this.broker.removeSubscription(context, info);
    }

    public String toString() {
        return "ActiveDurableSubscriptionView: " + this.getClientId() + ":" + this.getSubscriptionName();
    }

    public int cursorSize() {
        if (this.durableSub != null && this.durableSub.getPending() != null) {
            return this.durableSub.getPending().size();
        }
        return 0;
    }

    public boolean doesCursorHaveMessagesBuffered() {
        if (this.durableSub != null && this.durableSub.getPending() != null) {
            return this.durableSub.getPending().hasMessagesBufferedToDeliver();
        }
        return false;
    }

    public boolean doesCursorHaveSpace() {
        if (this.durableSub != null && this.durableSub.getPending() != null) {
            return this.durableSub.getPending().hasSpace();
        }
        return false;
    }

    public long getCursorMemoryUsage() {
        if (this.durableSub != null && this.durableSub.getPending() != null && this.durableSub.getPending().getSystemUsage() != null) {
            return this.durableSub.getPending().getSystemUsage().getMemoryUsage().getUsage();
        }
        return 0L;
    }

    public double getCursorPercentUsage() {
        if (this.durableSub != null && this.durableSub.getPending() != null && this.durableSub.getPending().getSystemUsage() != null) {
            return this.durableSub.getPending().getSystemUsage().getMemoryUsage().getAccuratePercentUsage();
        }
        return 0.0;
    }

    public boolean isCursorFull() {
        if (this.durableSub != null && this.durableSub.getPending() != null) {
            return this.durableSub.getPending().isFull();
        }
        return false;
    }

    public boolean isActive() {
        return this.durableSub.isActive();
    }

    public long getCursorDuplicateMessagesFromProducer() {
        if (this.durableSub.getPending() instanceof StoreDurableSubscriberCursor) {
            return ((StoreDurableSubscriberCursor)this.durableSub.getPending()).getDuplicateMessagesFromProducer();
        }
        return 0L;
    }

    public long getCursorDuplicateMessagesFromStore() {
        if (this.durableSub.getPending() instanceof StoreDurableSubscriberCursor) {
            return ((StoreDurableSubscriberCursor)this.durableSub.getPending()).getDuplicateMessagesFromStore();
        }
        return 0L;
    }
}

