/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.jmx.DurableSubscriptionView;
import com.bes.mq.broker.jmx.DurableSubscriptionViewMBean;
import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.SubscriptionInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public class InactiveDurableSubscriptionView
extends DurableSubscriptionView
implements DurableSubscriptionViewMBean {
    protected SubscriptionInfo subscriptionInfo;

    public InactiveDurableSubscriptionView(ManagedRegionBroker broker, String clientId, SubscriptionInfo subInfo, Subscription subscription) {
        super(broker, clientId, null, subscription);
        this.broker = broker;
        this.subscriptionInfo = subInfo;
    }

    public long getSubcriptionId() {
        return -1L;
    }

    public String getDestinationName() {
        return this.subscriptionInfo.getDestination().getPhysicalName();
    }

    public boolean isDestinationQueue() {
        return false;
    }

    public boolean isDestinationTopic() {
        return true;
    }

    public boolean isDestinationTemporary() {
        return false;
    }

    public String getSubscriptionName() {
        return this.subscriptionInfo.getSubscriptionName();
    }

    public boolean isActive() {
        return false;
    }

    protected ConsumerInfo getConsumerInfo() {
        return null;
    }

    public CompositeData[] browse() throws OpenDataException {
        return this.broker.browse(this);
    }

    public TabularData browseAsTable() throws OpenDataException {
        return this.broker.browseAsTable(this);
    }

    public void destroy() throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(this.clientId);
        info.setSubscriptionName(this.subscriptionInfo.getSubscriptionName());
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(this.clientId);
        this.broker.removeSubscription(context, info);
    }

    public String toString() {
        return "InactiveDurableSubscriptionView: " + this.getClientId() + ":" + this.getSubscriptionName();
    }

    public String getSelector() {
        return this.subscriptionInfo.getSelector();
    }
}

