/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFactory;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.TempQueueRegion;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.usage.SystemUsage;
import javax.jms.JMSException;
import javax.management.ObjectName;

public class ManagedTempQueueRegion
extends TempQueueRegion {
    private final ManagedRegionBroker regionBroker;

    public ManagedTempQueueRegion(ManagedRegionBroker broker, BrokerService brokerService, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        super(broker, brokerService, destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
        this.regionBroker = broker;
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        Subscription sub = super.createSubscription(context, info);
        ObjectName name = this.regionBroker.registerSubscription(context, sub);
        sub.setObjectName(name);
        return sub;
    }

    protected void destroySubscription(Subscription sub) {
        this.regionBroker.unregisterSubscription(sub);
        super.destroySubscription(sub);
    }

    protected Destination createDestination(ConnectionContext context, BESMQDestination destination) throws Exception {
        Destination rc = super.createDestination(context, destination);
        this.regionBroker.register(destination, rc);
        return rc;
    }

    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, destination, timeout);
        this.regionBroker.unregister(destination);
    }
}

