/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.TransportConnection;
import com.bes.mq.broker.TransportConnector;
import com.bes.mq.broker.jmx.AnnotatedMBean;
import com.bes.mq.broker.jmx.ConnectionView;
import com.bes.mq.broker.jmx.ConnectionViewMBean;
import com.bes.mq.broker.jmx.ManagementContext;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.Response;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.transport.Transport;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.JMXSupport;
import java.io.IOException;
import java.util.Hashtable;
import javax.management.ObjectName;

public class ManagedTransportConnection
extends TransportConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedTransportConnection.class);
    private final ManagementContext managementContext;
    private final ObjectName connectorName;
    private ConnectionViewMBean mbean;
    private ObjectName byClientIdName;
    private ObjectName byAddressName;
    private final boolean populateUserName;

    public ManagedTransportConnection(TransportConnector connector, Transport transport, Broker broker, TaskRunnerFactory factory, TaskRunnerFactory stopFactory, ManagementContext context, ObjectName connectorName) throws IOException {
        super(connector, transport, broker, factory, stopFactory);
        this.managementContext = context;
        this.connectorName = connectorName;
        this.mbean = new ConnectionView(this, this.managementContext);
        this.populateUserName = broker.getBrokerService().isPopulateUserNameInMBeans();
        if (this.managementContext.isAllowRemoteAddressInMBeanNames()) {
            this.byAddressName = this.createByAddressObjectName("address", transport.getRemoteAddress());
            this.registerMBean(this.byAddressName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAsync() {
        if (!this.isStopping()) {
            ManagedTransportConnection managedTransportConnection = this;
            synchronized (managedTransportConnection) {
                this.unregisterMBean(this.byClientIdName);
                this.unregisterMBean(this.byAddressName);
                this.byClientIdName = null;
                this.byAddressName = null;
            }
        }
        super.stopAsync();
    }

    public Response processAddConnection(ConnectionInfo info) throws Exception {
        Response answer = super.processAddConnection(info);
        String clientId = info.getClientId();
        if (this.populateUserName) {
            ((ConnectionView)this.mbean).setUserName(info.getUserName());
        }
        if (clientId != null && this.byClientIdName == null) {
            this.byClientIdName = this.createByClientIdObjectName(clientId);
            this.registerMBean(this.byClientIdName);
        }
        return answer;
    }

    protected void registerMBean(ObjectName name) {
        if (name != null) {
            try {
                AnnotatedMBean.registerMBean(this.managementContext, this.mbean, name);
            }
            catch (Throwable e) {
                LOG.warn("Failed to register MBean: " + name);
                LOG.debug("Failure reason: " + e, e);
            }
        }
    }

    protected void unregisterMBean(ObjectName name) {
        if (name != null) {
            try {
                this.managementContext.unregisterMBean(name);
            }
            catch (Throwable e) {
                LOG.warn("Failed to unregister mbean: " + name);
                LOG.debug("Failure reason: " + e, e);
            }
        }
    }

    protected ObjectName createByAddressObjectName(String type, String value) throws IOException {
        Hashtable<String, String> map = this.connectorName.getKeyPropertyList();
        try {
            return new ObjectName(this.connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(map.get("BrokerName")) + "," + "Type=Connection," + "ConnectorName=" + JMXSupport.encodeObjectNamePart(map.get("ConnectorName")) + "," + "ViewType=" + JMXSupport.encodeObjectNamePart(type) + "," + "Name=" + JMXSupport.encodeObjectNamePart(value));
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected ObjectName createByClientIdObjectName(String value) throws IOException {
        Hashtable<String, String> map = this.connectorName.getKeyPropertyList();
        try {
            return new ObjectName(this.connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(map.get("BrokerName")) + "," + "Type=Connection," + "ConnectorName=" + JMXSupport.encodeObjectNamePart(map.get("ConnectorName")) + "," + "Connection=" + JMXSupport.encodeObjectNamePart(value));
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }
}

