/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.Service;
import com.bes.mq.common.universal.net.NetUtils;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.org.slf4j.MDC;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementContext
implements Service {
    public static final String DEFAULT_DOMAIN = "com.bes.mq";
    private static final Logger LOG = LoggerFactory.getLogger(ManagementContext.class);
    private MBeanServer beanServer;
    private String jmxDomainName = "com.bes.mq";
    private boolean useMBeanServer = true;
    private boolean createMBeanServer = true;
    private boolean locallyCreateMBeanServer;
    private boolean createConnector = Boolean.parseBoolean(System.getProperty("com.bes.mq.enable.jmxAndJndi", "true"));
    private boolean findTigerMbeanServer = true;
    private String listenAddress = "localhost";
    private String publishHostname = "localhost";
    private int listenPort = 3100;
    private Map environment = Collections.EMPTY_MAP;
    private int rmiServerPort;
    private String connectorPath = "/jmxrmi";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean connectorStarting = new AtomicBoolean(false);
    private JMXConnectorServer connectorServer;
    private Registry registry;
    private final Map<ObjectName, ObjectName> registeredMBeanNames = new ConcurrentHashMap<ObjectName, ObjectName>();
    private boolean allowRemoteAddressInMBeanNames = true;
    private String brokerName;
    private boolean connectorFailAware;

    public ManagementContext() {
        this(null);
    }

    public ManagementContext(MBeanServer server) {
        this.beanServer = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException, MalformedObjectNameException {
        block15: {
            if (this.started.compareAndSet(false, true)) {
                if (this.listenAddress == null) {
                    this.listenAddress = "localhost";
                }
                this.getMBeanServer();
                if (this.createConnector && this.connectorServer == null) {
                    this.createConnector(this.beanServer);
                }
                if (this.connectorServer != null) {
                    if (this.brokerName != null) {
                        MDC.put("besmq.broker", this.brokerName);
                    }
                    try {
                        JMXConnectorServer server = this.connectorServer;
                        if (!this.started.get() || server == null) break block15;
                        LOG.debug("Starting JMXConnectorServer...");
                        this.connectorStarting.set(true);
                        try {
                            MDC.remove("besmq.broker");
                            server.start();
                        }
                        finally {
                            if (this.brokerName != null) {
                                MDC.put("besmq.broker", this.brokerName);
                            }
                            this.connectorStarting.set(false);
                        }
                        this.checkJMXConnectorURL();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to start jmx connector: " + e.getMessage() + ". Will restart management to re-create jmx connector, " + "trying to remedy this issue.");
                        if (this.connectorFailAware) {
                            throw e;
                        }
                    }
                    finally {
                        MDC.remove("besmq.broker");
                    }
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        Object serverSocketFactory;
        if (this.started.compareAndSet(true, false)) {
            ArrayList<MBeanServer> list;
            MBeanServer mbeanServer = this.getMBeanServer();
            if (mbeanServer != null) {
                for (Map.Entry<ObjectName, ObjectName> entry : this.registeredMBeanNames.entrySet()) {
                    ObjectName actualName = entry.getValue();
                    if (actualName == null || !this.beanServer.isRegistered(actualName)) continue;
                    LOG.debug("Unregistering MBean {}", actualName);
                    mbeanServer.unregisterMBean(actualName);
                }
            }
            this.registeredMBeanNames.clear();
            JMXConnectorServer server = this.connectorServer;
            this.connectorServer = null;
            if (server != null) {
                try {
                    if (!this.connectorStarting.get()) {
                        LOG.debug("Stopping jmx connector");
                        server.stop();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to stop jmx connector: " + e.getMessage());
                }
            }
            if (this.locallyCreateMBeanServer && this.beanServer != null && (list = MBeanServerFactory.findMBeanServer(null)) != null && !list.isEmpty() && list.contains(this.beanServer)) {
                LOG.debug("Releasing MBeanServer {}", this.beanServer);
                MBeanServerFactory.releaseMBeanServer(this.beanServer);
            }
            this.beanServer = null;
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            catch (NoSuchObjectException e) {
                // empty catch block
            }
        }
        this.registry = null;
        if (this.environment != null && (serverSocketFactory = this.environment.get("jmx.remote.rmi.server.socket.factory")) instanceof Closeable) {
            try {
                ((Closeable)serverSocketFactory).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public MBeanServer getMBeanServer() {
        if (this.beanServer == null) {
            this.beanServer = this.findMBeanServer();
        }
        return this.beanServer;
    }

    public void setMBeanServer(MBeanServer beanServer) {
        this.beanServer = beanServer;
    }

    public boolean isUseMBeanServer() {
        return this.useMBeanServer;
    }

    public void setUseMBeanServer(boolean useMBeanServer) {
        this.useMBeanServer = useMBeanServer;
    }

    public boolean isCreateMBeanServer() {
        return this.createMBeanServer;
    }

    public void setCreateMBeanServer(boolean enableJMX) {
        this.createMBeanServer = enableJMX;
    }

    public boolean isFindTigerMbeanServer() {
        return this.findTigerMbeanServer;
    }

    public boolean isConnectorStarted() {
        return this.connectorStarting.get() || this.connectorServer != null && this.connectorServer.isActive();
    }

    public void setFindTigerMbeanServer(boolean findTigerMbeanServer) {
        this.findTigerMbeanServer = findTigerMbeanServer;
    }

    public ObjectName createCustomComponentMBeanName(String type, String name) {
        ObjectName result = null;
        String tmp = this.jmxDomainName + ":" + "type=" + ManagementContext.sanitizeString(type) + ",name=" + ManagementContext.sanitizeString(name);
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Couldn't create ObjectName from: " + type + " , " + name);
        }
        return result;
    }

    private static String sanitizeString(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
        }
        return result;
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class theClass) throws MalformedObjectNameException, NullPointerException {
        String tmp = domainName + ":" + "type=" + theClass.getName() + ",name=" + ManagementContext.getRelativeName(containerName, theClass);
        return new ObjectName(tmp);
    }

    private static String getRelativeName(String containerName, Class theClass) {
        String name = theClass.getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return containerName + "." + name;
    }

    public Object newProxyInstance(ObjectName objectName, Class interfaceClass, boolean notificationBroadcaster) {
        return MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServer(), objectName, interfaceClass, notificationBroadcaster);
    }

    public Object getAttribute(ObjectName name, String attribute) throws Exception {
        return this.getMBeanServer().getAttribute(name, attribute);
    }

    public ObjectInstance registerMBean(Object bean, ObjectName name) throws Exception {
        ObjectInstance result = this.getMBeanServer().registerMBean(bean, name);
        this.registeredMBeanNames.put(name, result.getObjectName());
        return result;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws Exception {
        ObjectName actualName;
        if (name != null && (actualName = this.registeredMBeanNames.get(name)) != null) {
            return this.getMBeanServer().queryNames(actualName, query);
        }
        return this.getMBeanServer().queryNames(name, query);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.getMBeanServer().getObjectInstance(name);
    }

    public void unregisterMBean(ObjectName name) throws JMException {
        ObjectName actualName = this.registeredMBeanNames.get(name);
        if (this.beanServer != null && actualName != null && this.beanServer.isRegistered(actualName) && this.registeredMBeanNames.remove(name) != null) {
            LOG.debug("Unregistering MBean {}", actualName);
            this.beanServer.unregisterMBean(actualName);
        }
    }

    protected synchronized MBeanServer findMBeanServer() {
        MBeanServer result = null;
        try {
            if (this.useMBeanServer) {
                ArrayList<MBeanServer> list;
                if (this.findTigerMbeanServer) {
                    result = this.findTigerMBeanServer();
                }
                if (result == null && (list = MBeanServerFactory.findMBeanServer(null)) != null && list.size() > 0) {
                    result = (MBeanServer)list.get(0);
                }
            }
            if (result == null && this.createMBeanServer) {
                result = this.createMBeanServer();
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.error("Could not load MBeanServer", e);
        }
        catch (Throwable e) {
            LOG.error("Failed to initialize MBeanServer", e);
        }
        return result;
    }

    public MBeanServer findTigerMBeanServer() {
        block7: {
            String name = "java.lang.management.ManagementFactory";
            Class type = ManagementContext.loadClass(name, ManagementContext.class.getClassLoader());
            if (type != null) {
                try {
                    Method method = type.getMethod("getPlatformMBeanServer", new Class[0]);
                    if (method != null) {
                        Object answer = method.invoke(null, new Object[0]);
                        if (answer instanceof MBeanServer) {
                            if (this.createConnector) {
                                this.createConnector((MBeanServer)answer);
                            }
                            return (MBeanServer)answer;
                        }
                        LOG.warn("Could not cast: " + answer + " into an MBeanServer. There must be some classloader strangeness in town");
                        break block7;
                    }
                    LOG.warn("Method getPlatformMBeanServer() does not appear visible on type: " + type.getName());
                }
                catch (Exception e) {
                    LOG.warn("Failed to call getPlatformMBeanServer() due to: " + e, e);
                }
            } else {
                LOG.trace("Class not found: " + name + " so probably running on Java 1.4");
            }
        }
        return null;
    }

    private static Class loadClass(String name, ClassLoader loader) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }

    protected MBeanServer createMBeanServer() throws MalformedObjectNameException, IOException {
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer(this.jmxDomainName);
        this.locallyCreateMBeanServer = true;
        if (this.createConnector) {
            this.createConnector(mbeanServer);
        }
        return mbeanServer;
    }

    private void createConnector(MBeanServer mbeanServer) throws IOException {
        try {
            if (this.registry == null) {
                LOG.debug("Creating RMIRegistry on port {}", this.listenPort);
                RMIClientSocketFactory clientFactory = (RMIClientSocketFactory)this.environment.get("jmx.remote.rmi.client.socket.factory");
                RMIServerSocketFactory serverFactory = (RMIServerSocketFactory)this.environment.get("jmx.remote.rmi.server.socket.factory");
                this.registry = LocateRegistry.createRegistry(this.listenPort, clientFactory, serverFactory);
            }
        }
        catch (IOException e) {
            if (this.connectorFailAware) {
                throw e;
            }
            LOG.debug("Failed to create local registry. This exception will be ignored.", e);
        }
        JMXServiceURL url = this.getJMXConnectorServerURL();
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.environment, mbeanServer);
        LOG.debug("Created JMXConnectorServer {}", this.connectorServer);
    }

    private JMXServiceURL getJMXConnectorServerURL() throws MalformedURLException {
        String rmiServer = "";
        rmiServer = this.rmiServerPort != 0 ? this.listenAddress + ":" + this.rmiServerPort : this.listenAddress + ":" + this.listenPort;
        String serviceURL = "service:jmx:rmi://" + rmiServer + "/jndi/rmi://" + this.listenAddress + ":" + this.listenPort + this.connectorPath;
        return new JMXServiceURL(serviceURL);
    }

    private void checkJMXConnectorURL() {
        if (!NetUtils.isLocalAddress(this.publishHostname)) {
            LOG.warn("Invalid jmx service publish hostname, it is not a valid local address");
            return;
        }
        String rmiServer = "";
        rmiServer = this.rmiServerPort != 0 ? this.publishHostname + ":" + this.rmiServerPort : this.publishHostname + ":" + this.listenPort;
        String serviceURL = "service:jmx:rmi://" + rmiServer + "/jndi/rmi://" + this.publishHostname + ":" + this.listenPort + this.connectorPath;
        try {
            serviceURL = new JMXServiceURL(serviceURL).toString();
            LOG.info("JMX consoles can connect to " + serviceURL);
        }
        catch (MalformedURLException e) {
            LOG.warn("Invalid jmx service url, caused by: " + e.toString() + ". It will cause the JMX consoles failed to connect");
        }
    }

    public String getConnectorPath() {
        return this.connectorPath;
    }

    public void setConnectorPath(String connectorPath) {
        this.connectorPath = connectorPath;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    public void setRmiServerPort(int rmiServerPort) {
        this.rmiServerPort = rmiServerPort;
    }

    public boolean isCreateConnector() {
        return this.createConnector;
    }

    public void setCreateConnector(boolean createConnector) {
        this.createConnector = createConnector;
    }

    public String getPublishHostname() {
        return this.publishHostname;
    }

    public void setPublishHostname(String publishHostname) {
        this.publishHostname = publishHostname;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public void setListenAddress(String listenAddress) {
        this.listenAddress = listenAddress;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }

    public boolean isAllowRemoteAddressInMBeanNames() {
        return this.allowRemoteAddressInMBeanNames;
    }

    public void setAllowRemoteAddressInMBeanNames(boolean allowRemoteAddressInMBeanNames) {
        this.allowRemoteAddressInMBeanNames = allowRemoteAddressInMBeanNames;
    }

    public void setConnectorFailAware(boolean connectorFailAware) {
        this.connectorFailAware = connectorFailAware;
    }

    public boolean isConnectorFailAware() {
        return this.connectorFailAware;
    }
}

