/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.region.policy.SlowConsumerEntry;
import com.bes.mq.broker.scheduler.Job;
import com.bes.mq.command.BESMQBlobMessage;
import com.bes.mq.command.BESMQBytesMessage;
import com.bes.mq.command.BESMQFileMessage;
import com.bes.mq.command.BESMQMapMessage;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQObjectMessage;
import com.bes.mq.command.BESMQStreamMessage;
import com.bes.mq.command.BESMQTextMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenTypeSupport {
    private static final Map<Class, AbstractOpenTypeFactory> OPEN_TYPE_FACTORIES = new HashMap<Class, AbstractOpenTypeFactory>();

    private OpenTypeSupport() {
    }

    public static OpenTypeFactory getFactory(Class<?> clazz) throws OpenDataException {
        return OPEN_TYPE_FACTORIES.get(clazz);
    }

    public static CompositeData convert(Object message) throws OpenDataException {
        OpenTypeFactory f = OpenTypeSupport.getFactory(message.getClass());
        if (f == null) {
            throw new OpenDataException("Cannot create a CompositeData for type: " + message.getClass().getName());
        }
        CompositeType ct = f.getCompositeType();
        Map<String, Object> fields = f.getFields(message);
        return new CompositeDataSupport(ct, fields);
    }

    static {
        OPEN_TYPE_FACTORIES.put(BESMQMessage.class, new MessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(BESMQBytesMessage.class, new ByteMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(BESMQMapMessage.class, new MapMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(BESMQObjectMessage.class, new ObjectMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(BESMQStreamMessage.class, new StreamMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(BESMQTextMessage.class, new TextMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(Job.class, new JobOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(SlowConsumerEntry.class, new SlowConsumerEntryOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(BESMQBlobMessage.class, new BESMQBlobMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(BESMQFileMessage.class, new BESMQFileMessageOpenTypeFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SlowConsumerEntryOpenTypeFactory
    extends AbstractOpenTypeFactory {
        SlowConsumerEntryOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return SlowConsumerEntry.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("subscription", "the subscription view", SimpleType.OBJECTNAME);
            this.addItem("slowCount", "number of times deemed slow", SimpleType.INTEGER);
            this.addItem("markCount", "number of periods remaining slow", SimpleType.INTEGER);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            SlowConsumerEntry entry = (SlowConsumerEntry)o;
            Map<String, Object> rc = super.getFields(o);
            rc.put("subscription", entry.getSubscription());
            rc.put("slowCount", entry.getSlowCount());
            rc.put("markCount", entry.getMarkCount());
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BESMQFileMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        BESMQFileMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return BESMQFileMessage.class.getSimpleName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("FilePath", "File Path", SimpleType.STRING);
            this.addItem("FileName", "File Name", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            BESMQFileMessage m = (BESMQFileMessage)o;
            Map<String, Object> rc = super.getFields(o);
            try {
                rc.put("FilePath", "" + m.getFilePath());
            }
            catch (Exception e) {
                rc.put("FilePath", "");
            }
            try {
                rc.put("FileName", "" + m.getFileName());
            }
            catch (Exception e) {
                rc.put("FileName", "");
            }
            rc.put("JMSType", this.getTypeName());
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BESMQBlobMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        BESMQBlobMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return BESMQBlobMessage.class.getSimpleName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("Url", "Body Url", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            BESMQBlobMessage m = (BESMQBlobMessage)o;
            Map<String, Object> rc = super.getFields(o);
            try {
                rc.put("Url", "" + m.getURL().toString());
            }
            catch (JMSException e) {
                rc.put("Url", "");
            }
            rc.put("JMSType", this.getTypeName());
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JobOpenTypeFactory
    extends AbstractOpenTypeFactory {
        JobOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return Job.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("jobId", "jobId", SimpleType.STRING);
            this.addItem("cronEntry", "Cron entry", SimpleType.STRING);
            this.addItem("start", "start time", SimpleType.STRING);
            this.addItem("delay", "initial delay", SimpleType.LONG);
            this.addItem("next", "next time", SimpleType.STRING);
            this.addItem("period", "period between jobs", SimpleType.LONG);
            this.addItem("repeat", "number of times to repeat", SimpleType.INTEGER);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            Job job = (Job)o;
            Map<String, Object> rc = super.getFields(o);
            rc.put("jobId", job.getJobId());
            rc.put("cronEntry", "" + job.getCronEntry());
            rc.put("start", job.getStartTime());
            rc.put("delay", job.getDelay());
            rc.put("next", job.getNextExecutionTime());
            rc.put("period", job.getPeriod());
            rc.put("repeat", job.getRepeat());
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        TextMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return BESMQTextMessage.class.getSimpleName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("Text", "Text", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            BESMQTextMessage m = (BESMQTextMessage)o;
            Map<String, Object> rc = super.getFields(o);
            try {
                rc.put("Text", "" + m.getText());
            }
            catch (JMSException e) {
                rc.put("Text", "");
            }
            rc.put("JMSType", this.getTypeName());
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StreamMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        StreamMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return BESMQStreamMessage.class.getSimpleName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            Map<String, Object> rc = super.getFields(o);
            rc.put("JMSType", this.getTypeName());
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        ObjectMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return BESMQObjectMessage.class.getSimpleName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            Map<String, Object> rc = super.getFields(o);
            rc.put("JMSType", this.getTypeName());
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        MapMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return BESMQMapMessage.class.getSimpleName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("ContentMap", "Content map", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            BESMQMapMessage m = (BESMQMapMessage)o;
            Map<String, Object> rc = super.getFields(o);
            try {
                rc.put("ContentMap", "" + m.getContentMap());
            }
            catch (JMSException e) {
                rc.put("ContentMap", "");
            }
            rc.put("JMSType", this.getTypeName());
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        ByteMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return BESMQBytesMessage.class.getSimpleName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("BodyLength", "Body length", SimpleType.LONG);
            this.addItem("BodyPreview", "Body preview", new ArrayType(1, SimpleType.BYTE));
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            BESMQBytesMessage m = (BESMQBytesMessage)o;
            m.setReadOnlyBody(true);
            Map<String, Object> rc = super.getFields(o);
            long length = 0L;
            try {
                length = m.getBodyLength();
                rc.put("BodyLength", length);
            }
            catch (JMSException e) {
                rc.put("BodyLength", 0L);
            }
            rc.put("JMSType", this.getTypeName());
            try {
                byte[] preview = new byte[(int)Math.min(length, 255L)];
                m.readBytes(preview);
                m.reset();
                Byte[] data = new Byte[preview.length];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = new Byte(preview[i]);
                }
                rc.put("BodyPreview", data);
            }
            catch (JMSException e) {
                rc.put("BodyPreview", new Byte[0]);
            }
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageOpenTypeFactory
    extends AbstractOpenTypeFactory {
        protected TabularType stringPropertyTabularType;
        protected TabularType booleanPropertyTabularType;
        protected TabularType bytePropertyTabularType;
        protected TabularType shortPropertyTabularType;
        protected TabularType intPropertyTabularType;
        protected TabularType longPropertyTabularType;
        protected TabularType floatPropertyTabularType;
        protected TabularType doublePropertyTabularType;

        MessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return BESMQMessage.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("JMSCorrelationID", "JMSCorrelationID", SimpleType.STRING);
            this.addItem("JMSDestination", "JMSDestination", SimpleType.STRING);
            this.addItem("JMSMessageID", "JMSMessageID", SimpleType.STRING);
            this.addItem("JMSReplyTo", "JMSReplyTo", SimpleType.STRING);
            this.addItem("JMSType", "JMSType", SimpleType.STRING);
            this.addItem("JMSDeliveryMode", "JMSDeliveryMode", SimpleType.STRING);
            this.addItem("JMSExpiration", "JMSExpiration", SimpleType.LONG);
            this.addItem("JMSPriority", "JMSPriority", SimpleType.INTEGER);
            this.addItem("JMSRedelivered", "JMSRedelivered", SimpleType.BOOLEAN);
            this.addItem("JMSTimestamp", "JMSTimestamp", SimpleType.DATE);
            this.addItem("JMSXGroupID", "Message Group ID", SimpleType.STRING);
            this.addItem("JMSXGroupSeq", "Message Group Sequence Number", SimpleType.INTEGER);
            this.addItem("OriginalDestination", "Original Destination Before Senting To DLQ", SimpleType.STRING);
            this.addItem("PropertiesText", "User Properties Text", SimpleType.STRING);
            this.addItem("JMSBESMQBrokerInTime", "Message Inbound Time", SimpleType.LONG);
            this.addItem("JMSBESMQBrokerOutTime", "Message Outbound Time", SimpleType.LONG);
            this.addItem("JMSXUserID", "User ID", SimpleType.STRING);
            this.addItem("Size", "Message Size", SimpleType.INTEGER);
            this.addItem("JMSXDeliveryCount", "Redelivery counter", SimpleType.INTEGER);
            this.stringPropertyTabularType = this.createTabularType(String.class, SimpleType.STRING);
            this.booleanPropertyTabularType = this.createTabularType(Boolean.class, SimpleType.BOOLEAN);
            this.bytePropertyTabularType = this.createTabularType(Byte.class, SimpleType.BYTE);
            this.shortPropertyTabularType = this.createTabularType(Short.class, SimpleType.SHORT);
            this.intPropertyTabularType = this.createTabularType(Integer.class, SimpleType.INTEGER);
            this.longPropertyTabularType = this.createTabularType(Long.class, SimpleType.LONG);
            this.floatPropertyTabularType = this.createTabularType(Float.class, SimpleType.FLOAT);
            this.doublePropertyTabularType = this.createTabularType(Double.class, SimpleType.DOUBLE);
            this.addItem("StringProperties", "User String Properties", this.stringPropertyTabularType);
            this.addItem("BooleanProperties", "User Boolean Properties", this.booleanPropertyTabularType);
            this.addItem("ByteProperties", "User Byte Properties", this.bytePropertyTabularType);
            this.addItem("ShortProperties", "User Short Properties", this.shortPropertyTabularType);
            this.addItem("IntProperties", "User Integer Properties", this.intPropertyTabularType);
            this.addItem("LongProperties", "User Long Properties", this.longPropertyTabularType);
            this.addItem("FloatProperties", "User Float Properties", this.floatPropertyTabularType);
            this.addItem("DoubleProperties", "User Double Properties", this.doublePropertyTabularType);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            BESMQMessage m = (BESMQMessage)o;
            Map<String, Object> rc = super.getFields(o);
            rc.put("JMSCorrelationID", m.getJMSCorrelationID());
            rc.put("JMSDestination", "" + m.getJMSDestination());
            rc.put("JMSMessageID", m.getJMSMessageID());
            rc.put("JMSReplyTo", this.toString(m.getJMSReplyTo()));
            rc.put("JMSType", m.getJMSType());
            rc.put("JMSDeliveryMode", m.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON-PERSISTENT");
            rc.put("JMSExpiration", m.getJMSExpiration());
            rc.put("JMSPriority", m.getJMSPriority());
            rc.put("JMSRedelivered", m.getJMSRedelivered());
            rc.put("JMSTimestamp", new Date(m.getJMSTimestamp()));
            rc.put("JMSXGroupID", m.getGroupID());
            rc.put("JMSXGroupSeq", m.getGroupSequence());
            rc.put("OriginalDestination", this.toString(m.getOriginalDestination()));
            rc.put("JMSBESMQBrokerInTime", m.getBrokerInTime());
            rc.put("JMSBESMQBrokerOutTime", m.getBrokerOutTime());
            rc.put("JMSXUserID", m.getUserID());
            rc.put("Size", m.getSize());
            rc.put("JMSXDeliveryCount", m.getRedeliveryCounter());
            try {
                rc.put("PropertiesText", "" + m.getProperties());
            }
            catch (IOException e) {
                rc.put("PropertiesText", "");
            }
            try {
                rc.put("StringProperties", this.createTabularData(m, this.stringPropertyTabularType, String.class));
            }
            catch (IOException e) {
                rc.put("StringProperties", new TabularDataSupport(this.stringPropertyTabularType));
            }
            try {
                rc.put("BooleanProperties", this.createTabularData(m, this.booleanPropertyTabularType, Boolean.class));
            }
            catch (IOException e) {
                rc.put("BooleanProperties", new TabularDataSupport(this.booleanPropertyTabularType));
            }
            try {
                rc.put("ByteProperties", this.createTabularData(m, this.bytePropertyTabularType, Byte.class));
            }
            catch (IOException e) {
                rc.put("ByteProperties", new TabularDataSupport(this.bytePropertyTabularType));
            }
            try {
                rc.put("ShortProperties", this.createTabularData(m, this.shortPropertyTabularType, Short.class));
            }
            catch (IOException e) {
                rc.put("ShortProperties", new TabularDataSupport(this.shortPropertyTabularType));
            }
            try {
                rc.put("IntProperties", this.createTabularData(m, this.intPropertyTabularType, Integer.class));
            }
            catch (IOException e) {
                rc.put("IntProperties", new TabularDataSupport(this.intPropertyTabularType));
            }
            try {
                rc.put("LongProperties", this.createTabularData(m, this.longPropertyTabularType, Long.class));
            }
            catch (IOException e) {
                rc.put("LongProperties", new TabularDataSupport(this.longPropertyTabularType));
            }
            try {
                rc.put("FloatProperties", this.createTabularData(m, this.floatPropertyTabularType, Float.class));
            }
            catch (IOException e) {
                rc.put("FloatProperties", new TabularDataSupport(this.floatPropertyTabularType));
            }
            try {
                rc.put("DoubleProperties", this.createTabularData(m, this.doublePropertyTabularType, Double.class));
            }
            catch (IOException e) {
                rc.put("DoubleProperties", new TabularDataSupport(this.doublePropertyTabularType));
            }
            return rc;
        }

        protected String toString(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        protected <T> TabularType createTabularType(Class<T> type, OpenType openType) throws OpenDataException {
            String typeName = "java.util.Map<java.lang.String, " + type.getName() + ">";
            String[] keyValue = new String[]{"key", "value"};
            OpenType[] openTypes = new OpenType[]{SimpleType.STRING, openType};
            CompositeType rowType = new CompositeType(typeName, typeName, keyValue, keyValue, openTypes);
            return new TabularType(typeName, typeName, rowType, new String[]{"key"});
        }

        protected TabularDataSupport createTabularData(BESMQMessage m, TabularType type, Class valueType) throws IOException, OpenDataException {
            TabularDataSupport answer = new TabularDataSupport(type);
            Set<Map.Entry<String, Object>> entries = m.getProperties().entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                Object value = entry.getValue();
                if (!valueType.isInstance(value)) continue;
                CompositeDataSupport compositeData = this.createTabularRowValue(type, entry.getKey(), value);
                answer.put(compositeData);
            }
            return answer;
        }

        protected CompositeDataSupport createTabularRowValue(TabularType type, String key, Object value) throws OpenDataException {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("key", key);
            fields.put("value", value);
            return new CompositeDataSupport(type.getRowType(), fields);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractOpenTypeFactory
    implements OpenTypeFactory {
        private CompositeType compositeType;
        private final List<String> itemNamesList = new ArrayList<String>();
        private final List<String> itemDescriptionsList = new ArrayList<String>();
        private final List<OpenType> itemTypesList = new ArrayList<OpenType>();

        AbstractOpenTypeFactory() {
        }

        @Override
        public CompositeType getCompositeType() throws OpenDataException {
            if (this.compositeType == null) {
                this.init();
                this.compositeType = this.createCompositeType();
            }
            return this.compositeType;
        }

        protected void init() throws OpenDataException {
        }

        protected CompositeType createCompositeType() throws OpenDataException {
            String[] itemNames = this.itemNamesList.toArray(new String[this.itemNamesList.size()]);
            String[] itemDescriptions = this.itemDescriptionsList.toArray(new String[this.itemDescriptionsList.size()]);
            OpenType[] itemTypes = this.itemTypesList.toArray(new OpenType[this.itemTypesList.size()]);
            return new CompositeType(this.getTypeName(), this.getDescription(), itemNames, itemDescriptions, itemTypes);
        }

        protected abstract String getTypeName();

        protected void addItem(String name, String description, OpenType type) {
            this.itemNamesList.add(name);
            this.itemDescriptionsList.add(description);
            this.itemTypesList.add(type);
        }

        protected String getDescription() {
            return this.getTypeName();
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            HashMap<String, Object> rc = new HashMap<String, Object>();
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface OpenTypeFactory {
        public CompositeType getCompositeType() throws OpenDataException;

        public Map<String, Object> getFields(Object var1) throws OpenDataException;
    }
}

