/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.jmx.ProducerViewMBean;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ProducerInfo;

public class ProducerView
implements ProducerViewMBean {
    protected final ProducerInfo info;
    protected final String clientId;
    protected final String userName;
    protected final ManagedRegionBroker broker;
    protected BESMQDestination lastUsedDestination;

    public ProducerView(ProducerInfo info, String clientId, String userName, ManagedRegionBroker broker) {
        this.info = info;
        this.clientId = clientId;
        this.userName = userName;
        this.broker = broker;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getConnectionId() {
        if (this.info != null) {
            return this.info.getProducerId().getConnectionId();
        }
        return "NOTSET";
    }

    public long getSessionId() {
        if (this.info != null) {
            return this.info.getProducerId().getSessionId();
        }
        return 0L;
    }

    public String getProducerId() {
        if (this.info != null) {
            return this.info.getProducerId().toString();
        }
        return "NOTSET";
    }

    public String getDestinationName() {
        if (this.info != null && this.info.getDestination() != null) {
            BESMQDestination dest = this.info.getDestination();
            return dest.getPhysicalName();
        }
        if (this.lastUsedDestination != null) {
            return this.lastUsedDestination.getPhysicalName();
        }
        return "NOTSET";
    }

    public boolean isDestinationQueue() {
        if (this.info != null) {
            if (this.info.getDestination() != null) {
                BESMQDestination dest = this.info.getDestination();
                return dest.isQueue();
            }
            if (this.lastUsedDestination != null) {
                return this.lastUsedDestination.isQueue();
            }
        }
        return false;
    }

    public boolean isDestinationTopic() {
        if (this.info != null) {
            if (this.info.getDestination() != null) {
                BESMQDestination dest = this.info.getDestination();
                return dest.isTopic();
            }
            if (this.lastUsedDestination != null) {
                return this.lastUsedDestination.isTopic();
            }
        }
        return false;
    }

    public boolean isDestinationTemporary() {
        if (this.info != null) {
            if (this.info.getDestination() != null) {
                BESMQDestination dest = this.info.getDestination();
                return dest.isTemporary();
            }
            if (this.lastUsedDestination != null) {
                return this.lastUsedDestination.isTemporary();
            }
        }
        return false;
    }

    public int getProducerWindowSize() {
        if (this.info != null) {
            return this.info.getWindowSize();
        }
        return 0;
    }

    public boolean isDispatchAsync() {
        if (this.info != null) {
            return this.info.isDispatchAsync();
        }
        return false;
    }

    public String toString() {
        return "ProducerView: " + this.getClientId() + ":" + this.getConnectionId();
    }

    void setLastUsedDestinationName(BESMQDestination destinationName) {
        this.lastUsedDestination = destinationName;
    }

    public String getUserName() {
        return this.userName;
    }
}

