/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.jmx.DestinationView;
import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.jmx.OpenTypeSupport;
import com.bes.mq.broker.jmx.QueueViewMBean;
import com.bes.mq.broker.region.Queue;
import com.bes.mq.broker.region.QueueMessageReference;
import com.bes.mq.broker.region.cursors.StoreQueueCursor;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.selector.SelectorParser;
import com.bes.mq.util.BrokerSupport;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

public class QueueView
extends DestinationView
implements QueueViewMBean {
    public QueueView(ManagedRegionBroker broker, Queue destination) {
        super(broker, destination);
    }

    public CompositeData getMessage(String messageId) throws OpenDataException {
        CompositeData result = null;
        QueueMessageReference ref = ((Queue)this.destination).getMessage(messageId);
        if (ref != null) {
            Message rc = ref.getMessage();
            if (rc == null) {
                return null;
            }
            result = OpenTypeSupport.convert(rc);
        }
        return result;
    }

    public void purge() throws Exception {
        ((Queue)this.destination).purge();
    }

    public boolean removeMessage(String messageId) throws Exception {
        return ((Queue)this.destination).removeMessage(messageId);
    }

    public int removeMatchingMessages(String selector) throws Exception {
        return ((Queue)this.destination).removeMatchingMessages(selector);
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {
        return ((Queue)this.destination).removeMatchingMessages(selector, maximumMessages);
    }

    public boolean copyMessageTo(String messageId, String destinationName) throws Exception {
        ConnectionContext context = BrokerSupport.getConnectionContext(this.broker.getContextBroker());
        BESMQDestination toDestination = BESMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).copyMessageTo(context, messageId, toDestination);
    }

    public int copyMatchingMessagesTo(String selector, String destinationName) throws Exception {
        ConnectionContext context = BrokerSupport.getConnectionContext(this.broker.getContextBroker());
        BESMQDestination toDestination = BESMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).copyMatchingMessagesTo(context, selector, toDestination);
    }

    public int copyMatchingMessagesTo(String selector, String destinationName, int maximumMessages) throws Exception {
        ConnectionContext context = BrokerSupport.getConnectionContext(this.broker.getContextBroker());
        BESMQDestination toDestination = BESMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).copyMatchingMessagesTo(context, selector, toDestination, maximumMessages);
    }

    public boolean moveMessageTo(String messageId, String destinationName) throws Exception {
        ConnectionContext context = BrokerSupport.getConnectionContext(this.broker.getContextBroker());
        BESMQDestination toDestination = BESMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).moveMessageTo(context, messageId, toDestination);
    }

    public int moveMatchingMessagesTo(String selector, String destinationName) throws Exception {
        ConnectionContext context = BrokerSupport.getConnectionContext(this.broker.getContextBroker());
        BESMQDestination toDestination = BESMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).moveMatchingMessagesTo(context, selector, toDestination);
    }

    public int moveMatchingMessagesTo(String selector, String destinationName, int maximumMessages) throws Exception {
        ConnectionContext context = BrokerSupport.getConnectionContext(this.broker.getContextBroker());
        BESMQDestination toDestination = BESMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).moveMatchingMessagesTo(context, selector, toDestination, maximumMessages);
    }

    public boolean retryMessage(String messageId) throws Exception {
        Queue queue = (Queue)this.destination;
        QueueMessageReference ref = queue.getMessage(messageId);
        Message rc = ref.getMessage();
        if (rc != null) {
            BESMQDestination originalDestination = rc.getOriginalDestination();
            if (originalDestination != null) {
                ConnectionContext context = BrokerSupport.getConnectionContext(this.broker.getContextBroker());
                return queue.moveMessageTo(context, ref, originalDestination);
            }
            throw new JMSException("No original destination for message: " + messageId);
        }
        throw new JMSException("Could not find message: " + messageId);
    }

    public int cursorSize() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().size();
        }
        return 0;
    }

    public boolean doesCursorHaveMessagesBuffered() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().hasMessagesBufferedToDeliver();
        }
        return false;
    }

    public boolean doesCursorHaveSpace() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().hasSpace();
        }
        return false;
    }

    public long getCursorMemoryUsage() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null && queue.getMessages().getSystemUsage() != null) {
            return queue.getMessages().getSystemUsage().getMemoryUsage().getUsage();
        }
        return 0L;
    }

    public double getCursorPercentUsage() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null && queue.getMessages().getSystemUsage() != null) {
            return queue.getMessages().getSystemUsage().getMemoryUsage().getAccuratePercentUsage();
        }
        return 0.0;
    }

    public boolean isCursorFull() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().isFull();
        }
        return false;
    }

    public boolean isCacheEnabled() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().isCacheEnabled();
        }
        return false;
    }

    public CompositeData[] browse(int browseSize) throws OpenDataException {
        Queue queue = (Queue)this.destination;
        try {
            return this.getCompositeDatas(queue.browse(browseSize), null);
        }
        catch (InvalidSelectorException e) {
            throw new RuntimeException(e);
        }
    }

    public CompositeData[] browse(String selector, int browseSize) throws OpenDataException, InvalidSelectorException {
        Queue queue = (Queue)this.destination;
        try {
            return this.getCompositeDatas(queue.browse(browseSize), selector);
        }
        catch (InvalidSelectorException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSelectorLegal(String selector) {
        try {
            SelectorParser.parse(selector);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public long getCursorDuplicateMessagesFromProducer() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() instanceof StoreQueueCursor) {
            return ((StoreQueueCursor)queue.getMessages()).getDuplicateMessagesFromProducer();
        }
        return 0L;
    }

    public long getCursorDuplicateMessagesFromStore() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() instanceof StoreQueueCursor) {
            return ((StoreQueueCursor)queue.getMessages()).getDuplicateMessagesFromStore();
        }
        return 0L;
    }
}

