/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.jmx.DestinationViewMBean;
import com.bes.mq.broker.jmx.MBeanInfo;
import javax.jms.InvalidSelectorException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

public interface QueueViewMBean
extends DestinationViewMBean {
    @MBeanInfo(value="View a message from the destination by JMS message ID.")
    public CompositeData getMessage(@MBeanInfo(value="messageId") String var1) throws OpenDataException;

    @MBeanInfo(value="Remove a message from the destination by JMS message ID.  If the message has been dispatched, it cannot be deleted and false is returned.", impact=1)
    public boolean removeMessage(@MBeanInfo(value="messageId") String var1) throws Exception;

    @MBeanInfo(value="Removes messages from the destination based on an SQL-92 selection on the message headers or XPATH on the body.", impact=1)
    public int removeMatchingMessages(@MBeanInfo(value="selector") String var1) throws Exception;

    @MBeanInfo(value="Removes up to a specified number of messages from the destination based on an SQL-92 selection on the message headers or XPATH on the body.", impact=1)
    public int removeMatchingMessages(@MBeanInfo(value="selector") String var1, @MBeanInfo(value="maximumMessages") int var2) throws Exception;

    @MBeanInfo(value="Removes all of the messages in the queue.", impact=1)
    public void purge() throws Exception;

    @MBeanInfo(value="Copies a message with the given JMS message ID into the specified destination.", impact=1)
    public boolean copyMessageTo(@MBeanInfo(value="messageId") String var1, @MBeanInfo(value="destinationName") String var2) throws Exception;

    @MBeanInfo(value="Copies messages based on an SQL-92 selecton on the message headers or XPATH on the body into the specified destination.", impact=1)
    public int copyMatchingMessagesTo(@MBeanInfo(value="selector") String var1, @MBeanInfo(value="destinationName") String var2) throws Exception;

    @MBeanInfo(value="Copies up to a specified number of messages based on an SQL-92 selecton on the message headers or XPATH on the body into the specified destination.", impact=1)
    public int copyMatchingMessagesTo(@MBeanInfo(value="selector") String var1, @MBeanInfo(value="destinationName") String var2, @MBeanInfo(value="maximumMessages") int var3) throws Exception;

    @MBeanInfo(value="Moves a message with the given JMS message ID into the specified destination.", impact=1)
    public boolean moveMessageTo(@MBeanInfo(value="messageId") String var1, @MBeanInfo(value="destinationName") String var2) throws Exception;

    @MBeanInfo(value="Moves a message with the given JMS message back to its original destination", impact=1)
    public boolean retryMessage(@MBeanInfo(value="messageId") String var1) throws Exception;

    @MBeanInfo(value="Moves messages based on an SQL-92 selecton on the message headers or XPATH on the body into the specified destination.", impact=1)
    public int moveMatchingMessagesTo(@MBeanInfo(value="selector") String var1, @MBeanInfo(value="destinationName") String var2) throws Exception;

    @MBeanInfo(value="Moves up to a specified number of messages based on an SQL-92 selecton on the message headers or XPATH on the body into the specified destination.", impact=1)
    public int moveMatchingMessagesTo(@MBeanInfo(value="selector") String var1, @MBeanInfo(value="destinationName") String var2, @MBeanInfo(value="maximumMessages") int var3) throws Exception;

    @MBeanInfo(value="Message cursor has memory space available")
    public boolean doesCursorHaveSpace();

    @MBeanInfo(value="Message cusor has reached its memory limit for paged in messages")
    public boolean isCursorFull();

    @MBeanInfo(value="Message cursor has buffered messages to deliver")
    public boolean doesCursorHaveMessagesBuffered();

    @MBeanInfo(value="Message cursor memory usage, in bytes.")
    public long getCursorMemoryUsage();

    @MBeanInfo(value="Percentage of memory limit used")
    public double getCursorPercentUsage();

    @MBeanInfo(value="Number of messages available to be paged in by the cursor.")
    public int cursorSize();

    @MBeanInfo(value="Caching is enabled")
    public boolean isCacheEnabled();

    @MBeanInfo(value="An array of all messages in the destination. Not HTML friendly.", impact=0)
    public CompositeData[] browse(@MBeanInfo(value="browseSize") int var1) throws OpenDataException;

    @MBeanInfo(value="An array of all messages in the destination based on an SQL-92 selection on the message headers or XPATH on the body. Not HTML friendly.", impact=0)
    public CompositeData[] browse(@MBeanInfo(value="selector") String var1, @MBeanInfo(value="browseSize") int var2) throws OpenDataException, InvalidSelectorException;

    @MBeanInfo(value="If selector is based on an SQL-92 selection return true.", impact=0)
    public boolean isSelectorLegal(@MBeanInfo(value="selector") String var1);

    @MBeanInfo(value="The number of duplicate messages in cursor that came from producer.", impact=0)
    public long getCursorDuplicateMessagesFromProducer();

    @MBeanInfo(value="The number of duplicate messages in cursor that recovered from store.", impact=0)
    public long getCursorDuplicateMessagesFromStore();
}

