/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.jmx.ManagedRegionBroker;
import com.bes.mq.broker.jmx.RecoveredXATransactionViewMBean;
import com.bes.mq.transaction.Synchronization;
import com.bes.mq.transaction.XATransaction;

public class RecoveredXATransactionView
implements RecoveredXATransactionViewMBean {
    private final XATransaction transaction;

    public RecoveredXATransactionView(final ManagedRegionBroker managedRegionBroker, final XATransaction transaction) {
        this.transaction = transaction;
        transaction.addSynchronization(new Synchronization(){

            public void afterCommit() throws Exception {
                managedRegionBroker.unregister(transaction);
            }

            public void afterRollback() throws Exception {
                managedRegionBroker.unregister(transaction);
            }
        });
    }

    public int getFormatId() {
        return this.transaction.getXid().getFormatId();
    }

    public byte[] getBranchQualifier() {
        return this.transaction.getXid().getBranchQualifier();
    }

    public byte[] getGlobalTransactionId() {
        return this.transaction.getXid().getGlobalTransactionId();
    }

    public void heuristicCommit() throws Exception {
        this.transaction.commit(false);
    }

    public void heuristicRollback() throws Exception {
        this.transaction.rollback();
    }
}

