/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.jmx.ManagementContext;
import com.bes.mq.broker.jmx.SubscriptionViewMBean;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.filter.DestinationFilter;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.JMXSupport;
import java.io.IOException;
import java.util.Set;
import javax.jms.InvalidSelectorException;
import javax.management.ObjectName;

public class SubscriptionView
implements SubscriptionViewMBean {
    protected final Subscription subscription;
    protected final String clientId;
    protected final String userName;

    public SubscriptionView(String clientId, String userName, Subscription subs) {
        this.clientId = clientId;
        this.subscription = subs;
        this.userName = userName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public ObjectName getConnection() {
        BrokerService service;
        ManagementContext managementCtx;
        ConnectionContext ctx;
        ObjectName result = null;
        if (this.clientId != null && this.subscription != null && (ctx = this.subscription.getContext()) != null && ctx.getBroker() != null && ctx.getBroker().getBrokerService() != null && (managementCtx = (service = ctx.getBroker().getBrokerService()).getManagementContext()) != null) {
            try {
                ObjectName query = this.createConnectionQueury(managementCtx, service.getBrokerName());
                Set<ObjectName> names = managementCtx.queryNames(query, null);
                if (names.size() == 1) {
                    result = names.iterator().next();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private ObjectName createConnectionQueury(ManagementContext ctx, String brokerName) throws IOException {
        try {
            return new ObjectName(ctx.getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(brokerName) + "," + "Type=Connection," + "ConnectorName=*," + "Connection=" + JMXSupport.encodeObjectNamePart(this.clientId));
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public String getConnectionId() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            return info.getConsumerId().getConnectionId();
        }
        return "NOTSET";
    }

    public long getSessionId() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            return info.getConsumerId().getSessionId();
        }
        return 0L;
    }

    public long getSubcriptionId() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            return info.getConsumerId().getValue();
        }
        return 0L;
    }

    public String getDestinationName() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            BESMQDestination dest = info.getDestination();
            return dest.getPhysicalName();
        }
        return "NOTSET";
    }

    public String getSelector() {
        if (this.subscription != null) {
            return this.subscription.getSelector();
        }
        return null;
    }

    public void setSelector(String selector) throws InvalidSelectorException, UnsupportedOperationException {
        if (this.subscription == null) {
            throw new UnsupportedOperationException("No subscription object");
        }
        this.subscription.setSelector(selector);
    }

    public boolean isDestinationQueue() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            BESMQDestination dest = info.getDestination();
            return dest.isQueue();
        }
        return false;
    }

    public boolean isDestinationTopic() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            BESMQDestination dest = info.getDestination();
            return dest.isTopic();
        }
        return false;
    }

    public boolean isDestinationTemporary() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            BESMQDestination dest = info.getDestination();
            return dest.isTemporary();
        }
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public void gc() {
        if (this.subscription != null) {
            this.subscription.gc();
        }
    }

    public boolean isRetroactive() {
        ConsumerInfo info = this.getConsumerInfo();
        return info != null ? info.isRetroactive() : false;
    }

    public boolean isExclusive() {
        ConsumerInfo info = this.getConsumerInfo();
        return info != null ? info.isExclusive() : false;
    }

    public boolean isDurable() {
        ConsumerInfo info = this.getConsumerInfo();
        return info != null ? info.isDurable() : false;
    }

    public boolean isNoLocal() {
        ConsumerInfo info = this.getConsumerInfo();
        return info != null ? info.isNoLocal() : false;
    }

    public int getMaximumPendingMessageLimit() {
        ConsumerInfo info = this.getConsumerInfo();
        return info != null ? info.getMaximumPendingMessageLimit() : 0;
    }

    public byte getPriority() {
        ConsumerInfo info = this.getConsumerInfo();
        return info != null ? info.getPriority() : (byte)0;
    }

    public String getSubscriptionName() {
        ConsumerInfo info = this.getConsumerInfo();
        return info != null ? info.getSubscriptionName() : null;
    }

    public int getPendingQueueSize() {
        return this.subscription != null ? this.subscription.getPendingQueueSize() : 0;
    }

    public int getDispatchedQueueSize() {
        return this.subscription != null ? this.subscription.getDispatchedQueueSize() : 0;
    }

    public int getMessageCountAwaitingAcknowledge() {
        return this.getDispatchedQueueSize();
    }

    public long getDispatchedCounter() {
        return this.subscription != null ? this.subscription.getDispatchedCounter() : 0L;
    }

    public long getEnqueueCounter() {
        return this.subscription != null ? this.subscription.getEnqueueCounter() : 0L;
    }

    public long getDequeueCounter() {
        return this.subscription != null ? this.subscription.getDequeueCounter() : 0L;
    }

    protected ConsumerInfo getConsumerInfo() {
        return this.subscription != null ? this.subscription.getConsumerInfo() : null;
    }

    public String toString() {
        return "SubscriptionView: " + this.getClientId() + ":" + this.getConnectionId();
    }

    public int getPrefetchSize() {
        return this.subscription != null ? this.subscription.getPrefetchSize() : 0;
    }

    public boolean isMatchingQueue(String queueName) {
        if (this.isDestinationQueue()) {
            return this.matchesDestination(new BESMQQueue(queueName));
        }
        return false;
    }

    public boolean isMatchingTopic(String topicName) {
        if (this.isDestinationTopic()) {
            return this.matchesDestination(new BESMQTopic(topicName));
        }
        return false;
    }

    public boolean matchesDestination(BESMQDestination destination) {
        BESMQDestination subscriptionDestination = this.subscription.getBESMQDestination();
        DestinationFilter filter = DestinationFilter.parseFilter(subscriptionDestination);
        return filter.matches(destination);
    }

    public boolean isSlowConsumer() {
        return this.subscription.isSlowConsumer();
    }

    public String getUserName() {
        return this.userName;
    }
}

