/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.jmx.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class JvmUsageGetter {
    private static OperatingSystemMXBean OPERATING_SYSTEM_MX_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private static RuntimeMXBean RUNTIME_MX_BEAN = ManagementFactory.getRuntimeMXBean();
    private static MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private static final Logger logger = Logger.getLogger(JvmUsageGetter.class.getName());
    private static CpuTime preCpuTime;
    private static Method getProcessCpuTimeMethod;
    private static final int cpuCores;

    private static boolean hasInited() {
        return preCpuTime != null;
    }

    public static final void init() {
        preCpuTime = new CpuTime();
        JvmUsageGetter.preCpuTime.processCpuTime = 0L;
        JvmUsageGetter.preCpuTime.uptime = 0L;
        try {
            getProcessCpuTimeMethod = OPERATING_SYSTEM_MX_BEAN.getClass().getDeclaredMethod("getProcessCpuTime", new Class[0]);
            if (!getProcessCpuTimeMethod.isAccessible()) {
                getProcessCpuTimeMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException ex) {
            logger.warning("The method 'getProcessCpuTime' is not supported in current JVM");
        }
    }

    private static long getProcessCpuTime() {
        try {
            return (Long)getProcessCpuTimeMethod.invoke((Object)OPERATING_SYSTEM_MX_BEAN, new Object[0]);
        }
        catch (Exception ex) {
            logger.warning("The method 'getProcessCpuTime' is not supported in current JVM, caused by: " + ex.getMessage());
            return -1L;
        }
    }

    public static double getMemoryUsage() {
        try {
            MemoryUsage heapMemoryUsage = MEMORY_MX_BEAN.getHeapMemoryUsage();
            double max = heapMemoryUsage.getMax();
            double used = heapMemoryUsage.getUsed();
            return used * 100.0 / Math.max(1.0, max);
        }
        catch (Throwable e) {
            logger.warning("Failed to getMemoryUsage, caused by: " + e.getMessage());
            return 0.0;
        }
    }

    public static final float getCpuUsage() {
        if (!JvmUsageGetter.hasInited()) {
            JvmUsageGetter.init();
        }
        long processCpuTime = JvmUsageGetter.getProcessCpuTime();
        long uptime = RUNTIME_MX_BEAN.getUptime();
        long elapsedTime = uptime - JvmUsageGetter.preCpuTime.uptime;
        long elapsedCpuTime = processCpuTime - JvmUsageGetter.preCpuTime.processCpuTime;
        float cpuUsage = (float)elapsedCpuTime / ((float)elapsedTime * 10000.0f * (float)cpuCores);
        preCpuTime.update(uptime, processCpuTime);
        return Math.min(99.99f, cpuUsage);
    }

    static {
        cpuCores = Runtime.getRuntime().availableProcessors();
    }

    private static class CpuTime {
        long uptime = 0L;
        long processCpuTime = 0L;

        private CpuTime() {
        }

        void update(long uptime, long processCpuTime) {
            this.uptime = uptime;
            this.processCpuTime = processCpuTime;
        }
    }
}

