/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ConsumerBrokerExchange;
import com.bes.mq.broker.DestinationAlreadyExistsException;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.AbstractSubscription;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFactory;
import com.bes.mq.broker.region.DestinationInterceptor;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.DurableTopicSubscription;
import com.bes.mq.broker.region.QueueBrowserSubscription;
import com.bes.mq.broker.region.Region;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.PolicyEntry;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerControl;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatchNotification;
import com.bes.mq.command.MessagePull;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.Response;
import com.bes.mq.filter.DestinationFilter;
import com.bes.mq.filter.DestinationMap;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.security.SecurityContext;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.SubscriptionKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.JMSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegion
implements Region {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRegion.class);
    protected final Map<BESMQDestination, Destination> destinations = new ConcurrentHashMap<BESMQDestination, Destination>();
    protected final DestinationMap destinationMap = new DestinationMap();
    protected final Map<ConsumerId, Subscription> subscriptions = new ConcurrentHashMap<ConsumerId, Subscription>();
    protected final SystemUsage usageManager;
    protected final DestinationFactory destinationFactory;
    protected final DestinationStatistics destinationStatistics;
    protected final RegionBroker broker;
    protected boolean autoCreateDestinations = true;
    protected final TaskRunnerFactory taskRunnerFactory;
    protected final ReentrantReadWriteLock destinationsLock = new ReentrantReadWriteLock();
    protected final Map<ConsumerId, Object> consumerChangeMutexMap = new HashMap<ConsumerId, Object>();
    protected boolean started;

    public AbstractRegion(RegionBroker broker, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        if (broker == null) {
            throw new IllegalArgumentException("Null broker");
        }
        this.broker = broker;
        this.destinationStatistics = destinationStatistics;
        this.usageManager = memoryManager;
        this.taskRunnerFactory = taskRunnerFactory;
        if (destinationFactory == null) {
            throw new IllegalArgumentException("Null destinationFactory");
        }
        this.destinationFactory = destinationFactory;
    }

    @Override
    public final void start() throws Exception {
        this.started = true;
        Set<BESMQDestination> inactiveDests = this.getInactiveDestinations();
        for (BESMQDestination dest : inactiveDests) {
            ConnectionContext context = new ConnectionContext();
            context.setBroker(this.broker.getBrokerService().getBroker());
            context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
            context.getBroker().addDestination(context, dest, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        this.started = false;
        this.destinationsLock.readLock().lock();
        try {
            for (Destination dest : this.destinations.values()) {
                dest.stop();
            }
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
        this.destinations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination addDestination(ConnectionContext context, BESMQDestination destination, boolean createIfTemporary) throws Exception {
        this.destinationsLock.writeLock().lock();
        try {
            Destination dest = this.destinations.get(destination);
            if (dest == null) {
                if (!destination.isTemporary() || createIfTemporary) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.broker.getBrokerName() + " adding destination: " + destination);
                    }
                    dest = this.createDestination(context, destination);
                    DestinationInterceptor destinationInterceptor = this.broker.getDestinationInterceptor();
                    if (destinationInterceptor != null) {
                        dest = destinationInterceptor.intercept(dest);
                    }
                    dest.start();
                    this.destinations.put(destination, dest);
                    this.destinationMap.put(destination, dest);
                    this.addSubscriptionsForDestination(context, dest);
                }
                if (dest == null) {
                    throw new JMSException("The destination " + destination + " does not exist.");
                }
            }
            Destination destination2 = dest;
            return destination2;
        }
        finally {
            this.destinationsLock.writeLock().unlock();
        }
    }

    public Map<ConsumerId, Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    protected List<Subscription> addSubscriptionsForDestination(ConnectionContext context, Destination dest) throws Exception {
        ArrayList<Subscription> rc = new ArrayList<Subscription>();
        for (Subscription sub : this.subscriptions.values()) {
            if (!sub.matches(dest.getBESMQDestination())) continue;
            try {
                dest.addSubscription(context, sub);
                rc.add(sub);
            }
            catch (SecurityException e) {
                if (sub.isWildcard()) {
                    LOG.debug("Subscription denied for " + sub + " to destination " + dest.getBESMQDestination() + ": " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        if (timeout == 0L) {
            for (Subscription sub : this.subscriptions.values()) {
                if (!sub.matches(destination)) continue;
                throw new JMSException("Destination still has an active subscription: " + destination);
            }
        }
        if (timeout > 0L) {
            // empty if block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.broker.getBrokerName() + " removing destination: " + destination);
        }
        this.destinationsLock.writeLock().lock();
        try {
            Destination dest = this.destinations.remove(destination);
            if (dest != null) {
                for (Subscription sub : this.subscriptions.values()) {
                    if (sub instanceof DurableTopicSubscription) {
                        DurableTopicSubscription durableSub = (DurableTopicSubscription)sub;
                        SubscriptionKey key = durableSub.getSubscriptionKey();
                        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
                        info.setClientId(key.getClientId());
                        info.setSubscriptionName(key.getSubscriptionName());
                        this.removeSubscription(context, info);
                    }
                    if (!sub.matches(destination)) continue;
                    dest.removeSubscription(context, sub, 0L);
                }
                this.destinationMap.removeAll(destination);
                this.dispose(context, dest);
                DestinationInterceptor destinationInterceptor = this.broker.getDestinationInterceptor();
                if (destinationInterceptor != null) {
                    destinationInterceptor.remove(dest);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot remove a destination that doesn't exist: " + destination);
            }
        }
        finally {
            this.destinationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Destination> getDestinations(BESMQDestination destination) {
        this.destinationsLock.readLock().lock();
        try {
            Set set = this.destinationMap.get(destination);
            return set;
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BESMQDestination, Destination> getDestinationMap() {
        this.destinationsLock.readLock().lock();
        try {
            Map<BESMQDestination, Destination> map = this.destinations;
            return map;
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Object addGuard;
        BESMQDestination destination;
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.broker.getBrokerName() + " adding consumer: " + info.getConsumerId() + " for destination: " + info.getDestination());
        }
        if ((destination = info.getDestination()) != null && !destination.isPattern() && !destination.isComposite()) {
            this.lookup(context, destination, true);
        }
        Object object = this.consumerChangeMutexMap;
        synchronized (object) {
            addGuard = this.consumerChangeMutexMap.get(info.getConsumerId());
            if (addGuard == null) {
                addGuard = new Object();
                this.consumerChangeMutexMap.put(info.getConsumerId(), addGuard);
            }
        }
        object = addGuard;
        synchronized (object) {
            Subscription o = this.subscriptions.get(info.getConsumerId());
            if (o != null) {
                LOG.warn("A duplicate subscription was detected. Clients may be misbehaving. Later warnings you may see about subscription removal is a consequence of this.");
                return o;
            }
            DestinationFilter.parseFilter(info.getDestination());
            Subscription sub = this.createSubscription(context, info);
            ArrayList<Destination> addList = new ArrayList<Destination>();
            this.destinationsLock.readLock().lock();
            try {
                for (Destination dest : this.destinationMap.get(info.getDestination())) {
                    addList.add(dest);
                }
            }
            finally {
                this.destinationsLock.readLock().unlock();
            }
            ArrayList<Destination> removeList = new ArrayList<Destination>();
            for (Destination dest : addList) {
                try {
                    dest.addSubscription(context, sub);
                    removeList.add(dest);
                }
                catch (SecurityException e) {
                    if (sub.isWildcard()) {
                        LOG.debug("Subscription denied for " + sub + " to destination " + dest.getBESMQDestination() + ": " + e.getMessage());
                        continue;
                    }
                    for (Destination remove : removeList) {
                        try {
                            remove.removeSubscription(context, sub, info.getLastDeliveredSequenceId());
                        }
                        catch (Exception ex) {
                            LOG.error("Error unsubscribing " + sub + " from " + remove + ": " + ex.getMessage(), ex);
                        }
                    }
                    throw e;
                }
            }
            removeList.clear();
            if (info.isBrowser()) {
                ((QueueBrowserSubscription)sub).destinationsAdded();
            }
            this.subscriptions.put(info.getConsumerId(), sub);
            return sub;
        }
    }

    public Set getDurableDestinations() {
        return this.destinationFactory.getDestinations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<BESMQDestination> getInactiveDestinations() {
        Set<BESMQDestination> inactiveDests = this.destinationFactory.getDestinations();
        this.destinationsLock.readLock().lock();
        try {
            inactiveDests.removeAll(this.destinations.keySet());
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
        return inactiveDests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Subscription sub;
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.broker.getBrokerName() + " removing consumer: " + info.getConsumerId() + " for destination: " + info.getDestination());
        }
        if ((sub = this.subscriptions.remove(info.getConsumerId())) != null) {
            ArrayList<Destination> removeList = new ArrayList<Destination>();
            this.destinationsLock.readLock().lock();
            try {
                for (Destination dest : this.destinationMap.get(info.getDestination())) {
                    removeList.add(dest);
                }
            }
            finally {
                this.destinationsLock.readLock().unlock();
            }
            for (Destination dest : removeList) {
                dest.removeSubscription(context, sub, info.getLastDeliveredSequenceId());
            }
            this.destroySubscription(sub);
        }
        Map<ConsumerId, Object> map = this.consumerChangeMutexMap;
        synchronized (map) {
            this.consumerChangeMutexMap.remove(info.getConsumerId());
        }
    }

    protected void destroySubscription(Subscription sub) {
        sub.destroy();
    }

    @Override
    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        throw new JMSException("Invalid operation.");
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        ConnectionContext context = producerExchange.getConnectionContext();
        if (producerExchange.isMutable() || producerExchange.getRegionDestination() == null) {
            Destination regionDestination = this.lookup(context, messageSend.getDestination(), false);
            producerExchange.setRegionDestination(regionDestination);
        }
        producerExchange.getRegionDestination().send(producerExchange, messageSend);
    }

    @Override
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        Subscription sub = consumerExchange.getSubscription();
        if (sub == null) {
            sub = this.subscriptions.get(ack.getConsumerId());
            if (sub == null) {
                if (!consumerExchange.getConnectionContext().isInRecoveryMode()) {
                    LOG.warn("Ack for non existent subscription, ack:" + ack);
                    throw new IllegalArgumentException("The subscription does not exist: " + ack.getConsumerId());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ack for non existent subscription in recovery, ack:" + ack);
                }
                return;
            }
            consumerExchange.setSubscription(sub);
        }
        sub.acknowledge(consumerExchange.getConnectionContext(), ack);
    }

    @Override
    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        Subscription sub = this.subscriptions.get(pull.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + pull.getConsumerId());
        }
        return sub.pullMessage(context, pull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination lookup(ConnectionContext context, BESMQDestination destination, boolean createTemporary) throws Exception {
        Destination dest = null;
        this.destinationsLock.readLock().lock();
        try {
            dest = this.destinations.get(destination);
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
        if (dest == null) {
            if (this.isAutoCreateDestinations()) {
                try {
                    context.getBroker().addDestination(context, destination, createTemporary);
                    dest = this.addDestination(context, destination, false);
                }
                catch (DestinationAlreadyExistsException e) {
                    // empty catch block
                }
                this.destinationsLock.readLock().lock();
                try {
                    dest = this.destinations.get(destination);
                }
                finally {
                    this.destinationsLock.readLock().unlock();
                }
            }
            if (dest == null) {
                throw new JMSException("The destination " + destination + " does not exist.");
            }
        }
        return dest;
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Subscription sub = this.subscriptions.get(messageDispatchNotification.getConsumerId());
        if (sub == null) {
            throw new JMSException("Slave broker out of sync with master - Subscription: " + messageDispatchNotification.getConsumerId() + " on " + messageDispatchNotification.getDestination() + " does not exist for dispatch of message: " + messageDispatchNotification.getMessageId());
        }
        sub.processMessageDispatchNotification(messageDispatchNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDispatchNotificationViaDestination(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Destination dest = null;
        this.destinationsLock.readLock().lock();
        try {
            dest = this.destinations.get(messageDispatchNotification.getDestination());
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
        if (dest == null) {
            throw new JMSException("Slave broker out of sync with master - Destination: " + messageDispatchNotification.getDestination() + " does not exist for consumer " + messageDispatchNotification.getConsumerId() + " with message: " + messageDispatchNotification.getMessageId());
        }
        dest.processDispatchNotification(messageDispatchNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gc() {
        for (Subscription sub : this.subscriptions.values()) {
            sub.gc();
        }
        this.destinationsLock.readLock().lock();
        try {
            for (Destination dest : this.destinations.values()) {
                dest.gc();
            }
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
    }

    protected abstract Subscription createSubscription(ConnectionContext var1, ConsumerInfo var2) throws Exception;

    protected Destination createDestination(ConnectionContext context, BESMQDestination destination) throws Exception {
        return this.destinationFactory.createDestination(context, destination, this.destinationStatistics);
    }

    public boolean isAutoCreateDestinations() {
        return this.autoCreateDestinations;
    }

    public void setAutoCreateDestinations(boolean autoCreateDestinations) {
        this.autoCreateDestinations = autoCreateDestinations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.destinationsLock.readLock().lock();
        try {
            for (Destination dest : this.destinationMap.get(info.getDestination())) {
                dest.addProducer(context, info);
            }
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.destinationsLock.readLock().lock();
        try {
            for (Destination dest : this.destinationMap.get(info.getDestination())) {
                dest.removeProducer(context, info);
            }
        }
        finally {
            this.destinationsLock.readLock().unlock();
        }
    }

    protected void dispose(ConnectionContext context, Destination dest) throws Exception {
        dest.dispose(context);
        dest.stop();
        this.destinationFactory.removeDestination(dest);
    }

    @Override
    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        Subscription sub = this.subscriptions.get(control.getConsumerId());
        if (sub != null && sub instanceof AbstractSubscription) {
            int prefetchSize = control.getPrefetch();
            ((AbstractSubscription)sub).setPrefetchSize(prefetchSize);
            BESMQDestination destination = control.getDestination();
            PolicyEntry entry = null;
            if (destination != null && this.broker.getDestinationPolicy() != null) {
                entry = this.broker.getDestinationPolicy().getEntryFor(destination);
            }
            if (entry != null) {
                entry.configurePrefetch(sub);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting prefetch: " + control.getPrefetch() + ", on subscription: " + control.getConsumerId() + ", resulting value: " + sub.getConsumerInfo().getPrefetchSize());
            }
            try {
                this.lookup(consumerExchange.getConnectionContext(), control.getDestination(), false).wakeup();
            }
            catch (Exception e) {
                LOG.warn("Failed to deliver consumerControl to destination: " + control.getDestination(), e);
            }
        }
    }
}

