/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.DeadLetterStrategy;
import com.bes.mq.broker.region.policy.SlowConsumerStrategy;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatchNotification;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.filter.NonCachedMessageEvaluationContext;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.security.SecurityContext;
import com.bes.mq.state.ProducerState;
import com.bes.mq.store.MessageStore;
import com.bes.mq.thread.Scheduler;
import com.bes.mq.usage.MemoryUsage;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.usage.Usage;
import java.io.IOException;
import java.util.List;
import javax.jms.ResourceAllocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDestination
implements Destination {
    public static final int MAX_PAGE_SIZE = 200;
    public static final int MAX_BROWSE_PAGE_SIZE = 400;
    public static final long EXPIRE_MESSAGE_PERIOD = 30000L;
    public static final long DEFAULT_INACTIVE_TIMEOUT_BEFORE_GC = 60000L;
    public static final int MAX_PRODUCERS_TO_AUDIT = 64;
    public static final int MAX_AUDIT_DEPTH = 2048;
    protected final BESMQDestination destination;
    protected final Broker broker;
    protected final MessageStore store;
    protected SystemUsage systemUsage;
    protected MemoryUsage memoryUsage;
    private boolean producerFlowControl = true;
    private boolean alwaysRetroactive = false;
    protected boolean warnOnProducerFlowControl = true;
    protected long blockedProducerWarningInterval = 30000L;
    private int maxProducersToAudit = 1024;
    private int maxAuditDepth = 2048;
    private boolean enableAudit = true;
    private int maxPageSize = 200;
    private int maxBrowsePageSize = 400;
    private boolean useCache = true;
    private int minimumMessageSize = 1024;
    private boolean lazyDispatch = false;
    private boolean notifyForSlowConsumers;
    private boolean notifyForFastProducers;
    private boolean notifyForDiscardingMessages;
    private boolean notifyWhenFull;
    private boolean notifyForDelivery;
    private boolean notifyForConsumed;
    private boolean sendNotificationIfNoConsumers;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    protected final BrokerService brokerService;
    protected final Broker regionBroker;
    protected DeadLetterStrategy deadLetterStrategy = DEFAULT_DEAD_LETTER_STRATEGY;
    protected long expireMessagesPeriod = 30000L;
    private int maxExpirePageSize = 400;
    protected int cursorMemoryHighWaterMark = 70;
    protected int storeUsageHighWaterMark = 100;
    private SlowConsumerStrategy slowConsumerStrategy;
    private boolean prioritizedMessages;
    private long inactiveTimoutBeforeGC = 60000L;
    private boolean gcIfInactive;
    private boolean gcWithNetworkConsumers;
    private long lastActiveTime = 0L;
    private boolean reduceMemoryFootprint = false;
    protected final Scheduler scheduler;
    private boolean disposed = false;
    private boolean doOptimzeMessageStorage = true;
    private int optimizeMessageStoreInFlightLimit = 10;
    protected int waitForSpacePollTime = 1000;
    protected boolean waitAsyncAddMessageComplete = true;

    public BaseDestination(BrokerService brokerService, MessageStore store, BESMQDestination destination, DestinationStatistics parentStats) throws Exception {
        this.brokerService = brokerService;
        this.broker = brokerService.getBroker();
        this.store = store;
        this.destination = destination;
        this.destinationStatistics.setEnabled(parentStats.isEnabled());
        this.destinationStatistics.setParent(parentStats);
        this.systemUsage = new SystemUsage(brokerService.getProducerSystemUsage(), destination.toString());
        this.memoryUsage = this.systemUsage.getMemoryUsage();
        this.memoryUsage.setUsagePortion(1.0f);
        this.regionBroker = brokerService.getRegionBroker();
        this.scheduler = brokerService.getBroker().getScheduler();
    }

    public void initialize() throws Exception {
        if (this.store != null) {
            this.store.setMemoryUsage(this.memoryUsage);
        }
    }

    @Override
    public boolean isProducerFlowControl() {
        return this.producerFlowControl;
    }

    @Override
    public void setProducerFlowControl(boolean producerFlowControl) {
        this.producerFlowControl = producerFlowControl;
    }

    @Override
    public boolean isAlwaysRetroactive() {
        return this.alwaysRetroactive;
    }

    @Override
    public void setAlwaysRetroactive(boolean alwaysRetroactive) {
        this.alwaysRetroactive = alwaysRetroactive;
    }

    @Override
    public void setBlockedProducerWarningInterval(long blockedProducerWarningInterval) {
        this.blockedProducerWarningInterval = blockedProducerWarningInterval;
    }

    @Override
    public long getBlockedProducerWarningInterval() {
        return this.blockedProducerWarningInterval;
    }

    @Override
    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    @Override
    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
    }

    @Override
    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    @Override
    public void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
    }

    @Override
    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    @Override
    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.destinationStatistics.getProducers().increment();
        this.lastActiveTime = 0L;
    }

    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.destinationStatistics.getProducers().decrement();
    }

    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        this.destinationStatistics.getConsumers().increment();
        this.lastActiveTime = 0L;
    }

    @Override
    public void removeSubscription(ConnectionContext context, Subscription sub, long lastDeliveredSequenceId) throws Exception {
        this.destinationStatistics.getConsumers().decrement();
    }

    @Override
    public final MemoryUsage getMemoryUsage() {
        return this.memoryUsage;
    }

    @Override
    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    @Override
    public BESMQDestination getBESMQDestination() {
        return this.destination;
    }

    @Override
    public final String getName() {
        return this.getBESMQDestination().getPhysicalName();
    }

    @Override
    public final MessageStore getMessageStore() {
        return this.store;
    }

    @Override
    public boolean isActive() {
        boolean isActive;
        boolean bl = isActive = this.destinationStatistics.getConsumers().getCount() != 0L || this.destinationStatistics.getProducers().getCount() != 0L;
        if (isActive && this.isGcWithNetworkConsumers() && this.destinationStatistics.getConsumers().getCount() != 0L) {
            isActive = this.hasRegularConsumers(this.getConsumers());
        }
        return isActive;
    }

    @Override
    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    @Override
    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    @Override
    public int getMaxBrowsePageSize() {
        return this.maxBrowsePageSize;
    }

    @Override
    public void setMaxBrowsePageSize(int maxPageSize) {
        this.maxBrowsePageSize = maxPageSize;
    }

    public int getMaxExpirePageSize() {
        return this.maxExpirePageSize;
    }

    public void setMaxExpirePageSize(int maxPageSize) {
        this.maxExpirePageSize = maxPageSize;
    }

    public void setExpireMessagesPeriod(long expireMessagesPeriod) {
        this.expireMessagesPeriod = expireMessagesPeriod;
    }

    public long getExpireMessagesPeriod() {
        return this.expireMessagesPeriod;
    }

    @Override
    public boolean isUseCache() {
        return this.useCache;
    }

    @Override
    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    @Override
    public int getMinimumMessageSize() {
        return this.minimumMessageSize;
    }

    @Override
    public void setMinimumMessageSize(int minimumMessageSize) {
        this.minimumMessageSize = minimumMessageSize;
    }

    @Override
    public boolean isLazyDispatch() {
        return this.lazyDispatch;
    }

    @Override
    public void setLazyDispatch(boolean lazyDispatch) {
        this.lazyDispatch = lazyDispatch;
    }

    protected long getDestinationSequenceId() {
        return this.regionBroker.getBrokerSequenceId();
    }

    public boolean isNotifyForSlowConsumers() {
        return this.notifyForSlowConsumers;
    }

    public void setNotifyForSlowConsumers(boolean notifyForSlowConsumers) {
        this.notifyForSlowConsumers = notifyForSlowConsumers;
    }

    public boolean isNotifyForDiscardingMessages() {
        return this.notifyForDiscardingMessages;
    }

    public void setNotifyForDiscardingMessages(boolean notifyForDiscardingMessages) {
        this.notifyForDiscardingMessages = notifyForDiscardingMessages;
    }

    public boolean isNotifyWhenFull() {
        return this.notifyWhenFull;
    }

    public void setNotifyWhenFull(boolean notifyWhenFull) {
        this.notifyWhenFull = notifyWhenFull;
    }

    public boolean isNotifyForDelivery() {
        return this.notifyForDelivery;
    }

    public void setNotifyForDelivery(boolean notifyForDelivery) {
        this.notifyForDelivery = notifyForDelivery;
    }

    public boolean isNotifyForConsumed() {
        return this.notifyForConsumed;
    }

    public void setNotifyForConsumed(boolean notifyForConsumed) {
        this.notifyForConsumed = notifyForConsumed;
    }

    public boolean isNotifyForFastProducers() {
        return this.notifyForFastProducers;
    }

    public void setNotifyForFastProducers(boolean notifyForFastProducers) {
        this.notifyForFastProducers = notifyForFastProducers;
    }

    public boolean isSendNotificationIfNoConsumers() {
        return this.sendNotificationIfNoConsumers;
    }

    public void setSendNotificationIfNoConsumers(boolean sendNotificationIfNoConsumers) {
        this.sendNotificationIfNoConsumers = sendNotificationIfNoConsumers;
    }

    @Override
    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.deadLetterStrategy;
    }

    public void setDeadLetterStrategy(DeadLetterStrategy deadLetterStrategy) {
        this.deadLetterStrategy = deadLetterStrategy;
    }

    @Override
    public int getCursorMemoryHighWaterMark() {
        return this.cursorMemoryHighWaterMark;
    }

    @Override
    public void setCursorMemoryHighWaterMark(int cursorMemoryHighWaterMark) {
        this.cursorMemoryHighWaterMark = cursorMemoryHighWaterMark;
    }

    @Override
    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        if (this.notifyForConsumed) {
            this.broker.messageConsumed(context, messageReference);
        }
    }

    @Override
    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        if (this.notifyForDelivery) {
            this.broker.messageDelivered(context, messageReference);
        }
    }

    @Override
    public void messageDiscarded(ConnectionContext context, Subscription sub, MessageReference messageReference) {
        if (this.notifyForDiscardingMessages) {
            this.broker.messageDiscarded(context, sub, messageReference);
        }
    }

    @Override
    public void slowConsumer(ConnectionContext context, Subscription subs) {
        if (this.notifyForSlowConsumers) {
            this.broker.slowConsumer(context, this, subs);
        }
        if (this.slowConsumerStrategy != null) {
            this.slowConsumerStrategy.slowConsumer(context, subs);
        }
    }

    @Override
    public void fastProducer(ConnectionContext context, ProducerInfo producerInfo) {
        if (this.notifyForFastProducers) {
            this.broker.fastProducer(context, producerInfo, this.getBESMQDestination());
        }
    }

    @Override
    public void isFull(ConnectionContext context, Usage<?> usage) {
        if (this.notifyWhenFull) {
            this.broker.isFull(context, this, usage);
        }
    }

    @Override
    public void dispose(ConnectionContext context) throws IOException {
        if (this.store != null) {
            this.store.removeAllMessages(context);
            this.store.dispose(context);
        }
        this.destinationStatistics.setParent(null);
        this.memoryUsage.stop();
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessageWithNoConsumers(ConnectionContext context, Message msg) throws Exception {
        if (!msg.isPersistent() && this.isSendNotificationIfNoConsumers() && (this.destination.isQueue() || !NotificationSupport.isNotificationTopic(this.destination))) {
            Message message = msg.copy();
            if (message.getOriginalDestination() != null) {
                message.setOriginalDestination(message.getDestination());
            }
            if (message.getOriginalTransactionId() != null) {
                message.setOriginalTransactionId(message.getTransactionId());
            }
            BESMQTopic notificationTopic = this.destination.isQueue() ? NotificationSupport.getNoQueueConsumersNotificationTopic(this.destination) : NotificationSupport.getNoTopicConsumersNotificationTopic(this.destination);
            message.setDestination(notificationTopic);
            message.setTransactionId(null);
            boolean originalFlowControl = context.isProducerFlowControl();
            try {
                context.setProducerFlowControl(false);
                ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
                producerExchange.setMutable(false);
                producerExchange.setConnectionContext(context);
                producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
                context.getBroker().send(producerExchange, message);
            }
            finally {
                context.setProducerFlowControl(originalFlowControl);
            }
        }
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
    }

    public final int getStoreUsageHighWaterMark() {
        return this.storeUsageHighWaterMark;
    }

    public void setStoreUsageHighWaterMark(int storeUsageHighWaterMark) {
        this.storeUsageHighWaterMark = storeUsageHighWaterMark;
    }

    protected final void waitForSpace(ConnectionContext context, Usage<?> usage, String warning) throws IOException, InterruptedException, ResourceAllocationException {
        this.waitForSpace(context, usage, 100, warning);
    }

    protected final void waitForSpace(ConnectionContext context, Usage<?> usage, int highWaterMark, String warning) throws IOException, InterruptedException, ResourceAllocationException {
        if (!context.isNetworkConnection() && this.systemUsage.isSendFailIfNoSpace()) {
            this.getLog().debug("Case sendFailIfNoSpace, forcing exception on send, usage:  " + usage + ": " + warning);
            throw new ResourceAllocationException(warning);
        }
        if (!context.isNetworkConnection() && this.systemUsage.getSendFailIfNoSpaceAfterTimeout() != 0L) {
            if (!usage.waitForSpace(this.systemUsage.getSendFailIfNoSpaceAfterTimeout(), highWaterMark)) {
                this.getLog().debug("Case sendFailIfNoSpaceAfterTimeout expired, forcing exception on send, usage: " + usage + ": " + warning);
                throw new ResourceAllocationException(warning);
            }
        } else {
            while (!usage.waitForSpace(this.waitForSpacePollTime, highWaterMark)) {
                if (!context.getStopping().get()) continue;
                throw new IOException("Connection closed, send aborted.");
            }
        }
    }

    protected abstract Logger getLog();

    public void setSlowConsumerStrategy(SlowConsumerStrategy slowConsumerStrategy) {
        this.slowConsumerStrategy = slowConsumerStrategy;
    }

    @Override
    public SlowConsumerStrategy getSlowConsumerStrategy() {
        return this.slowConsumerStrategy;
    }

    @Override
    public boolean isPrioritizedMessages() {
        return this.prioritizedMessages;
    }

    public void setPrioritizedMessages(boolean prioritizedMessages) {
        this.prioritizedMessages = prioritizedMessages;
        if (this.store != null) {
            this.store.setPrioritizedMessages(prioritizedMessages);
        }
    }

    @Override
    public long getInactiveTimoutBeforeGC() {
        return this.inactiveTimoutBeforeGC;
    }

    public void setInactiveTimoutBeforeGC(long inactiveTimoutBeforeGC) {
        this.inactiveTimoutBeforeGC = inactiveTimoutBeforeGC;
    }

    public boolean isGcIfInactive() {
        return this.gcIfInactive;
    }

    public void setGcIfInactive(boolean gcIfInactive) {
        this.gcIfInactive = gcIfInactive;
    }

    public void setGcWithNetworkConsumers(boolean gcWithNetworkConsumers) {
        this.gcWithNetworkConsumers = gcWithNetworkConsumers;
    }

    public boolean isGcWithNetworkConsumers() {
        return this.gcWithNetworkConsumers;
    }

    @Override
    public void markForGC(long timeStamp) {
        if (this.isGcIfInactive() && this.lastActiveTime == 0L && !this.isActive() && this.destinationStatistics.messages.getCount() == 0L && this.getInactiveTimoutBeforeGC() > 0L) {
            this.lastActiveTime = timeStamp;
        }
    }

    @Override
    public boolean canGC() {
        boolean result = false;
        if (this.isGcIfInactive() && this.lastActiveTime != 0L && System.currentTimeMillis() - this.lastActiveTime >= this.getInactiveTimoutBeforeGC()) {
            result = true;
        }
        return result;
    }

    public void setReduceMemoryFootprint(boolean reduceMemoryFootprint) {
        this.reduceMemoryFootprint = reduceMemoryFootprint;
    }

    protected boolean isReduceMemoryFootprint() {
        return this.reduceMemoryFootprint;
    }

    @Override
    public boolean isDoOptimzeMessageStorage() {
        return this.doOptimzeMessageStorage;
    }

    @Override
    public void setDoOptimzeMessageStorage(boolean doOptimzeMessageStorage) {
        this.doOptimzeMessageStorage = doOptimzeMessageStorage;
    }

    public int getOptimizeMessageStoreInFlightLimit() {
        return this.optimizeMessageStoreInFlightLimit;
    }

    public void setOptimizeMessageStoreInFlightLimit(int optimizeMessageStoreInFlightLimit) {
        this.optimizeMessageStoreInFlightLimit = optimizeMessageStoreInFlightLimit;
    }

    @Override
    public int getWaitForSpacePollTime() {
        return this.waitForSpacePollTime;
    }

    @Override
    public void setWaitForSpacePollTime(int waitForSpacePollTime) {
        this.waitForSpacePollTime = waitForSpacePollTime;
    }

    @Override
    public boolean isWaitAsyncAddMessageComplete() {
        return this.waitAsyncAddMessageComplete;
    }

    @Override
    public void setWaitAsyncAddMessageComplete(boolean waitAsyncAddMessageComplete) {
        this.waitAsyncAddMessageComplete = waitAsyncAddMessageComplete;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public abstract List<Subscription> getConsumers();

    protected boolean hasRegularConsumers(List<Subscription> consumers) {
        boolean hasRegularConsumers = false;
        for (Subscription subscription : consumers) {
            if (subscription.getConsumerInfo().isNetworkSubscription()) continue;
            hasRegularConsumers = true;
            break;
        }
        return hasRegularConsumers;
    }

    protected ConnectionContext createConnectionContext() {
        ConnectionContext answer = new ConnectionContext(new NonCachedMessageEvaluationContext());
        answer.setBroker(this.broker);
        answer.getMessageEvaluationContext().setDestination(this.getBESMQDestination());
        answer.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
        return answer;
    }

    protected MessageAck convertToNonRangedAck(MessageAck ack, MessageReference node) {
        if (ack.getMessageCount() > 0) {
            MessageAck a = new MessageAck();
            ack.copy(a);
            ack = a;
            ack.setMessageCount(1);
        }
        ack.setFirstMessageId(node.getMessageId());
        ack.setLastMessageId(node.getMessageId());
        return ack;
    }
}

