/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationInterceptor;
import com.bes.mq.broker.region.virtual.MirroredQueue;
import com.bes.mq.broker.region.virtual.VirtualDestination;
import com.bes.mq.broker.region.virtual.VirtualDestinationInterceptor;
import com.bes.mq.broker.region.virtual.VirtualTopic;
import com.bes.mq.command.BESMQDestination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CompositeDestinationInterceptor
implements DestinationInterceptor {
    private DestinationInterceptor[] interceptors;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public CompositeDestinationInterceptor(DestinationInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationInterceptor[] getDestinationInterceptor() {
        DestinationInterceptor[] ret = null;
        this.rwLock.readLock().lock();
        try {
            ret = this.interceptors;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterceptors(DestinationInterceptor[] interceptors) {
        this.rwLock.writeLock().lock();
        try {
            this.interceptors = interceptors;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public Destination intercept(Destination destination) {
        DestinationInterceptor[] interceptors = this.getDestinationInterceptor();
        for (int i = 0; i < interceptors.length; ++i) {
            destination = interceptors[i].intercept(destination);
        }
        return destination;
    }

    public void remove(Destination destination) {
        DestinationInterceptor[] interceptors = this.getDestinationInterceptor();
        for (int i = 0; i < interceptors.length; ++i) {
            interceptors[i].remove(destination);
        }
    }

    public void create(Broker broker, ConnectionContext context, BESMQDestination destination) throws Exception {
        DestinationInterceptor[] interceptors = this.getDestinationInterceptor();
        for (int i = 0; i < interceptors.length; ++i) {
            interceptors[i].create(broker, context, destination);
        }
    }

    public void addMirroredQueue(MirroredQueue mirroredQueue) {
        DestinationInterceptor[] interceptors = this.getDestinationInterceptor();
        ArrayList<DestinationInterceptor> newInterceptors = new ArrayList<DestinationInterceptor>();
        if (interceptors != null) {
            newInterceptors.addAll(Arrays.asList(interceptors));
        }
        newInterceptors.add(mirroredQueue);
        this.setInterceptors(newInterceptors.toArray(new DestinationInterceptor[newInterceptors.size()]));
    }

    public void removeMirroredQueue(MirroredQueue mirroredQueue) {
        DestinationInterceptor[] interceptors = this.getDestinationInterceptor();
        ArrayList<DestinationInterceptor> newInterceptors = new ArrayList<DestinationInterceptor>();
        if (interceptors != null) {
            newInterceptors.addAll(Arrays.asList(interceptors));
        }
        MirroredQueue matched = null;
        for (DestinationInterceptor interceptor : newInterceptors) {
            MirroredQueue mirrored;
            if (!(interceptor instanceof MirroredQueue) || !(mirrored = (MirroredQueue)interceptor).getName().equals(mirroredQueue.getName())) continue;
            matched = mirrored;
            break;
        }
        if (matched != null) {
            newInterceptors.remove(matched);
        }
        this.setInterceptors(newInterceptors.toArray(new DestinationInterceptor[newInterceptors.size()]));
    }

    public void addVirtualTopic(VirtualTopic virtualTopic) {
        DestinationInterceptor[] interceptors;
        for (DestinationInterceptor interceptor : interceptors = this.getDestinationInterceptor()) {
            if (!(interceptor instanceof VirtualDestinationInterceptor)) continue;
            VirtualDestinationInterceptor virtualDestinationInterceptor = (VirtualDestinationInterceptor)interceptor;
            VirtualDestination[] virtualDestinations = virtualDestinationInterceptor.getVirtualDestinations();
            ArrayList<VirtualDestination> newVirtualDestinations = new ArrayList<VirtualDestination>();
            if (virtualDestinations != null) {
                newVirtualDestinations.addAll(Arrays.asList(virtualDestinations));
            }
            newVirtualDestinations.add(virtualTopic);
            virtualDestinationInterceptor.setVirtualDestinations(newVirtualDestinations.toArray(new VirtualDestination[0]));
            break;
        }
    }

    public void removeVirtualTopic(VirtualTopic virtualTopic) {
        DestinationInterceptor[] interceptors;
        for (DestinationInterceptor interceptor : interceptors = this.getDestinationInterceptor()) {
            if (!(interceptor instanceof VirtualDestinationInterceptor)) continue;
            VirtualDestinationInterceptor virtualDestinationInterceptor = (VirtualDestinationInterceptor)interceptor;
            VirtualDestination[] virtualDestinations = virtualDestinationInterceptor.getVirtualDestinations();
            ArrayList<VirtualDestination> newVirtualDestinations = new ArrayList<VirtualDestination>();
            if (virtualDestinations != null) {
                newVirtualDestinations.addAll(Arrays.asList(virtualDestinations));
            }
            VirtualTopic matched = null;
            for (VirtualDestination virtualDestination : newVirtualDestinations) {
                VirtualTopic vt;
                if (!(virtualDestination instanceof VirtualTopic) || !(vt = (VirtualTopic)virtualDestination).getName().equals(virtualTopic.getName())) continue;
                matched = vt;
                break;
            }
            if (matched != null) {
                newVirtualDestinations.remove(matched);
            }
            virtualDestinationInterceptor.setVirtualDestinations(newVirtualDestinations.toArray(new VirtualDestination[0]));
            break;
        }
    }

    public DestinationInterceptor[] getInterceptors() {
        return this.interceptors;
    }
}

