/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFactory;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.Queue;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.TempQueue;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.policy.PolicyEntry;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQTempDestination;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.SubscriptionInfo;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.store.MessageStore;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.thread.TaskRunnerFactory;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationFactoryImpl
extends DestinationFactory {
    protected final TaskRunnerFactory taskRunnerFactory;
    protected final PersistenceAdapter persistenceAdapter;
    protected RegionBroker broker;
    private final BrokerService brokerService;

    public DestinationFactoryImpl(BrokerService brokerService, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter) {
        this.brokerService = brokerService;
        this.taskRunnerFactory = taskRunnerFactory;
        if (persistenceAdapter == null) {
            throw new IllegalArgumentException("Null persistenceAdapter");
        }
        this.persistenceAdapter = persistenceAdapter;
    }

    @Override
    public void setRegionBroker(RegionBroker broker) {
        if (broker == null) {
            throw new IllegalArgumentException("Null broker");
        }
        this.broker = broker;
    }

    @Override
    public Set<BESMQDestination> getDestinations() {
        return this.persistenceAdapter.getDestinations();
    }

    @Override
    public Destination createDestination(ConnectionContext context, BESMQDestination destination, DestinationStatistics destinationStatistics) throws Exception {
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                BESMQTempDestination tempDest = (BESMQTempDestination)destination;
                TempQueue queue = new TempQueue(this.brokerService, destination, null, destinationStatistics, this.taskRunnerFactory);
                ((Queue)queue).initialize();
                return queue;
            }
            MessageStore store = this.persistenceAdapter.createQueueMessageStore((BESMQQueue)destination);
            Queue queue = new Queue(this.brokerService, destination, store, destinationStatistics, this.taskRunnerFactory);
            this.configureQueue(queue, destination);
            queue.initialize();
            return queue;
        }
        if (destination.isTemporary()) {
            Topic topic = new Topic(this.brokerService, destination, null, destinationStatistics, this.taskRunnerFactory);
            topic.initialize();
            return topic;
        }
        TopicMessageStore store = null;
        if (!NotificationSupport.isNotificationTopic(destination)) {
            store = this.persistenceAdapter.createTopicMessageStore((BESMQTopic)destination);
        }
        Topic topic = new Topic(this.brokerService, destination, store, destinationStatistics, this.taskRunnerFactory);
        this.configureTopic(topic, destination);
        topic.initialize();
        return topic;
    }

    @Override
    public void removeDestination(Destination dest) {
        BESMQDestination destination = dest.getBESMQDestination();
        if (!destination.isTemporary()) {
            if (destination.isQueue()) {
                this.persistenceAdapter.removeQueueMessageStore((BESMQQueue)destination);
            } else if (!NotificationSupport.isNotificationTopic(destination)) {
                this.persistenceAdapter.removeTopicMessageStore((BESMQTopic)destination);
            }
        }
    }

    protected void configureQueue(Queue queue, BESMQDestination destination) {
        PolicyEntry entry;
        if (this.broker == null) {
            throw new IllegalStateException("Broker property is not set");
        }
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure((Broker)this.broker, queue);
        }
    }

    protected void configureTopic(Topic topic, BESMQDestination destination) {
        PolicyEntry entry;
        if (this.broker == null) {
            throw new IllegalStateException("Broker property is not set");
        }
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure((Broker)this.broker, topic);
        }
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return this.persistenceAdapter.getLastMessageBrokerSequenceId();
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.persistenceAdapter;
    }

    @Override
    public SubscriptionInfo[] getAllDurableSubscriptions(BESMQTopic topic) throws IOException {
        return this.persistenceAdapter.createTopicMessageStore(topic).getAllSubscriptions();
    }
}

