/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.PrefetchSubscription;
import com.bes.mq.broker.region.QueueMessageReference;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.cursors.PendingMessageCursor;
import com.bes.mq.broker.region.cursors.StoreDurableSubscriberCursor;
import com.bes.mq.broker.region.policy.PolicyEntry;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessageId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.usage.Usage;
import com.bes.mq.usage.UsageListener;
import com.bes.mq.util.SubscriptionKey;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class DurableTopicSubscription
extends PrefetchSubscription
implements UsageListener {
    private static final Logger LOG = LoggerFactory.getLogger(DurableTopicSubscription.class);
    private final ConcurrentHashMap<MessageId, Integer> redeliveredMessages = new ConcurrentHashMap();
    private final ConcurrentHashMap<BESMQDestination, Destination> durableDestinations = new ConcurrentHashMap();
    private final SubscriptionKey subscriptionKey;
    private final AtomicBoolean keepDurableSubsActive = new AtomicBoolean(false);
    private final AtomicBoolean active = new AtomicBoolean();
    private final AtomicLong offlineTimestamp = new AtomicLong(-1L);

    public DurableTopicSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info, boolean keepDurableSubsActive) throws JMSException {
        super(broker, usageManager, context, info);
        this.pending = new StoreDurableSubscriberCursor(broker, context.getClientId(), info.getSubscriptionName(), info.getPrefetchSize(), this);
        this.pending.setSystemUsage(usageManager);
        this.pending.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
        this.keepDurableSubsActive.set(keepDurableSubsActive);
        this.subscriptionKey = new SubscriptionKey(context.getClientId(), info.getSubscriptionName());
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final long getOfflineTimestamp() {
        return this.offlineTimestamp.get();
    }

    public void setOfflineTimestamp(long timestamp) {
        this.offlineTimestamp.set(timestamp);
    }

    public boolean isFull() {
        return !this.active.get() || super.isFull();
    }

    public void gc() {
    }

    public void unmatched(MessageReference node) throws IOException {
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)5);
        ack.setMessageID(node.getMessageId());
        node.getRegionDestination().acknowledge(this.getContext(), this, ack, node);
    }

    protected void setPendingBatchSize(PendingMessageCursor pending, int numberToDispatch) {
    }

    public void add(ConnectionContext context, Destination destination) throws Exception {
        if (!this.destinations.contains(destination)) {
            super.add(context, destination);
        }
        if (this.durableDestinations.containsKey(destination.getBESMQDestination())) {
            return;
        }
        this.durableDestinations.put(destination.getBESMQDestination(), destination);
        if (this.active.get() || this.keepDurableSubsActive.get()) {
            Topic topic = (Topic)destination;
            topic.activate(context, this);
            if (this.pending.isEmpty(topic)) {
                topic.recoverRetroactiveMessages(context, this);
            }
            this.enqueueCounter += (long)this.pending.size();
        } else if (destination.getMessageStore() != null) {
            TopicMessageStore store = (TopicMessageStore)destination.getMessageStore();
            try {
                this.enqueueCounter += (long)store.getMessageCount(this.subscriptionKey.getClientId(), this.subscriptionKey.getSubscriptionName());
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException("Failed to retrieve enqueueCount from store " + e);
                jmsEx.setLinkedException(e);
                throw jmsEx;
            }
        }
        this.dispatchPending();
    }

    public boolean isEmpty(Topic topic) {
        return this.pending.isEmpty(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(SystemUsage memoryManager, ConnectionContext context, ConsumerInfo info, RegionBroker regionBroker) throws Exception {
        if (!this.active.get()) {
            PolicyEntry entry;
            BESMQDestination dest;
            this.context = context;
            this.info = info;
            this.setSelectorExpression(DurableTopicSubscription.parseSelector(info));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activating " + this);
            }
            if (!this.keepDurableSubsActive.get()) {
                for (Destination destination : this.durableDestinations.values()) {
                    Topic topic = (Topic)destination;
                    this.add(context, topic);
                    topic.activate(context, this);
                }
            }
            if ((dest = this.info.getDestination()) != null && regionBroker.getDestinationPolicy() != null && (entry = regionBroker.getDestinationPolicy().getEntryFor(dest)) != null) {
                if (this.keepDurableSubsActive.get()) {
                    entry.configurePrefetch(this);
                } else {
                    entry.configure(this.broker, this.usageManager, this);
                }
            }
            Object object = this.pendingLock;
            synchronized (object) {
                this.pending.setSystemUsage(memoryManager);
                this.pending.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
                this.pending.setMaxAuditDepth(this.getMaxAuditDepth());
                this.pending.setMaxProducersToAudit(this.getMaxProducersToAudit());
                this.pending.start();
                if (this.pending.isEmpty()) {
                    for (Destination destination : this.durableDestinations.values()) {
                        Topic topic = (Topic)destination;
                        topic.recoverRetroactiveMessages(context, this);
                    }
                }
            }
            this.active.set(true);
            this.offlineTimestamp.set(-1L);
            this.dispatchPending();
            this.usageManager.getMemoryUsage().addUsageListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean keepDurableSubsActive) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deactivating keepActive=" + keepDurableSubsActive + ", " + this);
        }
        this.active.set(false);
        this.offlineTimestamp.set(System.currentTimeMillis());
        this.usageManager.getMemoryUsage().removeUsageListener(this);
        Object object = this.pendingLock;
        synchronized (object) {
            Object object2 = this.dispatchLock;
            synchronized (object2) {
                for (Destination destination : this.durableDestinations.values()) {
                    Topic topic = (Topic)destination;
                    if (!keepDurableSubsActive) {
                        topic.deactivate(this.context, this);
                        continue;
                    }
                    topic.getDestinationStatistics().getInflight().subtract(this.dispatched.size());
                }
                Collections.reverse(this.dispatched);
                for (MessageReference node : this.dispatched) {
                    Integer count = this.redeliveredMessages.get(node.getMessageId());
                    if (count != null) {
                        this.redeliveredMessages.put(node.getMessageId(), count + 1);
                    } else {
                        this.redeliveredMessages.put(node.getMessageId(), 1);
                    }
                    if (keepDurableSubsActive && this.pending.isTransient()) {
                        this.pending.addMessageFirst(node);
                        this.pending.rollback(node.getMessageId());
                        if (this.pending.isInMemory(node)) continue;
                        node.decrementReferenceCount();
                        continue;
                    }
                    node.decrementReferenceCount();
                }
                this.dispatched.clear();
            }
            if (!keepDurableSubsActive) {
                this.pending.destroy();
            } else {
                this.pending.stop();
            }
        }
        this.prefetchExtension.set(0);
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        Integer count;
        MessageDispatch md = super.createMessageDispatch(node, message);
        if (node != QueueMessageReference.NULL_MESSAGE && (count = this.redeliveredMessages.get(node.getMessageId())) != null) {
            md.setRedeliveryCounter(count);
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageReference node) throws Exception {
        if (!this.active.get() && !this.keepDurableSubsActive.get()) {
            return;
        }
        Object object = this.pendingLock;
        synchronized (object) {
            if (!this.destinations.contains(node.getRegionDestination()) && node != QueueMessageReference.NULL_MESSAGE) {
                return;
            }
            if (!node.equals(QueueMessageReference.NULL_MESSAGE)) {
                ++this.enqueueCounter;
            }
            long waitForSpacePollTime = 1000L;
            if (node.getRegionDestination() != null) {
                waitForSpacePollTime = node.getRegionDestination().getWaitForSpacePollTime();
            }
            node.incrementReferenceCount();
            while (!this.pending.tryAddMessageLast(node, 0L)) {
                if (!this.active.get() && !this.keepDurableSubsActive.get()) {
                    node.decrementReferenceCount();
                    LOG.warn(this.toString() + ": stopped waiting for space in pendingMessage cursor for: " + node.getMessageId());
                    return;
                }
                this.pendingLock.wait(waitForSpacePollTime);
            }
        }
        this.dispatchPending();
    }

    public void dispatchPending() throws IOException {
        if (this.isActive()) {
            super.dispatchPending();
        }
    }

    public void removePending(MessageReference node) throws IOException {
        this.pending.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddRecoveredMessage(MessageReference message) throws Exception {
        PendingMessageCursor pendingMessageCursor = this.pending;
        synchronized (pendingMessageCursor) {
            this.pending.addRecoveredMessage(message);
        }
    }

    public int getPendingQueueSize() {
        if (this.active.get() || this.keepDurableSubsActive.get()) {
            return super.getPendingQueueSize();
        }
        return 0;
    }

    public void setSelector(String selector) throws InvalidSelectorException {
        throw new UnsupportedOperationException("You cannot dynamically change the selector for durable topic subscriptions");
    }

    protected boolean canDispatch(MessageReference node) {
        return this.isActive();
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference node) throws IOException {
        node.getRegionDestination().acknowledge(context, this, ack, node);
        this.redeliveredMessages.remove(node.getMessageId());
        node.decrementReferenceCount();
    }

    public synchronized String toString() {
        return "DurableTopicSubscription-" + this.getSubscriptionKey() + ", id=" + this.info.getConsumerId() + ", active=" + this.isActive() + ", destinations=" + this.durableDestinations.size() + ", total=" + this.enqueueCounter + ", pending=" + this.getPendingQueueSize() + ", dispatched=" + this.dispatchCounter + ", inflight=" + this.dispatched.size() + ", prefetchExtension=" + this.getPrefetchExtension();
    }

    public SubscriptionKey getSubscriptionKey() {
        return this.subscriptionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.pendingLock;
        synchronized (object) {
            try {
                this.pending.destroy();
            }
            catch (Exception e) {
                LOG.warn("destroy " + this.pending + " for " + this + " failed.", e);
            }
        }
        object = this.dispatchLock;
        synchronized (object) {
            for (MessageReference node : this.dispatched) {
                node.decrementReferenceCount();
            }
            this.dispatched.clear();
        }
        this.setSlowConsumer(false);
    }

    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        int cursorMemoryHighWaterMark = this.getCursorMemoryHighWaterMark();
        if (oldPercentUsage > newPercentUsage && oldPercentUsage >= cursorMemoryHighWaterMark && newPercentUsage < cursorMemoryHighWaterMark) {
            try {
                this.dispatchPending();
            }
            catch (IOException e) {
                LOG.warn("Error occurred while dispatching pending messages of " + this + ", caused by: ", e);
            }
        }
    }

    protected boolean isDropped(MessageReference node) {
        return false;
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive.get();
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive.set(keepDurableSubsActive);
    }
}

