/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.BaseDestination;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.IndirectMessageReference;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.MessageReferenceFilter;
import com.bes.mq.broker.region.QueueBrowserSubscription;
import com.bes.mq.broker.region.QueueDispatchSelector;
import com.bes.mq.broker.region.QueueMessageReference;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.cursors.OrderedPendingList;
import com.bes.mq.broker.region.cursors.PendingList;
import com.bes.mq.broker.region.cursors.PendingMessageCursor;
import com.bes.mq.broker.region.cursors.PrioritizedPendingList;
import com.bes.mq.broker.region.cursors.StoreQueueCursor;
import com.bes.mq.broker.region.cursors.VMPendingMessageCursor;
import com.bes.mq.broker.region.group.MessageGroupHashBucketFactory;
import com.bes.mq.broker.region.group.MessageGroupMap;
import com.bes.mq.broker.region.group.MessageGroupMapFactory;
import com.bes.mq.broker.region.policy.DispatchPolicy;
import com.bes.mq.broker.region.policy.RoundRobinDispatchPolicy;
import com.bes.mq.broker.util.InsertionCountList;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.ConnectionError;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatchNotification;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerAck;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.Response;
import com.bes.mq.filter.BooleanExpression;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.filter.NonCachedMessageEvaluationContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.org.slf4j.MDC;
import com.bes.mq.selector.SelectorParser;
import com.bes.mq.state.ProducerState;
import com.bes.mq.store.MessageRecoveryListener;
import com.bes.mq.store.MessageStore;
import com.bes.mq.thread.Task;
import com.bes.mq.thread.TaskRunner;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.transaction.Synchronization;
import com.bes.mq.usage.Usage;
import com.bes.mq.usage.UsageListener;
import com.bes.mq.util.BrokerSupport;
import com.bes.mq.util.ThreadPoolUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queue
extends BaseDestination
implements Task,
UsageListener {
    protected static final Logger LOG = LoggerFactory.getLogger(Queue.class);
    protected final TaskRunnerFactory taskFactory;
    protected TaskRunner taskRunner;
    private final ReentrantReadWriteLock consumersLock = new ReentrantReadWriteLock();
    protected final List<Subscription> consumers = new ArrayList<Subscription>(50);
    private final ReentrantReadWriteLock messagesLock = new ReentrantReadWriteLock();
    private final Condition messagesLockCondition = this.messagesLock.writeLock().newCondition();
    protected PendingMessageCursor messages;
    private final ReentrantReadWriteLock pagedInMessagesLock = new ReentrantReadWriteLock();
    private final LinkedHashMap<MessageId, QueueMessageReference> pagedInMessages = new LinkedHashMap();
    private final ReentrantReadWriteLock pagedInPendingDispatchLock = new ReentrantReadWriteLock();
    protected PendingList pagedInPendingDispatch = new OrderedPendingList();
    protected PendingList redeliveredWaitingDispatch = new OrderedPendingList();
    private MessageGroupMap messageGroupOwners;
    private DispatchPolicy dispatchPolicy = new RoundRobinDispatchPolicy();
    private MessageGroupMapFactory messageGroupMapFactory = new MessageGroupHashBucketFactory();
    final Lock sendLock = new ReentrantLock();
    private ExecutorService executor;
    private final Map<MessageId, WaitingForSpaceMessage> messagesWaitingForSpace = new LinkedHashMap<MessageId, WaitingForSpaceMessage>();
    private boolean useConsumerPriority = true;
    private boolean strictOrderDispatch = false;
    private final QueueDispatchSelector dispatchSelector;
    private boolean optimizedDispatch = false;
    private boolean iterationRunning = false;
    private boolean firstConsumer = false;
    private int timeBeforeDispatchStarts = 0;
    private int consumersBeforeDispatchStarts = 0;
    private CountDownLatch consumersBeforeStartsLatch;
    private final AtomicLong pendingWakeups = new AtomicLong();
    private boolean allConsumersExclusiveByDefault = false;
    private final Runnable sendMessagesWaitingForSpaceTask = new Runnable(){

        public void run() {
            Queue.this.asyncWakeup();
        }
    };
    private final Runnable expireMessagesTask = new Runnable(){

        public void run() {
            Queue.this.expireMessages();
        }
    };
    private final Object iteratingMutex = new Object();
    DelayQueue<TimeoutMessage> flowControlTimeoutMessages = new DelayQueue();
    private final FlowControlTimeoutTask flowControlTimeoutTask = new FlowControlTimeoutTask();
    private final Comparator<Subscription> orderedCompare = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription s1, Subscription s2) {
            int val = s2.getConsumerInfo().getPriority() - s1.getConsumerInfo().getPriority();
            if (val == 0 && Queue.this.messageGroupOwners != null) {
                long y;
                long x = s1.getConsumerInfo().getLastDeliveredSequenceId();
                val = x < (y = s2.getConsumerInfo().getLastDeliveredSequenceId()) ? -1 : (x == y ? 0 : 1);
            }
            return val;
        }
    };
    ConcurrentLinkedQueue<BrowserDispatch> browserDispatches = new ConcurrentLinkedQueue();

    public Queue(BrokerService brokerService, BESMQDestination destination, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, store, destination, parentStats);
        this.taskFactory = taskFactory;
        this.dispatchSelector = new QueueDispatchSelector(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Subscription> getConsumers() {
        this.consumersLock.readLock().lock();
        try {
            ArrayList<Subscription> arrayList = new ArrayList<Subscription>(this.consumers);
            Object var3_2 = null;
            this.consumersLock.readLock().unlock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.consumersLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public void setPrioritizedMessages(boolean prioritizedMessages) {
        super.setPrioritizedMessages(prioritizedMessages);
        if (prioritizedMessages && this.pagedInPendingDispatch instanceof OrderedPendingList) {
            this.pagedInPendingDispatch = new PrioritizedPendingList();
            this.redeliveredWaitingDispatch = new PrioritizedPendingList();
        } else if (this.pagedInPendingDispatch instanceof PrioritizedPendingList) {
            this.pagedInPendingDispatch = new OrderedPendingList();
            this.redeliveredWaitingDispatch = new OrderedPendingList();
        }
    }

    @Override
    public void initialize() throws Exception {
        if (this.messages == null) {
            this.messages = this.destination.isTemporary() || this.broker == null || this.store == null ? new VMPendingMessageCursor(this.isPrioritizedMessages()) : new StoreQueueCursor(this.broker, this);
        }
        if (this.messages instanceof VMPendingMessageCursor) {
            this.systemUsage = this.brokerService.getSystemUsage();
            this.memoryUsage.setParent(this.systemUsage.getMemoryUsage());
        }
        this.taskRunner = this.taskFactory.createTaskRunner(this, "Queue:" + this.destination.getPhysicalName());
        super.initialize();
        if (this.store != null) {
            this.messages.setSystemUsage(this.systemUsage);
            this.messages.setEnableAudit(this.isEnableAudit());
            this.messages.setMaxAuditDepth(this.getMaxAuditDepth());
            this.messages.setMaxProducersToAudit(this.getMaxProducersToAudit());
            this.messages.setUseCache(this.isUseCache());
            this.messages.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
            int messageCount = this.store.getMessageCount();
            if (messageCount > 0 && this.messages.isRecoveryRequired()) {
                BatchMessageRecoveryListener listener = new BatchMessageRecoveryListener(messageCount);
                do {
                    listener.reset();
                    this.store.recoverNextMessages(this.getMaxPageSize(), listener);
                    listener.processExpired();
                } while (!listener.done());
            } else {
                this.destinationStatistics.getMessages().setCount(messageCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getBESMQDestination().getQualifiedName() + " add sub: " + sub + ", dequeues: " + this.getDestinationStatistics().getDequeues().getCount() + ", dispatched: " + this.getDestinationStatistics().getDispatched().getCount() + ", inflight: " + this.getDestinationStatistics().getInflight().getCount());
        }
        super.addSubscription(context, sub);
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            sub.add(context, this);
            this.consumersLock.writeLock().lock();
            try {
                if (this.consumers.size() == 0) {
                    this.firstConsumer = true;
                    if (this.consumersBeforeDispatchStarts != 0) {
                        this.consumersBeforeStartsLatch = new CountDownLatch(this.consumersBeforeDispatchStarts - 1);
                    }
                } else if (this.consumersBeforeStartsLatch != null) {
                    this.consumersBeforeStartsLatch.countDown();
                }
                this.addToConsumerList(sub);
                if (sub.getConsumerInfo().isExclusive() || this.isAllConsumersExclusiveByDefault()) {
                    Subscription exclusiveConsumer = this.dispatchSelector.getExclusiveConsumer();
                    if (exclusiveConsumer == null) {
                        exclusiveConsumer = sub;
                    } else if (sub.getConsumerInfo().getPriority() == 127 || sub.getConsumerInfo().getPriority() > exclusiveConsumer.getConsumerInfo().getPriority()) {
                        exclusiveConsumer = sub;
                    }
                    this.dispatchSelector.setExclusiveConsumer(exclusiveConsumer);
                }
                Object var5_4 = null;
                this.consumersLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.consumersLock.writeLock().unlock();
                throw throwable;
            }
            if (sub instanceof QueueBrowserSubscription) {
                QueueBrowserSubscription browserSubscription = (QueueBrowserSubscription)sub;
                BrowserDispatch browserDispatch = new BrowserDispatch(browserSubscription);
                this.browserDispatches.add(browserDispatch);
            }
            if (!this.optimizedDispatch && !this.isSlave()) {
                this.wakeup();
            }
            Object var7_8 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
            throw throwable;
        }
        if (this.optimizedDispatch || this.isSlave()) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, Subscription sub, long lastDeiveredSequenceId) throws Exception {
        super.removeSubscription(context, sub, lastDeiveredSequenceId);
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getBESMQDestination().getQualifiedName() + " remove sub: " + sub + ", lastDeliveredSeqId: " + lastDeiveredSequenceId + ", dequeues: " + this.getDestinationStatistics().getDequeues().getCount() + ", dispatched: " + this.getDestinationStatistics().getDispatched().getCount() + ", inflight: " + this.getDestinationStatistics().getInflight().getCount());
            }
            this.consumersLock.writeLock().lock();
            try {
                Subscription exclusiveConsumer;
                this.removeFromConsumerList(sub);
                if (sub.getConsumerInfo().isExclusive()) {
                    exclusiveConsumer = this.dispatchSelector.getExclusiveConsumer();
                    if (exclusiveConsumer == sub) {
                        exclusiveConsumer = null;
                        for (Subscription s : this.consumers) {
                            if (!s.getConsumerInfo().isExclusive() || exclusiveConsumer != null && s.getConsumerInfo().getPriority() <= exclusiveConsumer.getConsumerInfo().getPriority()) continue;
                            exclusiveConsumer = s;
                        }
                        this.dispatchSelector.setExclusiveConsumer(exclusiveConsumer);
                    }
                } else if (this.isAllConsumersExclusiveByDefault()) {
                    exclusiveConsumer = null;
                    for (Subscription s : this.consumers) {
                        if (exclusiveConsumer != null && s.getConsumerInfo().getPriority() <= exclusiveConsumer.getConsumerInfo().getPriority()) continue;
                        exclusiveConsumer = s;
                    }
                    this.dispatchSelector.setExclusiveConsumer(exclusiveConsumer);
                }
                ConsumerId consumerId = sub.getConsumerInfo().getConsumerId();
                this.getMessageGroupOwners().removeConsumer(consumerId);
                boolean markAsRedelivered = false;
                MessageReference lastDeliveredRef = null;
                List<MessageReference> unAckedMessages = sub.remove(context, this);
                if (lastDeiveredSequenceId != 0L) {
                    for (MessageReference ref : unAckedMessages) {
                        if (ref.getMessageId().getBrokerSequenceId() != lastDeiveredSequenceId) continue;
                        lastDeliveredRef = ref;
                        markAsRedelivered = true;
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("Found lastDeliveredSeqID: " + lastDeiveredSequenceId + ", message reference: " + ref.getMessageId());
                        break;
                    }
                }
                for (MessageReference ref : unAckedMessages) {
                    QueueMessageReference qmr = (QueueMessageReference)ref;
                    if (qmr.getLockOwner() == sub) {
                        qmr.unlock();
                        if (lastDeiveredSequenceId == 0L) {
                            qmr.incrementRedeliveryCounter();
                        } else {
                            if (markAsRedelivered) {
                                qmr.incrementRedeliveryCounter();
                            }
                            if (ref == lastDeliveredRef) {
                                markAsRedelivered = false;
                            }
                        }
                    }
                    this.redeliveredWaitingDispatch.addMessageLast(qmr);
                }
                if (!this.redeliveredWaitingDispatch.isEmpty()) {
                    this.doDispatch(new OrderedPendingList());
                }
                Object var13_12 = null;
                this.consumersLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                this.consumersLock.writeLock().unlock();
                throw throwable;
            }
            if (!this.optimizedDispatch && !this.isSlave()) {
                this.wakeup();
            }
            Object var15_15 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
            throw throwable;
        }
        if (this.optimizedDispatch || this.isSlave()) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        boolean sendProducerAck;
        final ConnectionContext context = producerExchange.getConnectionContext();
        message.setRegionDestination(this);
        ProducerState state = producerExchange.getProducerState();
        if (state == null) {
            LOG.warn("Send failed for: " + message + ",  missing producer state for: " + producerExchange);
            throw new JMSException("Cannot send message to " + this.getBESMQDestination() + " with invalid (null) producer state");
        }
        final ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
        boolean bl = sendProducerAck = !message.isResponseRequired() && producerInfo.getWindowSize() > 0 && !context.isInRecoveryMode();
        if (message.isExpired()) {
            this.broker.getRoot().messageExpired(context, message, null);
            if (sendProducerAck) {
                ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                context.getConnection().dispatchAsync(ack);
            }
            return;
        }
        if (this.memoryUsage.isFull()) {
            this.isFull(context, this.memoryUsage);
            this.fastProducer(context, producerInfo);
            if (this.isProducerFlowControl() && context.isProducerFlowControl()) {
                if (this.warnOnProducerFlowControl) {
                    this.warnOnProducerFlowControl = false;
                    LOG.info("Usage Manager Memory Limit (" + this.memoryUsage.getLimit() + ") reached on " + this.getBESMQDestination().getQualifiedName() + ". Producers will be throttled to the rate at which messages are removed from this destination to prevent flooding it.");
                }
                if (!context.isNetworkConnection() && this.systemUsage.isSendFailIfNoSpace()) {
                    throw new ResourceAllocationException("Usage Manager Memory Limit reached. Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getBESMQDestination().getQualifiedName());
                }
                if (producerInfo.getWindowSize() > 0 || message.isResponseRequired()) {
                    final ProducerBrokerExchange producerExchangeCopy = producerExchange.copy();
                    Map<MessageId, WaitingForSpaceMessage> map = this.messagesWaitingForSpace;
                    synchronized (map) {
                        if (!this.flowControlTimeoutTask.isAlive()) {
                            this.flowControlTimeoutTask.setName(this.getName() + " Producer Flow Control Timeout Task");
                            this.flowControlTimeoutTask.start();
                        }
                        this.messagesWaitingForSpace.put(message.getMessageId(), new WaitingForSpaceMessage(message){

                            public void run() {
                                try {
                                    if (this.message.isExpired()) {
                                        LOG.error("Expired waiting for space..");
                                        Queue.this.broker.messageExpired(context, this.message, null);
                                        Queue.this.destinationStatistics.getExpired().increment();
                                    } else {
                                        Queue.this.doMessageSend(producerExchangeCopy, this.message);
                                    }
                                    if (sendProducerAck) {
                                        ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), this.message.getSize());
                                        context.getConnection().dispatchAsync(ack);
                                    } else {
                                        Response response = new Response();
                                        response.setCorrelationId(this.message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                }
                                catch (Exception e) {
                                    if (!sendProducerAck && !context.isInRecoveryMode()) {
                                        ExceptionResponse response = new ExceptionResponse(e);
                                        response.setCorrelationId(this.message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                    LOG.debug("Unexpected exception on deferred send of :" + this.message, e);
                                }
                            }
                        });
                        if (!context.isNetworkConnection() && this.systemUsage.getSendFailIfNoSpaceAfterTimeout() != 0L) {
                            this.flowControlTimeoutMessages.add(new TimeoutMessage(message, context, this.systemUsage.getSendFailIfNoSpaceAfterTimeout()));
                        }
                        this.registerCallbackForNotFullNotification();
                        context.setDontSendReponse(true);
                        return;
                    }
                }
                if (this.memoryUsage.isFull()) {
                    this.waitForSpace(context, this.memoryUsage, "Usage Manager Memory Limit reached. Producer (" + message.getProducerId() + ") stopped to prevent flooding " + this.getBESMQDestination().getQualifiedName());
                }
                if (message.isExpired()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Expired message: " + message);
                    }
                    this.broker.getRoot().messageExpired(context, message, null);
                    return;
                }
            }
        }
        this.doMessageSend(producerExchange, message);
        if (sendProducerAck) {
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
            context.getConnection().dispatchAsync(ack);
        }
    }

    private void registerCallbackForNotFullNotification() {
        if (!this.memoryUsage.notifyCallbackWhenNotFull(this.sendMessagesWaitingForSpaceTask)) {
            this.sendMessagesWaitingForSpaceTask.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMessageSend(ProducerBrokerExchange producerExchange, final Message message) throws IOException, Exception {
        final ConnectionContext context = producerExchange.getConnectionContext();
        Future<Object> result = null;
        this.checkUsage(context, message);
        this.sendLock.lockInterruptibly();
        try {
            if (this.store != null && message.isPersistent()) {
                message.getMessageId().setBrokerSequenceId(this.getDestinationSequenceId());
                if (this.messages.isCacheEnabled()) {
                    result = this.store.asyncAddQueueMessage(context, message, this.isOptimizeStorage());
                } else {
                    this.store.addMessage(context, message);
                }
                if (this.isReduceMemoryFootprint()) {
                    message.clearMarshalledState();
                }
            }
            if (context.isInTransaction()) {
                message.incrementReferenceCount();
                context.getTransaction().addSynchronization(new Synchronization(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void afterCommit() throws Exception {
                        Queue.this.sendLock.lockInterruptibly();
                        try {
                            if (Queue.this.broker.isExpired(message)) {
                                Queue.this.broker.messageExpired(context, message, null);
                                Queue.this.destinationStatistics.getExpired().increment();
                                Object var2_1 = null;
                                Queue.this.sendLock.unlock();
                                message.decrementReferenceCount();
                                return;
                            }
                            Queue.this.sendMessage(context, message);
                        }
                        catch (Throwable throwable) {
                            Object var2_3 = null;
                            Queue.this.sendLock.unlock();
                            message.decrementReferenceCount();
                            throw throwable;
                        }
                        Object var2_2 = null;
                        Queue.this.sendLock.unlock();
                        message.decrementReferenceCount();
                        Queue.this.messageSent(context, message);
                    }

                    public void afterRollback() throws Exception {
                        message.decrementReferenceCount();
                    }
                });
            } else {
                this.sendMessage(context, message);
            }
            Object var6_5 = null;
            this.sendLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.sendLock.unlock();
            throw throwable;
        }
        if (!context.isInTransaction()) {
            this.messageSent(context, message);
        }
        if (result != null && this.isWaitAsyncAddMessageComplete() && !result.isCancelled()) {
            try {
                result.get();
            }
            catch (CancellationException e) {
                // empty catch block
            }
        }
    }

    private void checkUsage(ConnectionContext context, Message message) throws ResourceAllocationException, IOException, InterruptedException {
        if (message.isPersistent()) {
            if (this.store != null && this.systemUsage.getStoreUsage().isFull(this.getStoreUsageHighWaterMark())) {
                String logMessage = "Persistent store is Full, " + this.getStoreUsageHighWaterMark() + "% of " + this.systemUsage.getStoreUsage().getLimit() + ". Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getBESMQDestination().getQualifiedName();
                this.waitForSpace(context, this.systemUsage.getStoreUsage(), this.getStoreUsageHighWaterMark(), logMessage);
            }
        } else if (this.messages.getSystemUsage() != null && this.systemUsage.getTempUsage().isFull()) {
            String logMessage = "Temp Store is Full (" + this.systemUsage.getTempUsage().getPercentUsage() + "% of " + this.systemUsage.getTempUsage().getLimit() + "). Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getBESMQDestination().getQualifiedName();
            this.waitForSpace(context, this.messages.getSystemUsage().getTempUsage(), logMessage);
        }
    }

    private void expireMessages() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getBESMQDestination().getQualifiedName() + " expiring messages ..");
        }
        InsertionCountList<Message> browsedMessages = new InsertionCountList<Message>();
        this.doBrowse(browsedMessages, this.getMaxExpirePageSize());
        this.asyncWakeup();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getBESMQDestination().getQualifiedName() + " expiring messages done.");
        }
    }

    @Override
    public void gc() {
    }

    @Override
    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        this.messageConsumed(context, node);
        if (this.store != null && node.isPersistent()) {
            this.store.removeAsyncMessage(context, this.convertToNonRangedAck(ack, node));
        }
    }

    Message loadMessage(MessageId messageId) throws IOException {
        Message msg = null;
        if (this.store != null && (msg = this.store.getMessage(messageId)) != null) {
            msg.setRegionDestination(this);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int size = 0;
        this.messagesLock.readLock().lock();
        try {
            size = this.messages.size();
            Object var3_2 = null;
            this.messagesLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.messagesLock.readLock().unlock();
            throw throwable;
        }
        return this.destination.getQualifiedName() + ", subscriptions=" + this.consumers.size() + ", memory=" + this.memoryUsage.getPercentUsage() + "%, size=" + size + ", in flight groups=" + this.messageGroupOwners;
    }

    @Override
    public void start() throws Exception {
        if (this.memoryUsage != null) {
            this.memoryUsage.start();
        }
        if (this.systemUsage.getStoreUsage() != null) {
            this.systemUsage.getStoreUsage().start();
        }
        this.systemUsage.getMemoryUsage().addUsageListener(this);
        this.messages.start();
        if (this.getExpireMessagesPeriod() > 0L) {
            this.scheduler.schedualPeriodically(this.expireMessagesTask, this.getExpireMessagesPeriod());
        }
        this.doPageIn(false);
    }

    @Override
    public void stop() throws Exception {
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
        if (this.executor != null) {
            ThreadPoolUtils.shutdownNow(this.executor);
            this.executor = null;
        }
        this.scheduler.cancel(this.expireMessagesTask);
        if (this.flowControlTimeoutTask.isAlive()) {
            this.flowControlTimeoutTask.interrupt();
        }
        if (this.messages != null) {
            this.messages.destroy();
        }
        this.systemUsage.getMemoryUsage().removeUsageListener(this);
        if (this.memoryUsage != null) {
            this.memoryUsage.stop();
        }
        if (this.store != null) {
            this.store.stop();
        }
    }

    @Override
    public BESMQDestination getBESMQDestination() {
        return this.destination;
    }

    public MessageGroupMap getMessageGroupOwners() {
        if (this.messageGroupOwners == null) {
            this.messageGroupOwners = this.getMessageGroupMapFactory().createMessageGroupMap();
        }
        return this.messageGroupOwners;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public MessageGroupMapFactory getMessageGroupMapFactory() {
        return this.messageGroupMapFactory;
    }

    public void setMessageGroupMapFactory(MessageGroupMapFactory messageGroupMapFactory) {
        this.messageGroupMapFactory = messageGroupMapFactory;
    }

    public PendingMessageCursor getMessages() {
        return this.messages;
    }

    public void setMessages(PendingMessageCursor messages) {
        this.messages = messages;
    }

    public boolean isUseConsumerPriority() {
        return this.useConsumerPriority;
    }

    public void setUseConsumerPriority(boolean useConsumerPriority) {
        this.useConsumerPriority = useConsumerPriority;
    }

    public boolean isStrictOrderDispatch() {
        return this.strictOrderDispatch;
    }

    public void setStrictOrderDispatch(boolean strictOrderDispatch) {
        this.strictOrderDispatch = strictOrderDispatch;
    }

    public boolean isOptimizedDispatch() {
        return this.optimizedDispatch;
    }

    public void setOptimizedDispatch(boolean optimizedDispatch) {
        this.optimizedDispatch = optimizedDispatch;
    }

    public int getTimeBeforeDispatchStarts() {
        return this.timeBeforeDispatchStarts;
    }

    public void setTimeBeforeDispatchStarts(int timeBeforeDispatchStarts) {
        this.timeBeforeDispatchStarts = timeBeforeDispatchStarts;
    }

    public int getConsumersBeforeDispatchStarts() {
        return this.consumersBeforeDispatchStarts;
    }

    public void setConsumersBeforeDispatchStarts(int consumersBeforeDispatchStarts) {
        this.consumersBeforeDispatchStarts = consumersBeforeDispatchStarts;
    }

    public void setAllConsumersExclusiveByDefault(boolean allConsumersExclusiveByDefault) {
        this.allConsumersExclusiveByDefault = allConsumersExclusiveByDefault;
    }

    public boolean isAllConsumersExclusiveByDefault() {
        return this.allConsumersExclusiveByDefault;
    }

    private QueueMessageReference createMessageReference(Message message) {
        IndirectMessageReference result = new IndirectMessageReference(message);
        return result;
    }

    @Override
    public Message[] browse() {
        ArrayList<Message> browseList = new ArrayList<Message>();
        this.doBrowse(browseList, this.getMaxBrowsePageSize());
        return browseList.toArray(new Message[browseList.size()]);
    }

    public Message[] browse(int browseSize) {
        ArrayList<Message> browseList = new ArrayList<Message>();
        this.doBrowse(browseList, browseSize);
        return browseList.toArray(new Message[browseList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBrowse(List<Message> browseList, int max) {
        block25: {
            ConnectionContext connectionContext = this.createConnectionContext();
            try {
                this.pageInMessages(!this.isUseCache());
                ArrayList<MessageReference> toExpire = new ArrayList<MessageReference>();
                this.pagedInPendingDispatchLock.writeLock().lock();
                try {
                    this.addAll(this.pagedInPendingDispatch.values(), browseList, max, toExpire);
                    for (MessageReference ref : toExpire) {
                        this.pagedInPendingDispatch.remove(ref);
                        if (!this.broker.isExpired(ref)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Expiring from pagedInPending: " + ref);
                        }
                        this.messageExpired(connectionContext, ref);
                    }
                    Object var8_10 = null;
                    this.pagedInPendingDispatchLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    this.pagedInPendingDispatchLock.writeLock().unlock();
                    throw throwable;
                }
                toExpire.clear();
                this.pagedInMessagesLock.readLock().lock();
                try {
                    this.addAll(this.pagedInMessages.values(), browseList, max, toExpire);
                    Object var10_14 = null;
                    this.pagedInMessagesLock.readLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    this.pagedInMessagesLock.readLock().unlock();
                    throw throwable;
                }
                for (MessageReference ref : toExpire) {
                    Object var12_18;
                    if (this.broker.isExpired(ref)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Expiring from pagedInMessages: " + ref);
                        }
                        this.messageExpired(connectionContext, ref);
                        continue;
                    }
                    this.pagedInMessagesLock.writeLock().lock();
                    try {
                        this.pagedInMessages.remove(ref.getMessageId());
                        var12_18 = null;
                        this.pagedInMessagesLock.writeLock().unlock();
                    }
                    catch (Throwable throwable) {
                        var12_18 = null;
                        this.pagedInMessagesLock.writeLock().unlock();
                        throw throwable;
                    }
                }
                if (browseList.size() >= max) break block25;
                this.messagesLock.writeLock().lock();
                try {
                    try {
                        this.messages.reset();
                        boolean cursorSwitched = false;
                        boolean hasNext = this.messages.hasNext();
                        int browseListSize = browseList.size();
                        ArrayList<Message> messagesFromCursor = new ArrayList<Message>(max - browseListSize);
                        while (hasNext && browseListSize < max) {
                            MessageReference node = this.messages.next();
                            Message message = node.getMessage();
                            if (node.isExpired()) {
                                if (this.broker.isExpired(node)) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Expiring from messages: " + node);
                                    }
                                    this.messageExpired(connectionContext, this.createMessageReference(message));
                                }
                                this.messages.remove();
                            } else if (!browseList.contains(message) && !messagesFromCursor.contains(message)) {
                                messagesFromCursor.add(message);
                                ++browseListSize;
                            }
                            if ((hasNext = this.messages.hasNext()) || cursorSwitched || !(this.messages instanceof StoreQueueCursor)) continue;
                            ((StoreQueueCursor)this.messages).switchCursor();
                            cursorSwitched = true;
                            hasNext = this.messages.hasNext();
                        }
                        for (Message message : messagesFromCursor) {
                            browseList.add(message);
                            if (this.messages.isInMemory(message)) continue;
                            message.decrementReferenceCount();
                        }
                        if (cursorSwitched) {
                            ((StoreQueueCursor)this.messages).switchCursor();
                        }
                        Object var14_20 = null;
                        this.messages.release();
                    }
                    catch (Throwable throwable) {
                        Object var14_21 = null;
                        this.messages.release();
                        throw throwable;
                    }
                    Object var16_23 = null;
                    this.messagesLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var16_24 = null;
                    this.messagesLock.writeLock().unlock();
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.error("Problem retrieving message for browse", e);
            }
        }
    }

    private void addAll(Collection<? extends MessageReference> refs, List<Message> l, int maxBrowsePageSize, List<MessageReference> toExpire) throws Exception {
        Iterator<? extends MessageReference> i = refs.iterator();
        while (i.hasNext() && l.size() < maxBrowsePageSize) {
            QueueMessageReference ref = (QueueMessageReference)i.next();
            if (ref.isExpired()) {
                toExpire.add(ref);
                continue;
            }
            if (l.contains(ref.getMessage())) continue;
            l.add(ref.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public QueueMessageReference getMessage(String id) {
        MessageId msgId = new MessageId(id);
        this.pagedInMessagesLock.readLock().lock();
        try {
            QueueMessageReference ref = this.pagedInMessages.get(msgId);
            if (ref != null) {
                QueueMessageReference queueMessageReference = ref;
                Object var6_6 = null;
                this.pagedInMessagesLock.readLock().unlock();
                return queueMessageReference;
            }
            Object var6_7 = null;
            this.pagedInMessagesLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.pagedInMessagesLock.readLock().unlock();
            throw throwable;
        }
        this.messagesLock.readLock().lock();
        try {
            QueueMessageReference queueMessageReference;
            try {
                this.messages.reset();
                while (this.messages.hasNext()) {
                    MessageReference mr = this.messages.next();
                    QueueMessageReference qmr = this.createMessageReference(mr.getMessage());
                    qmr.decrementReferenceCount();
                    this.messages.rollback(qmr.getMessageId());
                    if (!msgId.equals(qmr.getMessageId())) break block9;
                    queueMessageReference = qmr;
                    Object var8_11 = null;
                    this.messages.release();
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                this.messages.release();
                throw throwable;
            }
            {
                block9: {
                    Object var10_14 = null;
                    this.messagesLock.readLock().unlock();
                    return queueMessageReference;
                }
                continue;
            }
            Object var8_12 = null;
            this.messages.release();
            {
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.messagesLock.readLock().unlock();
            throw throwable;
        }
        Object var10_15 = null;
        this.messagesLock.readLock().unlock();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() throws Exception {
        ConnectionContext c = this.createConnectionContext();
        ArrayList<QueueMessageReference> list = null;
        try {
            this.sendLock.lock();
            do {
                this.doPageIn(true);
                this.pagedInMessagesLock.readLock().lock();
                try {
                    list = new ArrayList<QueueMessageReference>(this.pagedInMessages.values());
                    Object var4_6 = null;
                    this.pagedInMessagesLock.readLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    this.pagedInMessagesLock.readLock().unlock();
                    throw throwable;
                }
                for (MessageReference messageReference : list) {
                    try {
                        QueueMessageReference r = (QueueMessageReference)messageReference;
                        this.removeMessage(c, r);
                    }
                    catch (IOException e) {}
                }
            } while (!list.isEmpty() && this.destinationStatistics.getMessages().getCount() > 0L);
            if (this.getMessages().getMessageAudit() != null) {
                this.getMessages().getMessageAudit().clear();
            }
            if (this.destinationStatistics.getMessages().getCount() > 0L) {
                LOG.warn(this.getBESMQDestination().getQualifiedName() + " after purge complete, message count stats report: " + this.destinationStatistics.getMessages().getCount());
            }
            this.gc();
            this.destinationStatistics.getMessages().setCount(0L);
            this.getMessages().clear();
            Object var7_11 = null;
            this.sendLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.sendLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPendingMessages() {
        this.messagesLock.writeLock().lock();
        try {
            if (this.store != null) {
                this.store.resetBatching();
            }
            this.messages.gc();
            this.messages.reset();
            this.asyncWakeup();
            Object var2_1 = null;
            this.messagesLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.messagesLock.writeLock().unlock();
            throw throwable;
        }
    }

    public boolean removeMessage(String messageId) throws Exception {
        return this.removeMatchingMessages(this.createMessageIdFilter(messageId), 1) > 0;
    }

    public int removeMatchingMessages(String selector) throws Exception {
        return this.removeMatchingMessages(selector, -1);
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {
        return this.removeMatchingMessages(this.createSelectorFilter(selector), maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMatchingMessages(MessageReferenceFilter filter, int maximumMessages) throws Exception {
        int movedCounter = 0;
        LinkedHashSet<QueueMessageReference> set = new LinkedHashSet<QueueMessageReference>();
        ConnectionContext context = this.createConnectionContext();
        do {
            Object var7_8;
            this.doPageIn(true);
            this.pagedInMessagesLock.readLock().lock();
            try {
                set.addAll(this.pagedInMessages.values());
                var7_8 = null;
                this.pagedInMessagesLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                var7_8 = null;
                this.pagedInMessagesLock.readLock().unlock();
                throw throwable;
            }
            ArrayList list = new ArrayList(set);
            for (MessageReference ref : list) {
                IndirectMessageReference r = (IndirectMessageReference)ref;
                if (!filter.evaluate(context, r)) continue;
                this.removeMessage(context, r);
                set.remove(r);
                if (++movedCounter < maximumMessages || maximumMessages <= 0) continue;
                return movedCounter;
            }
        } while ((long)set.size() < this.destinationStatistics.getMessages().getCount());
        return movedCounter;
    }

    public boolean copyMessageTo(ConnectionContext context, String messageId, BESMQDestination dest) throws Exception {
        return this.copyMatchingMessages(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, BESMQDestination dest) throws Exception {
        return this.copyMatchingMessagesTo(context, selector, dest, -1);
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, BESMQDestination dest, int maximumMessages) throws Exception {
        return this.copyMatchingMessages(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyMatchingMessages(ConnectionContext context, MessageReferenceFilter filter, BESMQDestination dest, int maximumMessages) throws Exception {
        int movedCounter = 0;
        int count = 0;
        LinkedHashSet<QueueMessageReference> set = new LinkedHashSet<QueueMessageReference>();
        do {
            Object var10_11;
            int oldMaxSize = this.getMaxPageSize();
            this.setMaxPageSize((int)this.destinationStatistics.getMessages().getCount());
            this.doPageIn(true);
            this.setMaxPageSize(oldMaxSize);
            this.pagedInMessagesLock.readLock().lock();
            try {
                set.addAll(this.pagedInMessages.values());
                var10_11 = null;
                this.pagedInMessagesLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                var10_11 = null;
                this.pagedInMessagesLock.readLock().unlock();
                throw throwable;
            }
            ArrayList list = new ArrayList(set);
            for (MessageReference ref : list) {
                IndirectMessageReference r = (IndirectMessageReference)ref;
                if (filter.evaluate(context, r)) {
                    Object var16_15;
                    block8: {
                        int n;
                        r.incrementReferenceCount();
                        try {
                            Message m = r.getMessage();
                            BrokerSupport.resend(context, m, dest);
                            if (++movedCounter < maximumMessages || maximumMessages <= 0) break block8;
                            n = movedCounter;
                            var16_15 = null;
                            r.decrementReferenceCount();
                        }
                        catch (Throwable throwable) {
                            var16_15 = null;
                            r.decrementReferenceCount();
                            throw throwable;
                        }
                        return n;
                    }
                    var16_15 = null;
                    r.decrementReferenceCount();
                    {
                    }
                }
                ++count;
            }
        } while ((long)count < this.destinationStatistics.getMessages().getCount());
        return movedCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMessageTo(ConnectionContext context, QueueMessageReference m, BESMQDestination dest) throws Exception {
        BrokerSupport.resend(context, m.getMessage(), dest);
        this.removeMessage(context, m);
        this.messagesLock.writeLock().lock();
        try {
            this.messages.rollback(m.getMessageId());
            Object var5_4 = null;
            this.messagesLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.messagesLock.writeLock().unlock();
            throw throwable;
        }
        return true;
    }

    public boolean moveMessageTo(ConnectionContext context, String messageId, BESMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, BESMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, selector, dest, Integer.MAX_VALUE);
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, BESMQDestination dest, int maximumMessages) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveMatchingMessagesTo(ConnectionContext context, MessageReferenceFilter filter, BESMQDestination dest, int maximumMessages) throws Exception {
        int movedCounter = 0;
        LinkedHashSet<QueueMessageReference> set = new LinkedHashSet<QueueMessageReference>();
        do {
            Object var8_9;
            this.doPageIn(true);
            this.pagedInMessagesLock.readLock().lock();
            try {
                set.addAll(this.pagedInMessages.values());
                var8_9 = null;
                this.pagedInMessagesLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                var8_9 = null;
                this.pagedInMessagesLock.readLock().unlock();
                throw throwable;
            }
            ArrayList list = new ArrayList(set);
            for (QueueMessageReference ref : list) {
                if (!filter.evaluate(context, ref)) continue;
                this.moveMessageTo(context, ref, dest);
                set.remove(ref);
                if (++movedCounter < maximumMessages || maximumMessages <= 0) continue;
                return movedCounter;
            }
        } while ((long)set.size() < this.destinationStatistics.getMessages().getCount() && set.size() < maximumMessages);
        return movedCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean iterate() {
        MDC.put("besmq.destination", this.getName());
        boolean pageInMoreMessages = false;
        Object object = this.iteratingMutex;
        synchronized (object) {
            boolean bl;
            this.iterationRunning = true;
            Map<MessageId, WaitingForSpaceMessage> map = this.messagesWaitingForSpace;
            synchronized (map) {
                if (!this.messagesWaitingForSpace.isEmpty()) {
                    Iterator<WaitingForSpaceMessage> it = this.messagesWaitingForSpace.values().iterator();
                    while (it.hasNext() && !this.memoryUsage.isFull()) {
                        WaitingForSpaceMessage op = it.next();
                        if (op.getMessage().isPersistent() && this.store != null && this.systemUsage.getStoreUsage().isFull(this.getStoreUsageHighWaterMark()) || !op.getMessage().isPersistent() && this.messages.getSystemUsage() != null && this.systemUsage.getTempUsage().isFull()) continue;
                        it.remove();
                        op.run();
                    }
                    if (!this.messagesWaitingForSpace.isEmpty()) {
                        this.registerCallbackForNotFullNotification();
                    }
                }
            }
            if (this.firstConsumer) {
                this.firstConsumer = false;
                try {
                    if (this.consumersBeforeDispatchStarts > 0) {
                        int timeout = 1000;
                        if (this.timeBeforeDispatchStarts > 0) {
                            timeout = this.timeBeforeDispatchStarts;
                        }
                        if (this.consumersBeforeStartsLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(this.consumers.size() + " consumers subscribed. Starting dispatch.");
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug(timeout + " ms elapsed and " + this.consumers.size() + " consumers subscribed. Starting dispatch.");
                        }
                    }
                    if (this.timeBeforeDispatchStarts > 0 && this.consumersBeforeDispatchStarts <= 0) {
                        this.iteratingMutex.wait(this.timeBeforeDispatchStarts);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(this.timeBeforeDispatchStarts + " ms elapsed. Starting dispatch.");
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error(e.toString());
                }
            }
            BrowserDispatch pendingBrowserDispatch = this.browserDispatches.poll();
            this.messagesLock.readLock().lock();
            try {
                pageInMoreMessages |= !this.messages.isEmpty();
                Object var8_13 = null;
                this.messagesLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                this.messagesLock.readLock().unlock();
                throw throwable;
            }
            this.pagedInPendingDispatchLock.readLock().lock();
            try {
                bl = !this.pagedInPendingDispatch.isEmpty();
                Object var10_17 = null;
                this.pagedInPendingDispatchLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var10_18 = null;
                this.pagedInPendingDispatchLock.readLock().unlock();
                throw throwable;
            }
            if ((pageInMoreMessages |= bl) || pendingBrowserDispatch != null || !this.redeliveredWaitingDispatch.isEmpty()) {
                try {
                    this.pageInMessages(pendingBrowserDispatch != null);
                }
                catch (Throwable e) {
                    LOG.error("Failed to page in more queue messages ", e);
                }
            }
            if (pendingBrowserDispatch != null) {
                ArrayList<QueueMessageReference> alreadyDispatchedMessages = null;
                this.pagedInMessagesLock.readLock().lock();
                try {
                    alreadyDispatchedMessages = new ArrayList<QueueMessageReference>(this.pagedInMessages.values());
                    Object var12_20 = null;
                    this.pagedInMessagesLock.readLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var12_21 = null;
                    this.pagedInMessagesLock.readLock().unlock();
                    throw throwable;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dispatch to browser: " + pendingBrowserDispatch.getBrowser() + ", already dispatched/paged count: " + alreadyDispatchedMessages.size());
                }
                do {
                    try {
                        NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
                        msgContext.setDestination(this.destination);
                        QueueBrowserSubscription browser = pendingBrowserDispatch.getBrowser();
                        for (QueueMessageReference node : alreadyDispatchedMessages) {
                            if (node.isAcked()) continue;
                            ((MessageEvaluationContext)msgContext).setMessageReference(node);
                            if (!browser.matches(node, msgContext)) continue;
                            browser.add(node);
                        }
                        pendingBrowserDispatch.done();
                    }
                    catch (Exception e) {
                        LOG.warn("Exception on dispatch to browser: " + pendingBrowserDispatch.getBrowser(), e);
                    }
                } while ((pendingBrowserDispatch = this.browserDispatches.poll()) != null);
            }
            if (this.pendingWakeups.get() > 0L) {
                this.pendingWakeups.decrementAndGet();
            }
            MDC.remove("besmq.destination");
            this.iterationRunning = false;
            return this.pendingWakeups.get() > 0L;
        }
    }

    protected MessageReferenceFilter createMessageIdFilter(final String messageId) {
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) {
                return messageId.equals(r.getMessageId().toString());
            }

            public String toString() {
                return "MessageIdFilter: " + messageId;
            }
        };
    }

    protected MessageReferenceFilter createSelectorFilter(String selector) throws InvalidSelectorException {
        if (selector == null || selector.isEmpty()) {
            return new MessageReferenceFilter(){

                public boolean evaluate(ConnectionContext context, MessageReference messageReference) throws JMSException {
                    return true;
                }
            };
        }
        final BooleanExpression selectorExpression = SelectorParser.parse(selector);
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) throws JMSException {
                MessageEvaluationContext messageEvaluationContext = context.getMessageEvaluationContext();
                messageEvaluationContext.setMessageReference(r);
                if (messageEvaluationContext.getDestination() == null) {
                    messageEvaluationContext.setDestination(Queue.this.getBESMQDestination());
                }
                return selectorExpression.matches(messageEvaluationContext);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessage(ConnectionContext c, QueueMessageReference r) throws IOException {
        this.removeMessage(c, null, r);
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            this.pagedInPendingDispatch.remove(r);
            Object var4_3 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
            throw throwable;
        }
    }

    protected void removeMessage(ConnectionContext c, Subscription subs, QueueMessageReference r) throws IOException {
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)2);
        ack.setDestination(this.destination);
        ack.setMessageID(r.getMessageId());
        this.removeMessage(c, subs, r, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessage(ConnectionContext context, Subscription sub, QueueMessageReference reference, MessageAck ack) throws IOException {
        reference.setAcked(true);
        if (!ack.isInTransaction()) {
            this.acknowledge(context, sub, ack, reference);
            this.dropMessage(reference);
        } else {
            try {
                this.acknowledge(context, sub, ack, reference);
                Object var6_5 = null;
                context.getTransaction().addSynchronization(new Synchronization(reference){
                    final /* synthetic */ QueueMessageReference val$reference;
                    {
                        this.val$reference = queueMessageReference;
                    }

                    public void afterCommit() throws Exception {
                        Queue.this.dropMessage(this.val$reference);
                        Queue.this.wakeup();
                    }

                    public void afterRollback() throws Exception {
                        this.val$reference.setAcked(false);
                        Queue.this.wakeup();
                    }
                });
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                context.getTransaction().addSynchronization(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        if (ack.isPoisonAck()) {
            this.messagesLock.writeLock().lock();
            try {
                this.messages.rollback(reference.getMessageId());
                Object var8_8 = null;
                this.messagesLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.messagesLock.writeLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropMessage(QueueMessageReference reference) {
        reference.drop();
        QueueMessageReference messageReference = null;
        this.pagedInMessagesLock.writeLock().lock();
        try {
            messageReference = (QueueMessageReference)this.pagedInMessages.remove(reference.getMessageId());
            Object var4_3 = null;
            this.pagedInMessagesLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.pagedInMessagesLock.writeLock().unlock();
            throw throwable;
        }
        if (messageReference != null || reference.isExpired()) {
            this.destinationStatistics.getDequeues().increment();
            this.destinationStatistics.getMessages().decrement();
        }
    }

    public void messageExpired(ConnectionContext context, MessageReference reference) {
        this.messageExpired(context, null, reference);
    }

    @Override
    public void messageExpired(ConnectionContext context, Subscription subs, MessageReference reference) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message expired: " + reference);
        }
        this.broker.messageExpired(context, reference, subs);
        this.destinationStatistics.getExpired().increment();
        try {
            this.removeMessage(context, subs, (QueueMessageReference)reference);
        }
        catch (IOException e) {
            LOG.error("Failed to remove expired Message from the store ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendMessage(ConnectionContext context, Message msg) throws Exception {
        this.messagesLock.writeLock().lock();
        try {
            msg.incrementReferenceCount();
            while (!this.messages.tryAddMessageLast(msg, 0L)) {
                if (context.getStopping().get()) {
                    msg.decrementReferenceCount();
                    throw new IOException("Connection closed, send aborted.");
                }
                this.messagesLockCondition.await(this.waitForSpacePollTime, TimeUnit.MILLISECONDS);
            }
            Object var4_3 = null;
            this.messagesLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.messagesLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void messageSent(ConnectionContext context, Message msg) throws Exception {
        this.destinationStatistics.getEnqueues().increment();
        this.destinationStatistics.getMessages().increment();
        this.messageDelivered(context, msg);
        this.consumersLock.readLock().lock();
        try {
            if (this.consumers.isEmpty()) {
                this.onMessageWithNoConsumers(context, msg);
            }
            Object var4_3 = null;
            this.consumersLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.consumersLock.readLock().unlock();
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.broker.getBrokerName() + " Message " + msg.getMessageId() + " sent to " + this.destination);
        }
        this.wakeup();
    }

    @Override
    public void wakeup() {
        if ((this.optimizedDispatch || this.isSlave()) && !this.iterationRunning) {
            this.iterate();
            this.pendingWakeups.incrementAndGet();
        } else {
            this.asyncWakeup();
        }
    }

    private void asyncWakeup() {
        try {
            this.pendingWakeups.incrementAndGet();
            this.taskRunner.wakeup();
        }
        catch (InterruptedException e) {
            LOG.warn("Async task runner failed to wakeup ", e);
        }
    }

    private boolean isSlave() {
        return this.broker.getBrokerService().isSlave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPageIn(boolean force) throws Exception {
        PendingList newlyPaged = this.doPageInForDispatch(force);
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            if (this.pagedInPendingDispatch.isEmpty()) {
                this.pagedInPendingDispatch.addAll(newlyPaged);
            } else {
                for (MessageReference qmr : newlyPaged) {
                    if (this.pagedInPendingDispatch.contains(qmr)) continue;
                    this.pagedInPendingDispatch.addMessageLast(qmr);
                }
            }
            Object var6_5 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingList doPageInForDispatch(boolean force) throws Exception {
        ArrayList<QueueMessageReference> result = null;
        PendingList resultList = null;
        int toPageIn = Math.min(this.getMaxPageSize(), this.messages.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.destination.getPhysicalName() + " toPageIn: " + toPageIn + ", Inflight: " + this.destinationStatistics.getInflight().getCount() + ", pagedInMessages.size " + this.pagedInMessages.size() + ", enqueueCount: " + this.destinationStatistics.getEnqueues().getCount() + ", dequeueCount: " + this.destinationStatistics.getDequeues().getCount());
        }
        if (this.isLazyDispatch() && !force) {
            toPageIn = Math.min(this.getConsumerMessageCountBeforeFull(), toPageIn);
        }
        int pagedInPendingSize = 0;
        this.pagedInPendingDispatchLock.readLock().lock();
        try {
            pagedInPendingSize = this.pagedInPendingDispatch.size();
            Object var7_6 = null;
            this.pagedInPendingDispatchLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.pagedInPendingDispatchLock.readLock().unlock();
            throw throwable;
        }
        if (toPageIn > 0 && (force || !this.consumers.isEmpty()) && pagedInPendingSize < this.getMaxPageSize()) {
            int count = 0;
            result = new ArrayList<QueueMessageReference>(toPageIn);
            this.messagesLock.writeLock().lock();
            try {
                try {
                    this.messages.setMaxBatchSize(toPageIn);
                    this.messages.reset();
                    while (this.messages.hasNext() && count < toPageIn) {
                        MessageReference node = this.messages.next();
                        this.messages.remove();
                        QueueMessageReference ref = this.createMessageReference(node.getMessage());
                        if (ref.isExpired()) {
                            if (!this.broker.isExpired(ref)) continue;
                            this.messageExpired(this.createConnectionContext(), ref);
                            continue;
                        }
                        result.add(ref);
                        ++count;
                    }
                    Object var10_11 = null;
                    this.messages.release();
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    this.messages.release();
                    throw throwable;
                }
                Object var12_14 = null;
                this.messagesLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                this.messagesLock.writeLock().unlock();
                throw throwable;
            }
            this.pagedInMessagesLock.writeLock().lock();
            try {
                resultList = this.isPrioritizedMessages() ? new PrioritizedPendingList() : new OrderedPendingList();
                for (QueueMessageReference ref : result) {
                    if (!this.pagedInMessages.containsKey(ref.getMessageId())) {
                        this.pagedInMessages.put(ref.getMessageId(), ref);
                        resultList.addMessageLast(ref);
                        continue;
                    }
                    ref.decrementReferenceCount();
                }
                Object var14_17 = null;
                this.pagedInMessagesLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                this.pagedInMessagesLock.writeLock().unlock();
                throw throwable;
            }
        }
        resultList = new OrderedPendingList();
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDispatch(PendingList list) throws Exception {
        boolean doWakeUp = false;
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            if (!this.redeliveredWaitingDispatch.isEmpty()) {
                this.redeliveredWaitingDispatch = this.doActualDispatch(this.redeliveredWaitingDispatch);
            }
            if (!this.pagedInPendingDispatch.isEmpty()) {
                this.pagedInPendingDispatch = this.doActualDispatch(this.pagedInPendingDispatch);
            }
            if (list != null && !list.isEmpty()) {
                if (this.pagedInPendingDispatch.isEmpty()) {
                    this.pagedInPendingDispatch.addAll(this.doActualDispatch(list));
                } else {
                    for (MessageReference qmr : list) {
                        if (this.pagedInPendingDispatch.contains(qmr)) continue;
                        this.pagedInPendingDispatch.addMessageLast(qmr);
                    }
                    doWakeUp = true;
                }
            }
            Object var6_5 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
            throw throwable;
        }
        if (doWakeUp) {
            this.asyncWakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingList doActualDispatch(PendingList list) throws Exception {
        block14: {
            this.consumersLock.writeLock().lock();
            try {
                if (!this.consumers.isEmpty() && !this.isSlave()) break block14;
                PendingList pendingList = list;
                Object var5_4 = null;
                this.consumersLock.writeLock().unlock();
                return pendingList;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.consumersLock.writeLock().unlock();
                throw throwable;
            }
        }
        ArrayList<Subscription> consumers = new ArrayList<Subscription>(this.consumers);
        Object var5_5 = null;
        this.consumersLock.writeLock().unlock();
        PendingList rc = this.isPrioritizedMessages() ? new PrioritizedPendingList() : new OrderedPendingList();
        HashSet<Subscription> fullConsumers = new HashSet<Subscription>(consumers.size());
        for (MessageReference node : list) {
            Object var12_15;
            Subscription target = null;
            int interestCount = 0;
            for (Subscription s : consumers) {
                if (s instanceof QueueBrowserSubscription) {
                    ++interestCount;
                    continue;
                }
                if (!fullConsumers.contains(s)) {
                    if (!s.isFull()) {
                        if (this.dispatchSelector.canSelect(s, node) && this.assignMessageGroup(s, (QueueMessageReference)node) && !((QueueMessageReference)node).isAcked()) {
                            s.add(node);
                            target = s;
                            break;
                        }
                    } else {
                        fullConsumers.add(s);
                        LOG.trace("Subscription full {}", s);
                    }
                }
                if (node.isDropped()) continue;
                ++interestCount;
            }
            if (target == null && interestCount > 0 || consumers.size() == 0) {
                rc.addMessageLast((QueueMessageReference)node);
            }
            if (target == null || this.strictOrderDispatch || consumers.size() <= 1 || this.dispatchSelector.isExclusiveConsumer(target)) continue;
            this.consumersLock.writeLock().lock();
            try {
                if (this.removeFromConsumerList(target)) {
                    this.addToConsumerList(target);
                    consumers = new ArrayList<Subscription>(this.consumers);
                }
                var12_15 = null;
                this.consumersLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                var12_15 = null;
                this.consumersLock.writeLock().unlock();
                throw throwable;
            }
        }
        return rc;
    }

    protected boolean assignMessageGroup(Subscription subscription, QueueMessageReference node) throws Exception {
        boolean result = true;
        String groupId = node.getGroupID();
        int sequence = node.getGroupSequence();
        if (groupId != null) {
            MessageGroupMap messageGroupOwners = this.getMessageGroupOwners();
            if (sequence == 1) {
                this.assignGroup(subscription, messageGroupOwners, node, groupId);
            } else {
                ConsumerId groupOwner = messageGroupOwners.get(groupId);
                if (groupOwner == null) {
                    this.assignGroup(subscription, messageGroupOwners, node, groupId);
                } else if (groupOwner.equals(subscription.getConsumerInfo().getConsumerId())) {
                    if (sequence < 0) {
                        messageGroupOwners.removeGroup(groupId);
                        subscription.getConsumerInfo().setLastDeliveredSequenceId(subscription.getConsumerInfo().getLastDeliveredSequenceId() - 1L);
                    }
                } else {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void assignGroup(Subscription subs, MessageGroupMap messageGroupOwners, MessageReference n, String groupId) throws IOException {
        messageGroupOwners.put(groupId, subs.getConsumerInfo().getConsumerId());
        Message message = n.getMessage();
        if (message instanceof BESMQMessage) {
            BESMQMessage activeMessage = (BESMQMessage)message;
            try {
                activeMessage.setBooleanProperty("JMSXGroupFirstForConsumer", true, false);
            }
            catch (JMSException e) {
                LOG.warn("Failed to set boolean header: " + e, e);
            }
        }
        subs.getConsumerInfo().setLastDeliveredSequenceId(subs.getConsumerInfo().getLastDeliveredSequenceId() + 1L);
    }

    protected void pageInMessages(boolean force) throws Exception {
        this.doDispatch(this.doPageInForDispatch(force));
    }

    private void addToConsumerList(Subscription sub) {
        if (this.useConsumerPriority) {
            this.consumers.add(sub);
            Collections.sort(this.consumers, this.orderedCompare);
        } else {
            this.consumers.add(sub);
        }
    }

    private boolean removeFromConsumerList(Subscription sub) {
        return this.consumers.remove(sub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConsumerMessageCountBeforeFull() throws Exception {
        int total = 0;
        boolean zeroPrefetch = false;
        this.consumersLock.readLock().lock();
        try {
            for (Subscription s : this.consumers) {
                zeroPrefetch |= s.getPrefetchSize() == 0;
                int countBeforeFull = s.countBeforeFull();
                total += countBeforeFull;
            }
            Object var7_6 = null;
            this.consumersLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.consumersLock.readLock().unlock();
            throw throwable;
        }
        if (total == 0 && zeroPrefetch) {
            total = 1;
        }
        return total;
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Subscription sub = this.getMatchingSubscription(messageDispatchNotification);
        if (sub != null) {
            QueueMessageReference message = this.getMatchingMessage(messageDispatchNotification);
            sub.add(message);
            sub.processMessageDispatchNotification(messageDispatchNotification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueMessageReference getMatchingMessage(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Message msg;
        QueueMessageReference message = null;
        MessageId messageId = messageDispatchNotification.getMessageId();
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            for (MessageReference ref : this.pagedInPendingDispatch) {
                if (!messageId.equals(ref.getMessageId())) continue;
                message = (QueueMessageReference)ref;
                this.pagedInPendingDispatch.remove(ref);
                break;
            }
            Object var7_6 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.pagedInPendingDispatchLock.writeLock().unlock();
            throw throwable;
        }
        if (message == null) {
            this.pagedInMessagesLock.readLock().lock();
            try {
                message = this.pagedInMessages.get(messageId);
                Object var9_9 = null;
                this.pagedInMessagesLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.pagedInMessagesLock.readLock().unlock();
                throw throwable;
            }
        }
        if (message == null) {
            this.messagesLock.writeLock().lock();
            try {
                try {
                    this.messages.setMaxBatchSize(this.getMaxPageSize());
                    this.messages.reset();
                    while (this.messages.hasNext()) {
                        MessageReference node = this.messages.next();
                        this.messages.remove();
                        if (!messageId.equals(node.getMessageId())) continue;
                        message = this.createMessageReference(node.getMessage());
                        break;
                    }
                    Object var11_12 = null;
                    this.messages.release();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    this.messages.release();
                    throw throwable;
                }
                Object var13_15 = null;
                this.messagesLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                this.messagesLock.writeLock().unlock();
                throw throwable;
            }
        }
        if (message == null && (msg = this.loadMessage(messageId)) != null) {
            message = this.createMessageReference(msg);
        }
        if (message == null) {
            throw new JMSException("Slave broker out of sync with master - Message: " + messageDispatchNotification.getMessageId() + " on " + messageDispatchNotification.getDestination() + " does not exist among pending(" + this.pagedInPendingDispatch.size() + ") for subscription: " + messageDispatchNotification.getConsumerId());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subscription getMatchingSubscription(MessageDispatchNotification messageDispatchNotification) throws JMSException {
        Subscription sub = null;
        this.consumersLock.readLock().lock();
        try {
            for (Subscription s : this.consumers) {
                if (!messageDispatchNotification.getConsumerId().equals(s.getConsumerInfo().getConsumerId())) continue;
                sub = s;
                break;
            }
            Object var6_5 = null;
            this.consumersLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.consumersLock.readLock().unlock();
            throw throwable;
        }
        return sub;
    }

    @Override
    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (oldPercentUsage > newPercentUsage) {
            this.asyncWakeup();
        }
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOptimizeStorage() {
        boolean result = false;
        if (this.isDoOptimzeMessageStorage()) {
            this.consumersLock.readLock().lock();
            try {
                if (!this.consumers.isEmpty()) {
                    result = true;
                    for (Subscription s : this.consumers) {
                        if (s.getPrefetchSize() == 0) {
                            result = false;
                            break;
                        }
                        if (s.isSlowConsumer()) {
                            result = false;
                            break;
                        }
                        if (s.getInFlightUsage() <= this.getOptimizeMessageStoreInFlightLimit()) continue;
                        result = false;
                        break;
                    }
                }
                Object var5_4 = null;
                this.consumersLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.consumersLock.readLock().unlock();
                throw throwable;
            }
        }
        return result;
    }

    class BrowserDispatch {
        QueueBrowserSubscription browser;

        public BrowserDispatch(QueueBrowserSubscription browserSubscription) {
            this.browser = browserSubscription;
            this.browser.incrementQueueRef();
        }

        void done() {
            try {
                this.browser.decrementQueueRef();
            }
            catch (Exception e) {
                LOG.warn("Decrement ref on browser: " + this.browser, e);
            }
        }

        public QueueBrowserSubscription getBrowser() {
            return this.browser;
        }
    }

    class BatchMessageRecoveryListener
    implements MessageRecoveryListener {
        final LinkedList<Message> toExpire = new LinkedList();
        final double totalMessageCount;
        int recoveredAccumulator = 0;
        int currentBatchCount;

        BatchMessageRecoveryListener(int totalMessageCount) {
            this.totalMessageCount = totalMessageCount;
            this.currentBatchCount = this.recoveredAccumulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean recoverMessage(Message message) {
            ++this.recoveredAccumulator;
            if (LOG.isInfoEnabled() && this.recoveredAccumulator % 10000 == 0) {
                LOG.info("Cursor for " + Queue.this.getBESMQDestination().getQualifiedName() + " has recovered " + this.recoveredAccumulator + " messages. " + (int)((double)(this.recoveredAccumulator * 100) / this.totalMessageCount) + "% complete");
            }
            if (message.isExpired() && Queue.this.broker.isExpired(message)) {
                this.toExpire.add(message);
                return true;
            }
            if (this.hasSpace()) {
                message.setRegionDestination(Queue.this);
                Queue.this.messagesLock.writeLock().lock();
                try {
                    try {
                        Queue.this.messages.addMessageLast(message);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to add message to cursor", e);
                    }
                    Object var4_3 = null;
                    Queue.this.messagesLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Queue.this.messagesLock.writeLock().unlock();
                    throw throwable;
                }
                Queue.this.destinationStatistics.getMessages().increment();
                return true;
            }
            return false;
        }

        public boolean recoverMessageReference(MessageId messageReference) throws Exception {
            throw new RuntimeException("Should not be called.");
        }

        public boolean hasSpace() {
            return true;
        }

        public boolean isDuplicate(MessageId id) {
            return false;
        }

        public void reset() {
            this.currentBatchCount = this.recoveredAccumulator;
        }

        public void processExpired() {
            for (Message message : this.toExpire) {
                Queue.this.messageExpired(Queue.this.createConnectionContext(), Queue.this.createMessageReference(message));
                Queue.this.destinationStatistics.getMessages().increment();
            }
            this.toExpire.clear();
        }

        public boolean done() {
            return this.currentBatchCount == this.recoveredAccumulator;
        }
    }

    final class QueueThread
    extends Thread {
        final Queue queue;

        public QueueThread(Runnable runnable, String name, Queue queue2) {
            super(runnable, name);
            this.queue = queue2;
        }
    }

    class FlowControlTimeoutTask
    extends Thread {
        FlowControlTimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    TimeoutMessage timeout;
                    if ((timeout = (TimeoutMessage)Queue.this.flowControlTimeoutMessages.take()) == null) {
                        continue;
                    }
                    Map map = Queue.this.messagesWaitingForSpace;
                    synchronized (map) {
                        if (Queue.this.messagesWaitingForSpace.remove(timeout.message.getMessageId()) != null) {
                            ResourceAllocationException resourceAllocationException = new ResourceAllocationException("Usage Manager Memory Limit reached. Stopping producer (" + timeout.message.getProducerId() + ") to prevent flooding " + Queue.this.getBESMQDestination().getQualifiedName());
                            if (timeout.message.isResponseRequired()) {
                                ExceptionResponse response = new ExceptionResponse(resourceAllocationException);
                                response.setCorrelationId(timeout.message.getCommandId());
                                timeout.context.getConnection().dispatchAsync(response);
                            } else {
                                ConnectionError ce = new ConnectionError();
                                ce.setException(resourceAllocationException);
                                timeout.context.getConnection().dispatchAsync(ce);
                            }
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getName() + "Producer Flow Control Timeout Task is stopping");
                }
                return;
            }
        }
    }

    class TimeoutMessage
    implements Delayed {
        Message message;
        ConnectionContext context;
        long trigger;

        public TimeoutMessage(Message message, ConnectionContext context, long delay) {
            this.message = message;
            this.context = context;
            this.trigger = System.currentTimeMillis() + delay;
        }

        public long getDelay(TimeUnit unit) {
            long n = this.trigger - System.currentTimeMillis();
            return unit.convert(n, TimeUnit.MILLISECONDS);
        }

        public int compareTo(Delayed delayed) {
            long other = ((TimeoutMessage)delayed).trigger;
            int returnValue = this.trigger < other ? -1 : (this.trigger > other ? 1 : 0);
            return returnValue;
        }
    }

    private abstract class WaitingForSpaceMessage
    implements Runnable {
        Message message;

        public WaitingForSpaceMessage(Message message) {
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

