/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.QueueMessageReference;
import com.bes.mq.broker.region.QueueSubscription;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.MessageAck;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.usage.SystemUsage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.InvalidSelectorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueBrowserSubscription
extends QueueSubscription {
    int queueRefs;
    boolean browseDone;
    boolean destinationsAdded;

    public QueueBrowserSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(broker, usageManager, context, info);
    }

    @Override
    protected boolean canDispatch(MessageReference node) {
        return !((QueueMessageReference)node).isAcked();
    }

    @Override
    public synchronized String toString() {
        return "QueueBrowserSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.prefetchExtension + ", pending=" + this.getPendingQueueSize();
    }

    public synchronized void destinationsAdded() throws Exception {
        this.destinationsAdded = true;
        this.checkDone();
    }

    private void checkDone() throws Exception {
        if (!this.browseDone && this.queueRefs == 0 && this.destinationsAdded) {
            this.browseDone = true;
            this.add(QueueMessageReference.NULL_MESSAGE);
        }
    }

    @Override
    public boolean matches(MessageReference node, MessageEvaluationContext context) throws IOException {
        return !this.browseDone && super.matches(node, context);
    }

    @Override
    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference n) throws IOException {
        if (this.info.isNetworkSubscription()) {
            super.acknowledge(context, ack, n);
        }
    }

    public synchronized void incrementQueueRef() {
        ++this.queueRefs;
    }

    public synchronized void decrementQueueRef() throws Exception {
        --this.queueRefs;
        this.checkDone();
    }

    @Override
    public List<MessageReference> remove(ConnectionContext context, Destination destination) throws Exception {
        super.remove(context, destination);
        return new ArrayList<MessageReference>();
    }
}

