/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.AbstractRegion;
import com.bes.mq.broker.region.DestinationFactory;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.QueueBrowserSubscription;
import com.bes.mq.broker.region.QueueSubscription;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.PolicyEntry;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.MessageDispatchNotification;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.usage.SystemUsage;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueRegion
extends AbstractRegion {
    public QueueRegion(RegionBroker broker, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    public String toString() {
        return "QueueRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.usageManager.getMemoryUsage().getPercentUsage() + "%";
    }

    @Override
    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        BESMQDestination destination = info.getDestination();
        PolicyEntry entry = null;
        if (destination != null && this.broker.getDestinationPolicy() != null) {
            entry = this.broker.getDestinationPolicy().getEntryFor(destination);
        }
        if (info.isBrowser()) {
            QueueBrowserSubscription sub = new QueueBrowserSubscription(this.broker, this.usageManager, context, info);
            if (entry != null) {
                entry.configure((Broker)this.broker, this.usageManager, sub);
            }
            return sub;
        }
        QueueSubscription sub = new QueueSubscription(this.broker, this.usageManager, context, info);
        if (entry != null) {
            entry.configure((Broker)this.broker, this.usageManager, sub);
        }
        return sub;
    }

    @Override
    protected Set<BESMQDestination> getInactiveDestinations() {
        Set<BESMQDestination> inactiveDestinations = super.getInactiveDestinations();
        Iterator<BESMQDestination> iter = inactiveDestinations.iterator();
        while (iter.hasNext()) {
            BESMQDestination dest = iter.next();
            if (dest.isQueue()) continue;
            iter.remove();
        }
        return inactiveDestinations;
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        this.processDispatchNotificationViaDestination(messageDispatchNotification);
    }
}

