/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.IndirectMessageReference;
import com.bes.mq.broker.region.LockOwner;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.PrefetchSubscription;
import com.bes.mq.broker.region.Queue;
import com.bes.mq.broker.region.QueueMessageReference;
import com.bes.mq.broker.region.group.MessageGroupMap;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.usage.SystemUsage;
import java.io.IOException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class QueueSubscription
extends PrefetchSubscription
implements LockOwner {
    private static final Logger LOG = LoggerFactory.getLogger(QueueSubscription.class);

    public QueueSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(broker, usageManager, context, info);
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference n) throws IOException {
        Destination q = n.getRegionDestination();
        QueueMessageReference node = (QueueMessageReference)n;
        Queue queue = (Queue)q;
        if (n.isExpired() && !this.broker.isExpired(n)) {
            LOG.warn("Ignoring ack " + ack + ", for already expired message: " + n);
            return;
        }
        queue.removeMessage(context, this, node, ack);
    }

    protected boolean canDispatch(MessageReference n) throws IOException {
        boolean result = true;
        QueueMessageReference node = (QueueMessageReference)n;
        if (node.isAcked() || node.isDropped()) {
            result = false;
        }
        result = result && (this.isBrowser() || node.lock(this));
        return result;
    }

    protected void assignGroupToMe(MessageGroupMap messageGroupOwners, MessageReference n, String groupId) throws IOException {
        messageGroupOwners.put(groupId, this.info.getConsumerId());
        Message message = n.getMessage();
        if (message instanceof BESMQMessage) {
            BESMQMessage activeMessage = (BESMQMessage)message;
            try {
                activeMessage.setBooleanProperty("JMSXGroupFirstForConsumer", true, false);
            }
            catch (JMSException e) {
                LOG.warn("Failed to set boolean header: " + e, e);
            }
        }
    }

    public synchronized String toString() {
        return "QueueSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.prefetchExtension + ", pending=" + this.getPendingQueueSize();
    }

    public int getLockPriority() {
        return this.info.getPriority();
    }

    public boolean isLockExclusive() {
        return this.info.isExclusive();
    }

    public void destroy() {
        this.setSlowConsumer(false);
    }

    protected boolean isDropped(MessageReference node) {
        boolean result = false;
        if (node instanceof IndirectMessageReference) {
            QueueMessageReference qmr = (QueueMessageReference)node;
            result = qmr.isDropped();
        }
        return result;
    }
}

