/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.Connection;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ConsumerBrokerExchange;
import com.bes.mq.broker.EmptyBroker;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.TransportConnector;
import com.bes.mq.broker.region.BaseDestination;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFactory;
import com.bes.mq.broker.region.DestinationInterceptor;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.QueueRegion;
import com.bes.mq.broker.region.Region;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.TempQueueRegion;
import com.bes.mq.broker.region.TempTopicRegion;
import com.bes.mq.broker.region.TopicRegion;
import com.bes.mq.broker.region.policy.DeadLetterStrategy;
import com.bes.mq.broker.region.policy.PolicyMap;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerControl;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessageDispatchNotification;
import com.bes.mq.command.MessagePull;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.TransactionId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.state.ConnectionState;
import com.bes.mq.store.hsdb.plist.PListStore;
import com.bes.mq.thread.Scheduler;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.BrokerSupport;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.InetAddressUtil;
import com.bes.mq.util.LongSequenceGenerator;
import com.bes.mq.util.ServiceStopper;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionBroker
extends EmptyBroker {
    public static final String ORIGINAL_EXPIRATION = "originalExpiration";
    private static final Logger LOG = LoggerFactory.getLogger(RegionBroker.class);
    private static final IdGenerator BROKER_ID_GENERATOR = new IdGenerator();
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    protected DestinationFactory destinationFactory;
    protected final Map<ConnectionId, ConnectionState> connectionStates = Collections.synchronizedMap(new HashMap());
    private final Region queueRegion;
    private final Region topicRegion;
    private final Region tempQueueRegion;
    private final Region tempTopicRegion;
    protected final BrokerService brokerService;
    private boolean started;
    private boolean keepDurableSubsActive;
    private final CopyOnWriteArrayList<Connection> connections = new CopyOnWriteArrayList();
    private final Map<BESMQDestination, Destination> destinations = new ConcurrentHashMap<BESMQDestination, Destination>();
    private final Map<BrokerId, BrokerInfo> brokerInfos = new HashMap<BrokerId, BrokerInfo>();
    private final LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    private BrokerId brokerId;
    private String brokerName;
    private final Map<String, ConnectionContext> clientIdSet = new HashMap<String, ConnectionContext>();
    private final DestinationInterceptor destinationInterceptor;
    private ConnectionContext adminConnectionContext;
    private final Scheduler scheduler;
    private final ThreadPoolExecutor executor;
    private boolean allowTempAutoCreationOnSend;
    private final ReentrantReadWriteLock inactiveDestinationsPurgeLock = new ReentrantReadWriteLock();
    private final Runnable purgeInactiveDestinationsTask = new Runnable(){

        public void run() {
            RegionBroker.this.purgeInactiveDestinations();
        }
    };

    public RegionBroker(BrokerService brokerService, TaskRunnerFactory taskRunnerFactory, SystemUsage memoryManager, DestinationFactory destinationFactory, DestinationInterceptor destinationInterceptor, Scheduler scheduler, ThreadPoolExecutor executor) throws IOException {
        this.brokerService = brokerService;
        this.executor = executor;
        this.scheduler = scheduler;
        if (destinationFactory == null) {
            throw new IllegalArgumentException("Null destinationFactory");
        }
        this.sequenceGenerator.setLastSequenceId(destinationFactory.getLastMessageBrokerSequenceId());
        this.destinationFactory = destinationFactory;
        this.queueRegion = this.createQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.topicRegion = this.createTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.destinationInterceptor = destinationInterceptor;
        this.tempQueueRegion = this.createTempQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.tempTopicRegion = this.createTempTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    public Map<BESMQDestination, Destination> getDestinationMap() {
        HashMap<BESMQDestination, Destination> answer = new HashMap<BESMQDestination, Destination>(this.getQueueRegion().getDestinationMap());
        answer.putAll(this.getTopicRegion().getDestinationMap());
        return answer;
    }

    public ConnectionContext getConnectionContext(String clientId) {
        return this.clientIdSet.get(clientId);
    }

    @Override
    public Set<Destination> getDestinations(BESMQDestination destination) {
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion.getDestinations(destination);
            }
            case 2: {
                return this.topicRegion.getDestinations(destination);
            }
            case 5: {
                return this.tempQueueRegion.getDestinations(destination);
            }
            case 6: {
                return this.tempTopicRegion.getDestinations(destination);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Broker getAdaptor(Class type) {
        if (type.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Region getQueueRegion() {
        return this.queueRegion;
    }

    public Region getTempQueueRegion() {
        return this.tempQueueRegion;
    }

    public Region getTempTopicRegion() {
        return this.tempTopicRegion;
    }

    public Region getTopicRegion() {
        return this.topicRegion;
    }

    protected Region createTempTopicRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTempQueueRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempQueueRegion(this, this.brokerService, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTopicRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createQueueRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new QueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    public void start() throws Exception {
        this.started = true;
        this.queueRegion.start();
        this.topicRegion.start();
        this.tempQueueRegion.start();
        this.tempTopicRegion.start();
        int period = this.brokerService.getSchedulePeriodForDestinationPurge();
        if (period > 0) {
            this.scheduler.executePeriodically(this.purgeInactiveDestinationsTask, period);
        }
    }

    @Override
    public void stop() throws Exception {
        this.started = false;
        this.scheduler.cancel(this.purgeInactiveDestinationsTask);
        ServiceStopper ss = new ServiceStopper();
        this.doStop(ss);
        ss.throwFirstException();
        this.clientIdSet.clear();
        this.connections.clear();
        this.destinations.clear();
        this.brokerInfos.clear();
    }

    public PolicyMap getDestinationPolicy() {
        return this.brokerService != null ? this.brokerService.getDestinationPolicy() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        Map<String, ConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            ConnectionContext oldContext = this.clientIdSet.get(clientId);
            if (oldContext != null) {
                throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected from " + oldContext.getConnection().getRemoteAddress());
            }
            this.clientIdSet.put(clientId, context);
        }
        this.connections.add(context.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection disconnect request");
        }
        Map<String, ConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            ConnectionContext oldValue = this.clientIdSet.get(clientId);
            if (oldValue == context && this.isEqual(oldValue.getConnectionId(), info.getConnectionId())) {
                this.clientIdSet.remove(clientId);
            }
        }
        this.connections.remove(context.getConnection());
    }

    protected boolean isEqual(ConnectionId connectionId, ConnectionId connectionId2) {
        return connectionId == connectionId2 || connectionId != null && connectionId.equals(connectionId2);
    }

    @Override
    public Connection[] getClients() throws Exception {
        ArrayList<Connection> l = new ArrayList<Connection>(this.connections);
        Connection[] rc = new Connection[l.size()];
        l.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination addDestination(ConnectionContext context, BESMQDestination destination, boolean createIfTemp) throws Exception {
        Destination answer = this.destinations.get(destination);
        if (answer != null) {
            return answer;
        }
        Map<BESMQDestination, Destination> map = this.destinations;
        synchronized (map) {
            answer = this.destinations.get(destination);
            if (answer != null) {
                return answer;
            }
            switch (destination.getDestinationType()) {
                case 1: {
                    answer = this.queueRegion.addDestination(context, destination, true);
                    break;
                }
                case 2: {
                    answer = this.topicRegion.addDestination(context, destination, true);
                    break;
                }
                case 5: {
                    answer = this.tempQueueRegion.addDestination(context, destination, createIfTemp);
                    break;
                }
                case 6: {
                    answer = this.tempTopicRegion.addDestination(context, destination, createIfTemp);
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            this.destinations.put(destination, answer);
            return answer;
        }
    }

    @Override
    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        if (this.destinations.containsKey(destination)) {
            switch (destination.getDestinationType()) {
                case 1: {
                    this.queueRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 2: {
                    this.topicRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 5: {
                    this.tempQueueRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 6: {
                    this.tempTopicRegion.removeDestination(context, destination, timeout);
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            this.destinations.remove(destination);
        }
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.addDestination(context, info.getDestination(), true);
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.removeDestination(context, info.getDestination(), info.getTimeout());
    }

    @Override
    public BESMQDestination[] getDestinations() throws Exception {
        ArrayList<BESMQDestination> l = new ArrayList<BESMQDestination>(this.getDestinationMap().keySet());
        BESMQDestination[] rc = new BESMQDestination[l.size()];
        l.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        BESMQDestination destination = info.getDestination();
        if (destination != null) {
            this.inactiveDestinationsPurgeLock.readLock().lock();
            try {
                context.getBroker().addDestination(context, destination, this.isAllowTempAutoCreationOnSend());
                switch (destination.getDestinationType()) {
                    case 1: {
                        this.queueRegion.addProducer(context, info);
                        break;
                    }
                    case 2: {
                        this.topicRegion.addProducer(context, info);
                        break;
                    }
                    case 5: {
                        this.tempQueueRegion.addProducer(context, info);
                        break;
                    }
                    case 6: {
                        this.tempTopicRegion.addProducer(context, info);
                    }
                }
                Object var5_4 = null;
                this.inactiveDestinationsPurgeLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.inactiveDestinationsPurgeLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        BESMQDestination destination = info.getDestination();
        if (destination != null) {
            this.inactiveDestinationsPurgeLock.readLock().lock();
            try {
                switch (destination.getDestinationType()) {
                    case 1: {
                        this.queueRegion.removeProducer(context, info);
                        break;
                    }
                    case 2: {
                        this.topicRegion.removeProducer(context, info);
                        break;
                    }
                    case 5: {
                        this.tempQueueRegion.removeProducer(context, info);
                        break;
                    }
                    case 6: {
                        this.tempTopicRegion.removeProducer(context, info);
                    }
                }
                Object var5_4 = null;
                this.inactiveDestinationsPurgeLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.inactiveDestinationsPurgeLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Subscription subscription;
        block11: {
            Subscription subscription2;
            block10: {
                Subscription subscription3;
                BESMQDestination destination = info.getDestination();
                if (this.destinationInterceptor != null) {
                    this.destinationInterceptor.create(this, context, destination);
                }
                this.inactiveDestinationsPurgeLock.readLock().lock();
                try {
                    switch (destination.getDestinationType()) {
                        case 1: {
                            Subscription subscription4 = this.queueRegion.addConsumer(context, info);
                            Object var6_8 = null;
                            this.inactiveDestinationsPurgeLock.readLock().unlock();
                            return subscription4;
                        }
                        case 2: {
                            subscription3 = this.topicRegion.addConsumer(context, info);
                            break;
                        }
                        case 5: {
                            subscription2 = this.tempQueueRegion.addConsumer(context, info);
                            break block10;
                        }
                        case 6: {
                            subscription = this.tempTopicRegion.addConsumer(context, info);
                            break block11;
                        }
                        default: {
                            throw this.createUnknownDestinationTypeException(destination);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    this.inactiveDestinationsPurgeLock.readLock().unlock();
                    throw throwable;
                }
                Object var6_9 = null;
                this.inactiveDestinationsPurgeLock.readLock().unlock();
                return subscription3;
            }
            Object var6_10 = null;
            this.inactiveDestinationsPurgeLock.readLock().unlock();
            return subscription2;
        }
        Object var6_11 = null;
        this.inactiveDestinationsPurgeLock.readLock().unlock();
        return subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        BESMQDestination destination = info.getDestination();
        this.inactiveDestinationsPurgeLock.readLock().lock();
        try {
            switch (destination.getDestinationType()) {
                case 1: {
                    this.queueRegion.removeConsumer(context, info);
                    break;
                }
                case 2: {
                    this.topicRegion.removeConsumer(context, info);
                    break;
                }
                case 5: {
                    this.tempQueueRegion.removeConsumer(context, info);
                    break;
                }
                case 6: {
                    this.tempTopicRegion.removeConsumer(context, info);
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            Object var5_4 = null;
            this.inactiveDestinationsPurgeLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.inactiveDestinationsPurgeLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        this.inactiveDestinationsPurgeLock.readLock().lock();
        try {
            this.topicRegion.removeSubscription(context, info);
            Object var4_3 = null;
            this.inactiveDestinationsPurgeLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.inactiveDestinationsPurgeLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        message.setBrokerInTime(System.currentTimeMillis());
        if (producerExchange.isMutable() || producerExchange.getRegion() == null || producerExchange.getRegionDestination() != null && producerExchange.getRegionDestination().isDisposed()) {
            Region region;
            BESMQDestination destination = message.getDestination();
            producerExchange.getConnectionContext().getBroker().addDestination(producerExchange.getConnectionContext(), destination, this.isAllowTempAutoCreationOnSend());
            switch (destination.getDestinationType()) {
                case 1: {
                    region = this.queueRegion;
                    break;
                }
                case 2: {
                    region = this.topicRegion;
                    break;
                }
                case 5: {
                    region = this.tempQueueRegion;
                    break;
                }
                case 6: {
                    region = this.tempTopicRegion;
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            producerExchange.setRegion(region);
            producerExchange.setRegionDestination(null);
        }
        producerExchange.getRegion().send(producerExchange, message);
    }

    @Override
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        if (consumerExchange.isWildcard() || consumerExchange.getRegion() == null) {
            Region region;
            BESMQDestination destination = ack.getDestination();
            switch (destination.getDestinationType()) {
                case 1: {
                    region = this.queueRegion;
                    break;
                }
                case 2: {
                    region = this.topicRegion;
                    break;
                }
                case 5: {
                    region = this.tempQueueRegion;
                    break;
                }
                case 6: {
                    region = this.tempTopicRegion;
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            consumerExchange.setRegion(region);
        }
        consumerExchange.getRegion().acknowledge(consumerExchange, ack);
    }

    @Override
    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        BESMQDestination destination = pull.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion.messagePull(context, pull);
            }
            case 2: {
                return this.topicRegion.messagePull(context, pull);
            }
            case 5: {
                return this.tempQueueRegion.messagePull(context, pull);
            }
            case 6: {
                return this.tempTopicRegion.messagePull(context, pull);
            }
        }
        throw this.createUnknownDestinationTypeException(destination);
    }

    @Override
    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void gc() {
        this.queueRegion.gc();
        this.topicRegion.gc();
    }

    @Override
    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(BROKER_ID_GENERATOR.generateId());
        }
        return this.brokerId;
    }

    public void setBrokerId(BrokerId brokerId) {
        this.brokerId = brokerId;
    }

    @Override
    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddressUtil.getLocalHostName().toLowerCase(Locale.ENGLISH);
            }
            catch (Exception e) {
                this.brokerName = "localhost";
            }
        }
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    protected JMSException createUnknownDestinationTypeException(BESMQDestination destination) {
        return new JMSException("Unknown destination type: " + destination.getDestinationType());
    }

    @Override
    public synchronized void addBroker(Connection connection, BrokerInfo info) {
        BrokerInfo existing = this.brokerInfos.get(info.getBrokerId());
        if (existing == null) {
            existing = info.copy();
            existing.setPeerBrokerInfos(null);
            this.brokerInfos.put(info.getBrokerId(), existing);
        }
        existing.incrementRefCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getBrokerName() + " addBroker:" + info.getBrokerName() + " brokerInfo size : " + this.brokerInfos.size());
        }
        this.addBrokerInClusterUpdate(info);
    }

    @Override
    public synchronized void removeBroker(Connection connection, BrokerInfo info) {
        if (info != null) {
            BrokerInfo existing = this.brokerInfos.get(info.getBrokerId());
            if (existing != null && existing.decrementRefCount() == 0) {
                this.brokerInfos.remove(info.getBrokerId());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getBrokerName() + " removeBroker:" + info.getBrokerName() + " brokerInfo size : " + this.brokerInfos.size());
            }
            this.removeBrokerInClusterUpdate(info);
        }
    }

    @Override
    public synchronized BrokerInfo[] getPeerBrokerInfos() {
        BrokerInfo[] result = new BrokerInfo[this.brokerInfos.size()];
        result = this.brokerInfos.values().toArray(result);
        return result;
    }

    @Override
    public void preProcessDispatch(MessageDispatch messageDispatch) {
        Message message = messageDispatch.getMessage();
        if (message != null) {
            long endTime = System.currentTimeMillis();
            message.setBrokerOutTime(endTime);
            if (this.getBrokerService().isEnableStatistics()) {
                long totalTime = endTime - message.getBrokerInTime();
                message.getRegionDestination().getDestinationStatistics().getProcessTime().addTime(totalTime);
            }
        }
    }

    @Override
    public void postProcessDispatch(MessageDispatch messageDispatch) {
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        BESMQDestination destination = messageDispatchNotification.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 2: {
                this.topicRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 5: {
                this.tempQueueRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 6: {
                this.tempTopicRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public boolean isSlaveBroker() {
        return this.brokerService.isSlave();
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public Set<BESMQDestination> getDurableDestinations() {
        return this.destinationFactory.getDestinations();
    }

    protected void doStop(ServiceStopper ss) {
        ss.stop(this.queueRegion);
        ss.stop(this.topicRegion);
        ss.stop(this.tempQueueRegion);
        ss.stop(this.tempTopicRegion);
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
        ((TopicRegion)this.topicRegion).setKeepDurableSubsActive(keepDurableSubsActive);
    }

    public DestinationInterceptor getDestinationInterceptor() {
        return this.destinationInterceptor;
    }

    @Override
    public ConnectionContext getAdminConnectionContext() {
        return this.adminConnectionContext;
    }

    @Override
    public void setAdminConnectionContext(ConnectionContext adminConnectionContext) {
        this.adminConnectionContext = adminConnectionContext;
    }

    public Map<ConnectionId, ConnectionState> getConnectionStates() {
        return this.connectionStates;
    }

    @Override
    public PListStore getTempDataStore() {
        return this.brokerService.getTempDataStore();
    }

    @Override
    public URI getVmConnectorURI() {
        return this.brokerService.getVmConnectorURI();
    }

    @Override
    public void brokerServiceStarted() {
    }

    @Override
    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired(MessageReference messageReference) {
        boolean expired = false;
        if (messageReference.isExpired()) {
            try {
                Message message;
                Message message2 = message = messageReference.getMessage();
                synchronized (message2) {
                    expired = this.stampAsExpired(message);
                }
            }
            catch (IOException e) {
                LOG.warn("Unexpected exception on message expiry determination for: " + messageReference, e);
            }
        }
        return expired;
    }

    private boolean stampAsExpired(Message message) throws IOException {
        boolean stamped = false;
        if (message.getProperty(ORIGINAL_EXPIRATION) == null) {
            long expiration = message.getExpiration();
            message.setProperty(ORIGINAL_EXPIRATION, new Long(expiration));
            stamped = true;
        }
        return stamped;
    }

    @Override
    public void messageExpired(ConnectionContext context, MessageReference node, Subscription subscription) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message expired " + node);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String date = dateFormat.format(new Date(node.getExpiration()));
        this.getRoot().sendToDeadLetterQueue(context, node, subscription, new Throwable("Message expired at " + date));
    }

    @Override
    public boolean sendToDeadLetterQueue(ConnectionContext context, MessageReference node, Subscription subscription, Throwable poisonCause) {
        try {
            Message message;
            if (node != null && (message = node.getMessage()) != null && node.getRegionDestination() != null) {
                DeadLetterStrategy deadLetterStrategy = node.getRegionDestination().getDeadLetterStrategy();
                if (deadLetterStrategy != null) {
                    if (deadLetterStrategy.isSendToDeadLetterQueue(message)) {
                        message = message.copy();
                        this.stampAsExpired(message);
                        message.setExpiration(0L);
                        if (!message.isPersistent()) {
                            message.setPersistent(true);
                            message.setProperty("originalDeliveryMode", "NON_PERSISTENT");
                        }
                        if (poisonCause != null) {
                            message.setProperty("dlqDeliveryFailureCause", poisonCause.toString());
                        }
                        BESMQDestination deadLetterDestination = deadLetterStrategy.getDeadLetterQueueFor(message, subscription);
                        if (context.getBroker() == null) {
                            context.setBroker(this.getRoot());
                        }
                        BrokerSupport.resendNoCopy(context, message, deadLetterDestination);
                        return true;
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Dead Letter message with no DLQ strategy in place, message id: " + message.getMessageId() + ", destination: " + message.getDestination());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Caught an exception sending to DLQ: " + node, e);
        }
        return false;
    }

    @Override
    public Broker getRoot() {
        try {
            return this.getBrokerService().getBroker();
        }
        catch (Exception e) {
            LOG.error("Trying to get Root Broker " + e);
            throw new RuntimeException("The broker from the BrokerService should not throw an exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBrokerSequenceId() {
        LongSequenceGenerator longSequenceGenerator = this.sequenceGenerator;
        synchronized (longSequenceGenerator) {
            return this.sequenceGenerator.getNextSequenceId();
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        BESMQDestination destination = control.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.processConsumerControl(consumerExchange, control);
                break;
            }
            case 2: {
                this.topicRegion.processConsumerControl(consumerExchange, control);
                break;
            }
            case 5: {
                this.tempQueueRegion.processConsumerControl(consumerExchange, control);
                break;
            }
            case 6: {
                this.tempTopicRegion.processConsumerControl(consumerExchange, control);
                break;
            }
            default: {
                LOG.warn("Unmatched destination: " + destination + ", in consumerControl: " + control);
            }
        }
    }

    protected void addBrokerInClusterUpdate(BrokerInfo info) {
        List<TransportConnector> connectors = this.brokerService.getTransportConnectors();
        for (TransportConnector connector : connectors) {
            if (!connector.isUpdateClusterClients()) continue;
            connector.addPeerBroker(info);
            connector.updateClientClusterInfo();
        }
    }

    protected void removeBrokerInClusterUpdate(BrokerInfo info) {
        List<TransportConnector> connectors = this.brokerService.getTransportConnectors();
        for (TransportConnector connector : connectors) {
            if (!connector.isUpdateClusterClients() || !connector.isUpdateClusterClientsOnRemove()) continue;
            connector.removePeerBroker(info);
            connector.updateClientClusterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeInactiveDestinations() {
        this.inactiveDestinationsPurgeLock.writeLock().lock();
        try {
            ArrayList<Destination> list = new ArrayList<Destination>();
            Map<BESMQDestination, Destination> map = this.getDestinationMap();
            if (this.isAllowTempAutoCreationOnSend()) {
                map.putAll(this.tempQueueRegion.getDestinationMap());
                map.putAll(this.tempTopicRegion.getDestinationMap());
            }
            long maxPurgedDests = this.brokerService.getMaxPurgedDestinationsPerSweep();
            long timeStamp = System.currentTimeMillis();
            for (Destination d : map.values()) {
                d.markForGC(timeStamp);
                if (!d.canGC()) continue;
                list.add(d);
                if (maxPurgedDests <= 0L || (long)list.size() != maxPurgedDests) continue;
                break;
            }
            if (!list.isEmpty()) {
                ConnectionContext context = BrokerSupport.getConnectionContext(this);
                context.setBroker(this);
                for (Destination dest : list) {
                    Logger log = LOG;
                    if (dest instanceof BaseDestination) {
                        log = ((BaseDestination)dest).getLog();
                    }
                    log.info(dest.getName() + " Inactive for longer than " + dest.getInactiveTimoutBeforeGC() + " ms - removing ...");
                    try {
                        this.getRoot().removeDestination(context, dest.getBESMQDestination(), this.isAllowTempAutoCreationOnSend() ? 1L : 0L);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to remove inactive destination " + dest, e);
                    }
                }
            }
            Object var13_10 = null;
            this.inactiveDestinationsPurgeLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            this.inactiveDestinationsPurgeLock.writeLock().unlock();
            throw throwable;
        }
    }

    public boolean isAllowTempAutoCreationOnSend() {
        return this.allowTempAutoCreationOnSend;
    }

    public void setAllowTempAutoCreationOnSend(boolean allowTempAutoCreationOnSend) {
        this.allowTempAutoCreationOnSend = allowTempAutoCreationOnSend;
    }
}

