/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.Queue;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.cursors.VMPendingMessageCursor;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQTempDestination;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.MessageStore;
import com.bes.mq.thread.TaskRunnerFactory;
import java.io.IOException;

public class TempQueue
extends Queue {
    private static final Logger LOG = LoggerFactory.getLogger(TempQueue.class);
    private final BESMQTempDestination tempDest;

    public TempQueue(BrokerService brokerService, BESMQDestination destination, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, destination, store, parentStats, taskFactory);
        this.tempDest = (BESMQTempDestination)destination;
    }

    public void initialize() throws Exception {
        this.messages = new VMPendingMessageCursor(false);
        this.messages.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
        this.systemUsage = this.brokerService.getSystemUsage();
        this.memoryUsage.setParent(this.systemUsage.getMemoryUsage());
        this.taskRunner = this.taskFactory.createTaskRunner(this, "TempQueue:  " + this.destination.getPhysicalName());
    }

    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        if (!(context.isFaultTolerant() || context.isNetworkConnection() || this.tempDest.getConnectionId().equals(sub.getConsumerInfo().getConsumerId().getConnectionId()))) {
            this.tempDest.setConnectionId(sub.getConsumerInfo().getConsumerId().getConnectionId());
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Changed ownership of " + this + " to " + this.tempDest.getConnectionId());
            }
        }
        super.addSubscription(context, sub);
    }

    public void dispose(ConnectionContext context) throws IOException {
        try {
            this.purge();
        }
        catch (Exception e) {
            LOG.warn("Caught an exception purging Queue: " + this.destination);
        }
        super.dispose(context);
    }
}

