/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.AbstractTempRegion;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFactory;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.Queue;
import com.bes.mq.broker.region.QueueBrowserSubscription;
import com.bes.mq.broker.region.QueueSubscription;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.TempQueue;
import com.bes.mq.broker.region.policy.PolicyEntry;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.MessageDispatchNotification;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.usage.SystemUsage;
import javax.jms.JMSException;

public class TempQueueRegion
extends AbstractTempRegion {
    private static final Logger LOG = LoggerFactory.getLogger(TempQueueRegion.class);
    private final BrokerService brokerService;

    public TempQueueRegion(RegionBroker broker, BrokerService brokerService, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
        this.brokerService = brokerService;
    }

    protected Destination doCreateDestination(ConnectionContext context, BESMQDestination destination) throws Exception {
        TempQueue result = new TempQueue(this.brokerService, destination, null, this.destinationStatistics, this.taskRunnerFactory);
        this.brokerService.getDestinationPolicy();
        this.configureQueue(result, destination);
        result.initialize();
        return result;
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        if (info.isBrowser()) {
            return new QueueBrowserSubscription(this.broker, this.usageManager, context, info);
        }
        return new QueueSubscription(this.broker, this.usageManager, context, info);
    }

    public String toString() {
        return "TempQueueRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.usageManager.getMemoryUsage().getPercentUsage() + "%";
    }

    public void removeDestination(ConnectionContext context, BESMQDestination destination, long timeout) throws Exception {
        if (timeout == 0L) {
            timeout = 1L;
        }
        super.removeDestination(context, destination, timeout);
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        this.processDispatchNotificationViaDestination(messageDispatchNotification);
    }

    protected void configureQueue(Queue queue, BESMQDestination destination) {
        PolicyEntry entry;
        if (this.broker == null) {
            throw new IllegalStateException("Broker property is not set");
        }
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure((Broker)this.broker, queue);
        }
    }
}

