/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.ProducerBrokerExchange;
import com.bes.mq.broker.region.BaseDestination;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.DurableTopicSubscription;
import com.bes.mq.broker.region.LockOwner;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.policy.DispatchPolicy;
import com.bes.mq.broker.region.policy.LastImageSubscriptionRecoveryPolicy;
import com.bes.mq.broker.region.policy.RetainedMessageSubscriptionRecoveryPolicy;
import com.bes.mq.broker.region.policy.SimpleDispatchPolicy;
import com.bes.mq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.bes.mq.broker.util.InsertionCountList;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerAck;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SubscriptionInfo;
import com.bes.mq.filter.MessageEvaluationContext;
import com.bes.mq.filter.NonCachedMessageEvaluationContext;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.MessageRecoveryListener;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.thread.Task;
import com.bes.mq.thread.TaskRunner;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.transaction.Synchronization;
import com.bes.mq.util.SubscriptionKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.ResourceAllocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topic
extends BaseDestination
implements Task {
    protected static final Logger LOG = LoggerFactory.getLogger(Topic.class);
    private final TopicMessageStore topicStore;
    protected final CopyOnWriteArrayList<Subscription> consumers = new CopyOnWriteArrayList();
    private final ReentrantReadWriteLock dispatchLock = new ReentrantReadWriteLock();
    private DispatchPolicy dispatchPolicy = new SimpleDispatchPolicy();
    private SubscriptionRecoveryPolicy subscriptionRecoveryPolicy;
    private final ConcurrentHashMap<SubscriptionKey, DurableTopicSubscription> durableSubcribers = new ConcurrentHashMap();
    private final TaskRunner taskRunner;
    private final LinkedList<WaitingForSpaceMessage> messagesWaitingForSpace = new LinkedList();
    private final Runnable sendMessagesWaitingForSpaceTask = new Runnable(){

        public void run() {
            try {
                Topic.this.taskRunner.wakeup();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    private final Object iteratingMutex = new Object();
    private final AtomicLong pendingWakeups = new AtomicLong();
    private final Runnable expireMessagesTask = new Runnable(){

        public void run() {
            InsertionCountList browsedMessages = new InsertionCountList();
            Topic.this.doBrowse(browsedMessages, Topic.this.getMaxExpirePageSize());
            if (!Topic.this.consumers.isEmpty()) {
                Topic.this.asyncWakeup();
            }
        }
    };

    public Topic(BrokerService brokerService, BESMQDestination destination, TopicMessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, store, destination, parentStats);
        this.topicStore = store;
        if (NotificationSupport.isMasterBrokerNotificationTopic(destination)) {
            this.subscriptionRecoveryPolicy = new LastImageSubscriptionRecoveryPolicy();
            this.setAlwaysRetroactive(true);
        } else {
            this.subscriptionRecoveryPolicy = new RetainedMessageSubscriptionRecoveryPolicy(null);
        }
        this.taskRunner = taskFactory.createTaskRunner(this, "Topic  " + destination.getPhysicalName());
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        if (this.store != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Subscription> getConsumers() {
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
        synchronized (copyOnWriteArrayList) {
            return new ArrayList<Subscription>(this.consumers);
        }
    }

    public boolean lock(MessageReference node, LockOwner sub) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        if (!sub.getConsumerInfo().isDurable()) {
            if (sub.getConsumerInfo().isRetroactive() || this.isAlwaysRetroactive()) {
                this.dispatchLock.writeLock().lock();
                try {
                    boolean applyRecovery = false;
                    CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
                    synchronized (copyOnWriteArrayList) {
                        if (!this.consumers.contains(sub)) {
                            sub.add(context, this);
                            this.consumers.add(sub);
                            applyRecovery = true;
                            super.addSubscription(context, sub);
                        }
                    }
                    if (!applyRecovery) return;
                    this.subscriptionRecoveryPolicy.recover(context, this, sub);
                    return;
                }
                finally {
                    this.dispatchLock.writeLock().unlock();
                }
            }
            CopyOnWriteArrayList<Subscription> applyRecovery = this.consumers;
            synchronized (applyRecovery) {
                if (this.consumers.contains(sub)) return;
                sub.add(context, this);
                this.consumers.add(sub);
                super.addSubscription(context, sub);
                return;
            }
        }
        DurableTopicSubscription dsub = (DurableTopicSubscription)sub;
        super.addSubscription(context, sub);
        sub.add(context, this);
        if (dsub.isActive()) {
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                boolean hasSubscription = false;
                if (this.consumers.size() == 0) {
                    hasSubscription = false;
                } else {
                    for (Subscription currentSub : this.consumers) {
                        DurableTopicSubscription dcurrentSub;
                        if (!currentSub.getConsumerInfo().isDurable() || !(dcurrentSub = (DurableTopicSubscription)currentSub).getSubscriptionKey().equals(dsub.getSubscriptionKey())) continue;
                        hasSubscription = true;
                        break;
                    }
                }
                if (!hasSubscription) {
                    this.consumers.add(sub);
                }
            }
        }
        this.durableSubcribers.put(dsub.getSubscriptionKey(), dsub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, Subscription sub, long lastDeliveredSequenceId) throws Exception {
        if (!sub.getConsumerInfo().isDurable()) {
            super.removeSubscription(context, sub, lastDeliveredSequenceId);
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                this.consumers.remove(sub);
            }
        }
        sub.remove(context, this);
    }

    public void deleteSubscription(ConnectionContext context, SubscriptionKey key) throws Exception {
        if (this.topicStore != null) {
            this.topicStore.deleteSubscription(key.clientId, key.subscriptionName);
            DurableTopicSubscription removed = this.durableSubcribers.remove(key);
            if (removed != null) {
                this.destinationStatistics.getConsumers().decrement();
                removed.setKeepDurableSubsActive(false);
                removed.deactivate(false);
                this.consumers.remove(removed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(ConnectionContext context, final DurableTopicSubscription subscription) throws Exception {
        this.dispatchLock.writeLock().lock();
        try {
            Object s1;
            if (this.topicStore == null) {
                return;
            }
            String clientId = subscription.getSubscriptionKey().getClientId();
            String subscriptionName = subscription.getSubscriptionKey().getSubscriptionName();
            String selector = subscription.getConsumerInfo().getSelector();
            SubscriptionInfo info = this.topicStore.lookupSubscription(clientId, subscriptionName);
            if (info != null) {
                s1 = info.getSelector();
                if (s1 == null ^ selector == null || s1 != null && !((String)s1).equals(selector)) {
                    this.topicStore.deleteSubscription(clientId, subscriptionName);
                    info = null;
                    CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
                    synchronized (copyOnWriteArrayList) {
                        this.consumers.remove(subscription);
                    }
                }
                CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
                synchronized (copyOnWriteArrayList) {
                    if (!this.consumers.contains(subscription)) {
                        this.consumers.add(subscription);
                    }
                }
            }
            if (info == null) {
                info = new SubscriptionInfo();
                info.setClientId(clientId);
                info.setSelector(selector);
                info.setSubscriptionName(subscriptionName);
                info.setDestination(this.getBESMQDestination());
                info.setSubscribedDestination(subscription.getConsumerInfo().getDestination());
                s1 = this.consumers;
                synchronized (s1) {
                    this.consumers.add(subscription);
                    this.topicStore.addSubsciption(info, subscription.getConsumerInfo().isRetroactive());
                }
            }
            final NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
            msgContext.setDestination(this.destination);
            if (subscription.isRecoveryRequired()) {
                this.topicStore.recoverSubscription(clientId, subscriptionName, new MessageRecoveryListener(){

                    public boolean recoverMessage(Message message) throws Exception {
                        message.setRegionDestination(Topic.this);
                        try {
                            msgContext.setMessageReference(message);
                            if (subscription.matches(message, msgContext)) {
                                subscription.add(message);
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Failed to recover this message " + message);
                        }
                        return true;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        throw new RuntimeException("Should not be called.");
                    }

                    public boolean hasSpace() {
                        return true;
                    }

                    public boolean isDuplicate(MessageId id) {
                        return false;
                    }
                });
            }
        }
        finally {
            this.dispatchLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(ConnectionContext context, DurableTopicSubscription sub) throws Exception {
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
        synchronized (copyOnWriteArrayList) {
            this.consumers.remove(sub);
        }
        List<MessageReference> removed = sub.remove(context, this);
        for (MessageReference mr : removed) {
            mr.decrementReferenceCount();
        }
    }

    public void recoverRetroactiveMessages(ConnectionContext context, Subscription subscription) throws Exception {
        if (subscription.getConsumerInfo().isRetroactive()) {
            this.subscriptionRecoveryPolicy.recover(context, this, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(final ProducerBrokerExchange producerExchange, Message message) throws Exception {
        boolean sendProducerAck;
        final ConnectionContext context = producerExchange.getConnectionContext();
        message.setRegionDestination(this);
        final ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
        boolean bl = sendProducerAck = !message.isResponseRequired() && producerInfo.getWindowSize() > 0 && !context.isInRecoveryMode();
        if (message.isExpired()) {
            this.broker.messageExpired(context, message, null);
            this.getDestinationStatistics().getExpired().increment();
            if (sendProducerAck) {
                ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                context.getConnection().dispatchAsync(ack);
            }
            return;
        }
        if (this.memoryUsage.isFull()) {
            this.isFull(context, this.memoryUsage);
            this.fastProducer(context, producerInfo);
            if (this.isProducerFlowControl() && context.isProducerFlowControl()) {
                if (this.warnOnProducerFlowControl) {
                    this.warnOnProducerFlowControl = false;
                    LOG.info(this.memoryUsage + ", Usage Manager memory limit reached for " + this.getBESMQDestination().getQualifiedName() + ". Producers will be throttled to the rate at which messages are removed from this destination to prevent flooding it.");
                }
                if (!context.isNetworkConnection() && this.systemUsage.isSendFailIfNoSpace()) {
                    throw new ResourceAllocationException("Usage Manager memory limit (" + this.memoryUsage.getLimit() + ") reached. Rejecting send for producer (" + message.getProducerId() + ") to prevent flooding " + this.getBESMQDestination().getQualifiedName());
                }
                if (producerInfo.getWindowSize() > 0 || message.isResponseRequired()) {
                    LinkedList<WaitingForSpaceMessage> ack = this.messagesWaitingForSpace;
                    synchronized (ack) {
                        this.messagesWaitingForSpace.add(new WaitingForSpaceMessage(message){

                            public void run() {
                                block6: {
                                    try {
                                        if (this.message.isExpired()) {
                                            Topic.this.broker.messageExpired(context, this.message, null);
                                            Topic.this.getDestinationStatistics().getExpired().increment();
                                        } else {
                                            Topic.this.doMessageSend(producerExchange, this.message);
                                        }
                                        if (sendProducerAck) {
                                            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), this.message.getSize());
                                            context.getConnection().dispatchAsync(ack);
                                        } else {
                                            Response response = new Response();
                                            response.setCorrelationId(this.message.getCommandId());
                                            context.getConnection().dispatchAsync(response);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (sendProducerAck || context.isInRecoveryMode()) break block6;
                                        ExceptionResponse response = new ExceptionResponse(e);
                                        response.setCorrelationId(this.message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                }
                            }
                        });
                        this.registerCallbackForNotFullNotification();
                        context.setDontSendReponse(true);
                        return;
                    }
                }
                if (this.memoryUsage.isFull()) {
                    if (context.isInTransaction()) {
                        int count = 0;
                        while (!this.memoryUsage.waitForSpace(1000L)) {
                            if (context.getStopping().get()) {
                                throw new IOException("Connection closed, send aborted.");
                            }
                            if (count <= 2 || !context.isInTransaction()) continue;
                            count = 0;
                            int size = context.getTransaction().size();
                            LOG.warn("Waiting for space to send  transacted message - transaction elements = " + size + " need more space to commit. Message = " + message);
                        }
                    } else {
                        this.waitForSpace(context, this.memoryUsage, "Usage Manager Memory Usage limit reached. Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getBESMQDestination().getQualifiedName());
                    }
                }
                if (message.isExpired()) {
                    this.getDestinationStatistics().getExpired().increment();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Expired message: " + message);
                    }
                    return;
                }
            }
        }
        this.doMessageSend(producerExchange, message);
        this.messageDelivered(context, message);
        if (sendProducerAck) {
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
            context.getConnection().dispatchAsync(ack);
        }
    }

    synchronized void doMessageSend(ProducerBrokerExchange producerExchange, final Message message) throws IOException, Exception {
        final ConnectionContext context = producerExchange.getConnectionContext();
        message.getMessageId().setBrokerSequenceId(this.getDestinationSequenceId());
        Future<Object> result = null;
        if (this.topicStore != null && message.isPersistent() && !this.canOptimizeOutPersistence()) {
            if (this.systemUsage.getStoreUsage().isFull(this.getStoreUsageHighWaterMark())) {
                String logMessage = "Persistent store is Full, " + this.getStoreUsageHighWaterMark() + "% of " + this.systemUsage.getStoreUsage().getLimit() + ". Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getBESMQDestination().getQualifiedName();
                if (!context.isNetworkConnection() && this.systemUsage.isSendFailIfNoSpace()) {
                    throw new ResourceAllocationException(logMessage);
                }
                this.waitForSpace(context, this.systemUsage.getStoreUsage(), this.getStoreUsageHighWaterMark(), logMessage);
            }
            result = this.topicStore.asyncAddTopicMessage(context, message, this.isOptimizeStorage());
        }
        if (context.isInTransaction()) {
            message.incrementReferenceCount();
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    if (Topic.this.broker.isExpired(message)) {
                        Topic.this.getDestinationStatistics().getExpired().increment();
                        Topic.this.broker.messageExpired(context, message, null);
                        message.decrementReferenceCount();
                        return;
                    }
                    try {
                        Topic.this.dispatch(context, message);
                    }
                    finally {
                        message.decrementReferenceCount();
                    }
                }

                public void afterRollback() throws Exception {
                    message.decrementReferenceCount();
                }
            });
        } else {
            this.dispatch(context, message);
        }
        if (result != null && this.isWaitAsyncAddMessageComplete() && !result.isCancelled()) {
            try {
                result.get();
            }
            catch (CancellationException e) {
                // empty catch block
            }
        }
    }

    private boolean canOptimizeOutPersistence() {
        return this.durableSubcribers.size() == 0;
    }

    public String toString() {
        return "Topic: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size();
    }

    @Override
    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.topicStore != null && node.isPersistent()) {
            DurableTopicSubscription dsub = (DurableTopicSubscription)sub;
            SubscriptionKey key = dsub.getSubscriptionKey();
            this.topicStore.acknowledge(context, key.getClientId(), key.getSubscriptionName(), node.getMessageId(), this.convertToNonRangedAck(ack, node));
        }
        this.messageConsumed(context, node);
    }

    @Override
    public void gc() {
    }

    public Message loadMessage(MessageId messageId) throws IOException {
        return this.topicStore != null ? this.topicStore.getMessage(messageId) : null;
    }

    @Override
    public void start() throws Exception {
        this.subscriptionRecoveryPolicy.start();
        if (this.memoryUsage != null) {
            this.memoryUsage.start();
        }
        if (this.getExpireMessagesPeriod() > 0L) {
            this.scheduler.schedualPeriodically(this.expireMessagesTask, this.getExpireMessagesPeriod());
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
        this.subscriptionRecoveryPolicy.stop();
        if (this.memoryUsage != null) {
            this.memoryUsage.stop();
        }
        if (this.topicStore != null) {
            this.topicStore.stop();
        }
        this.scheduler.cancel(this.expireMessagesTask);
    }

    private void dispatchSubscriptionPendingMessage() {
        for (Subscription sub : this.consumers) {
            try {
                sub.dispatchPending();
            }
            catch (IOException e) {
                LOG.warn("Error occurred while dispatching pending messages of " + sub + ", caused by: ", e);
            }
        }
    }

    @Override
    public Message[] browse() {
        ArrayList<Message> result = new ArrayList<Message>();
        this.doBrowse(result, this.getMaxBrowsePageSize());
        return result.toArray(new Message[result.size()]);
    }

    private void doBrowse(final List<Message> browseList, final int max) {
        try {
            if (this.topicStore != null) {
                final ArrayList toExpire = new ArrayList();
                this.topicStore.recover(new MessageRecoveryListener(){

                    public boolean recoverMessage(Message message) throws Exception {
                        message.setRegionDestination(Topic.this);
                        if (message.isExpired()) {
                            toExpire.add(message);
                        }
                        browseList.add(message);
                        return true;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        return true;
                    }

                    public boolean hasSpace() {
                        return browseList.size() < max && Topic.this.getMemoryUsage() != null && !Topic.this.getMemoryUsage().isFull();
                    }

                    public boolean isDuplicate(MessageId id) {
                        return false;
                    }
                });
                ConnectionContext connectionContext = this.createConnectionContext();
                for (Message message : toExpire) {
                    for (DurableTopicSubscription sub : this.durableSubcribers.values()) {
                        if (sub.isActive()) continue;
                        this.messageExpired(connectionContext, sub, message);
                    }
                }
                Message[] msgs = this.subscriptionRecoveryPolicy.browse(this.getBESMQDestination());
                if (msgs != null) {
                    for (int i = 0; i < msgs.length && browseList.size() < max; ++i) {
                        browseList.add(msgs[i]);
                    }
                }
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to browse Topic: " + this.getBESMQDestination().getPhysicalName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean iterate() {
        Object object = this.iteratingMutex;
        synchronized (object) {
            LinkedList<WaitingForSpaceMessage> linkedList = this.messagesWaitingForSpace;
            synchronized (linkedList) {
                while (!this.messagesWaitingForSpace.isEmpty() && !this.memoryUsage.isFull()) {
                    WaitingForSpaceMessage op = this.messagesWaitingForSpace.getFirst();
                    if (op.getMessage().isPersistent() && this.topicStore != null && this.systemUsage.getStoreUsage().isFull(this.getStoreUsageHighWaterMark()) || !op.getMessage().isPersistent() && this.systemUsage != null && this.systemUsage.getTempUsage().isFull()) continue;
                    op.run();
                    this.messagesWaitingForSpace.removeFirst();
                }
                if (!this.messagesWaitingForSpace.isEmpty()) {
                    this.registerCallbackForNotFullNotification();
                }
            }
            this.dispatchSubscriptionPendingMessage();
            if (this.pendingWakeups.get() > 0L) {
                this.pendingWakeups.decrementAndGet();
            }
            return this.pendingWakeups.get() > 0L;
        }
    }

    private void registerCallbackForNotFullNotification() {
        if (!this.memoryUsage.notifyCallbackWhenNotFull(this.sendMessagesWaitingForSpaceTask)) {
            this.sendMessagesWaitingForSpaceTask.run();
        }
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public SubscriptionRecoveryPolicy getSubscriptionRecoveryPolicy() {
        return this.subscriptionRecoveryPolicy;
    }

    public void setSubscriptionRecoveryPolicy(SubscriptionRecoveryPolicy subscriptionRecoveryPolicy) {
        this.subscriptionRecoveryPolicy = subscriptionRecoveryPolicy;
    }

    @Override
    public final void wakeup() {
    }

    public void asyncWakeup() {
        try {
            this.pendingWakeups.incrementAndGet();
            this.taskRunner.wakeup();
        }
        catch (InterruptedException e) {
            LOG.warn("Async task runner failed to wakeup ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispatch(ConnectionContext context, Message message) throws Exception {
        this.destinationStatistics.getEnqueues().increment();
        MessageEvaluationContext msgContext = null;
        this.dispatchLock.readLock().lock();
        try {
            if (!this.subscriptionRecoveryPolicy.add(context, message)) {
                return;
            }
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                if (this.consumers.isEmpty()) {
                    this.onMessageWithNoConsumers(context, message);
                    return;
                }
            }
            msgContext = context.getMessageEvaluationContext();
            msgContext.setDestination(this.destination);
            msgContext.setMessageReference(message);
            if (this.dispatchPolicy.dispatch(message, msgContext, this.consumers)) return;
            this.onMessageWithNoConsumers(context, message);
            return;
        }
        finally {
            this.dispatchLock.readLock().unlock();
            if (msgContext != null) {
                msgContext.clear();
            }
        }
    }

    @Override
    public void messageExpired(ConnectionContext context, Subscription subs, MessageReference reference) {
        reference.decrementReferenceCount();
        this.broker.messageExpired(context, reference, subs);
        this.destinationStatistics.getExpired().increment();
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)2);
        ack.setDestination(this.destination);
        ack.setMessageID(reference.getMessageId());
        try {
            if (subs instanceof DurableTopicSubscription) {
                ((DurableTopicSubscription)subs).removePending(reference);
            }
            this.acknowledge(context, subs, ack, reference);
        }
        catch (Exception e) {
            LOG.error("Failed to remove expired Message from the store ", e);
        }
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    protected boolean isOptimizeStorage() {
        boolean result = false;
        if (this.isDoOptimzeMessageStorage() && !this.durableSubcribers.isEmpty()) {
            result = true;
            for (DurableTopicSubscription s : this.durableSubcribers.values()) {
                if (!s.isActive()) {
                    result = false;
                    break;
                }
                if (s.getPrefetchSize() == 0) {
                    result = false;
                    break;
                }
                if (s.isSlowConsumer()) {
                    result = false;
                    break;
                }
                if (s.getInFlightUsage() <= this.getOptimizeMessageStoreInFlightLimit()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPendingMessages() {
        this.dispatchLock.readLock().lock();
        try {
            for (DurableTopicSubscription durableTopicSubscription : this.durableSubcribers.values()) {
                this.clearPendingAndDispatch(durableTopicSubscription);
            }
        }
        finally {
            this.dispatchLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPendingAndDispatch(DurableTopicSubscription durableTopicSubscription) {
        Object object = durableTopicSubscription.pendingLock;
        synchronized (object) {
            durableTopicSubscription.pending.clear();
            try {
                durableTopicSubscription.dispatchPending();
            }
            catch (IOException exception) {
                LOG.warn("After clear of pending, failed to dispatch to: " + durableTopicSubscription + ", for :" + this.destination + ", pending: " + durableTopicSubscription.pending, exception);
            }
        }
    }

    public Map<SubscriptionKey, DurableTopicSubscription> getDurableTopicSubs() {
        return this.durableSubcribers;
    }

    private abstract class WaitingForSpaceMessage
    implements Runnable {
        Message message;

        public WaitingForSpaceMessage(Message message) {
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

