/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region;

import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.AbstractRegion;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.DestinationFactory;
import com.bes.mq.broker.region.DestinationFilter;
import com.bes.mq.broker.region.DestinationStatistics;
import com.bes.mq.broker.region.DurableTopicSubscription;
import com.bes.mq.broker.region.RegionBroker;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.broker.region.Topic;
import com.bes.mq.broker.region.TopicSubscription;
import com.bes.mq.broker.region.policy.PolicyEntry;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.SessionId;
import com.bes.mq.command.SubscriptionInfo;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.TopicMessageStore;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.util.LongSequenceGenerator;
import com.bes.mq.util.SubscriptionKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicRegion
extends AbstractRegion {
    private static final Logger LOG = LoggerFactory.getLogger(TopicRegion.class);
    protected final ConcurrentHashMap<SubscriptionKey, DurableTopicSubscription> durableSubscriptions = new ConcurrentHashMap();
    private final LongSequenceGenerator recoveredDurableSubIdGenerator = new LongSequenceGenerator();
    private final SessionId recoveredDurableSubSessionId = new SessionId(new ConnectionId("OFFLINE"), this.recoveredDurableSubIdGenerator.getNextSequenceId());
    private volatile boolean keepDurableSubsActive;
    private Timer cleanupTimer;
    private TimerTask cleanupTask;

    public TopicRegion(RegionBroker broker, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
        if (broker.getBrokerService().getOfflineDurableSubscriberTaskSchedule() != -1 && broker.getBrokerService().getOfflineDurableSubscriberTimeout() != -1) {
            this.cleanupTimer = new Timer("BESMQ Durable Subscriber Cleanup Timer", true);
            this.cleanupTask = new TimerTask(){

                public void run() {
                    TopicRegion.this.doCleanup();
                }
            };
            this.cleanupTimer.schedule(this.cleanupTask, broker.getBrokerService().getOfflineDurableSubscriberTaskSchedule(), (long)broker.getBrokerService().getOfflineDurableSubscriberTaskSchedule());
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.cleanupTimer != null) {
            this.cleanupTimer.cancel();
        }
    }

    public void doCleanup() {
        long now = System.currentTimeMillis();
        for (Map.Entry<SubscriptionKey, DurableTopicSubscription> entry : this.durableSubscriptions.entrySet()) {
            long offline;
            DurableTopicSubscription sub = entry.getValue();
            if (sub.isActive() || (offline = sub.getOfflineTimestamp()) == -1L || now - offline < (long)this.broker.getBrokerService().getOfflineDurableSubscriberTimeout()) continue;
            LOG.info("Destroying durable subscriber due to inactivity: " + sub);
            try {
                RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
                info.setClientId(entry.getKey().getClientId());
                info.setSubscriptionName(entry.getKey().getSubscriptionName());
                ConnectionContext context = new ConnectionContext();
                context.setBroker(this.broker);
                context.setClientId(entry.getKey().getClientId());
                this.removeSubscription(context, info);
            }
            catch (Exception e) {
                LOG.error("Failed to remove inactive durable subscriber", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        if (info.isDurable()) {
            String subscriptionName;
            String clientId;
            SubscriptionKey key;
            DurableTopicSubscription sub;
            BESMQDestination destination = info.getDestination();
            if (!destination.isPattern()) {
                this.lookup(context, destination, true);
            }
            if ((sub = this.durableSubscriptions.get(key = new SubscriptionKey(clientId = context.getClientId(), subscriptionName = info.getSubscriptionName()))) != null) {
                if (sub.isActive()) {
                    throw new JMSException("Durable consumer is in use for client: " + clientId + " and subscriptionName: " + subscriptionName);
                }
                if (this.hasDurableSubChanged(info, sub.getConsumerInfo())) {
                    this.durableSubscriptions.remove(key);
                    this.destinationsLock.readLock().lock();
                    try {
                        for (Destination dest : this.destinations.values()) {
                            if (!(dest instanceof Topic)) continue;
                            Topic topic = (Topic)dest;
                            topic.deleteSubscription(context, key);
                        }
                        Object var12_11 = null;
                        this.destinationsLock.readLock().unlock();
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        this.destinationsLock.readLock().unlock();
                        throw throwable;
                    }
                    super.removeConsumer(context, sub.getConsumerInfo());
                    super.addConsumer(context, info);
                    sub = this.durableSubscriptions.get(key);
                } else {
                    if (sub.getConsumerInfo().getConsumerId() != null) {
                        this.subscriptions.remove(sub.getConsumerInfo().getConsumerId());
                    }
                    this.subscriptions.put(info.getConsumerId(), sub);
                }
            } else {
                super.addConsumer(context, info);
                sub = this.durableSubscriptions.get(key);
                if (sub == null) {
                    throw new JMSException("Cannot use the same consumerId: " + info.getConsumerId() + " for two different durable subscriptions clientID: " + key.getClientId() + " subscriberName: " + key.getSubscriptionName());
                }
            }
            sub.activate(this.usageManager, context, info, this.broker);
            return sub;
        }
        return super.addConsumer(context, info);
    }

    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        if (info.isDurable()) {
            SubscriptionKey key = new SubscriptionKey(context.getClientId(), info.getSubscriptionName());
            DurableTopicSubscription sub = this.durableSubscriptions.get(key);
            if (sub != null) {
                sub.deactivate(this.keepDurableSubsActive);
            }
        } else {
            super.removeConsumer(context, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        SubscriptionKey key = new SubscriptionKey(info.getClientId(), info.getSubscriptionName());
        DurableTopicSubscription sub = this.durableSubscriptions.get(key);
        if (sub == null) {
            throw new InvalidDestinationException("No durable subscription exists for: " + info.getSubscriptionName());
        }
        if (sub.isActive()) {
            throw new JMSException("Durable consumer is in use");
        }
        this.durableSubscriptions.remove(key);
        this.destinationsLock.readLock().lock();
        try {
            for (Destination dest : this.destinations.values()) {
                if (dest instanceof DestinationFilter) {
                    this.deleteSubscription(context, ((DestinationFilter)dest).getNext(), key);
                    continue;
                }
                this.deleteSubscription(context, dest, key);
            }
            Object var8_7 = null;
            this.destinationsLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.destinationsLock.readLock().unlock();
            throw throwable;
        }
        if (this.subscriptions.get(sub.getConsumerInfo().getConsumerId()) != null) {
            super.removeConsumer(context, sub.getConsumerInfo());
        } else {
            this.destroySubscription(sub);
        }
    }

    private void deleteSubscription(ConnectionContext context, Destination dest, SubscriptionKey key) throws Exception {
        if (dest instanceof Topic) {
            Topic topic = (Topic)dest;
            topic.deleteSubscription(context, key);
        }
    }

    public String toString() {
        return "TopicRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.usageManager.getMemoryUsage().getPercentUsage() + "%";
    }

    @Override
    protected List<Subscription> addSubscriptionsForDestination(ConnectionContext context, Destination dest) throws Exception {
        List<Subscription> rc = super.addSubscriptionsForDestination(context, dest);
        HashSet<Subscription> dupChecker = new HashSet<Subscription>(rc);
        TopicMessageStore store = (TopicMessageStore)dest.getMessageStore();
        if (store != null) {
            SubscriptionInfo[] infos = store.getAllSubscriptions();
            for (int i = 0; i < infos.length; ++i) {
                SubscriptionInfo info = infos[i];
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Restoring durable subscription: " + info);
                }
                SubscriptionKey key = new SubscriptionKey(info);
                DurableTopicSubscription sub = this.durableSubscriptions.get(key);
                ConsumerInfo consumerInfo = this.createInactiveConsumerInfo(info);
                if (sub == null) {
                    ConnectionContext c = new ConnectionContext();
                    c.setBroker(context.getBroker());
                    c.setClientId(key.getClientId());
                    c.setConnectionId(consumerInfo.getConsumerId().getParentId().getParentId());
                    sub = (DurableTopicSubscription)this.createSubscription(c, consumerInfo);
                    sub.setOfflineTimestamp(System.currentTimeMillis());
                }
                if (dupChecker.contains(sub)) continue;
                dupChecker.add(sub);
                rc.add(sub);
                dest.addSubscription(context, sub);
            }
            this.durableSubscriptions.values();
            for (DurableTopicSubscription sub : this.durableSubscriptions.values()) {
                if (dupChecker.contains(sub) || !sub.matches(dest.getBESMQDestination())) continue;
                rc.add(sub);
                dest.addSubscription(context, sub);
            }
        }
        return rc;
    }

    public ConsumerInfo createInactiveConsumerInfo(SubscriptionInfo info) {
        ConsumerInfo rc = new ConsumerInfo();
        rc.setSelector(info.getSelector());
        rc.setSubscriptionName(info.getSubscriptionName());
        rc.setDestination(info.getSubscribedDestination());
        rc.setConsumerId(this.createConsumerId());
        return rc;
    }

    private ConsumerId createConsumerId() {
        return new ConsumerId(this.recoveredDurableSubSessionId, this.recoveredDurableSubIdGenerator.getNextSequenceId());
    }

    protected void configureTopic(Topic topic, BESMQDestination destination) {
        PolicyEntry entry;
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure((Broker)this.broker, topic);
        }
    }

    @Override
    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        BESMQDestination destination = info.getDestination();
        if (info.isDurable()) {
            if (NotificationSupport.isNotificationTopic(info.getDestination())) {
                throw new JMSException("Cannot create a durable subscription for an notification Topic");
            }
            SubscriptionKey key = new SubscriptionKey(context.getClientId(), info.getSubscriptionName());
            DurableTopicSubscription sub = this.durableSubscriptions.get(key);
            if (sub == null) {
                PolicyEntry entry;
                sub = new DurableTopicSubscription((Broker)this.broker, this.usageManager, context, info, this.keepDurableSubsActive);
                if (destination != null && this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
                    entry.configure((Broker)this.broker, this.usageManager, sub);
                }
            } else {
                throw new JMSException("That durable subscription is already active.");
            }
            this.durableSubscriptions.put(key, sub);
            return sub;
        }
        try {
            PolicyEntry entry;
            TopicSubscription answer = new TopicSubscription(this.broker, context, info, this.usageManager);
            if (destination != null && this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
                entry.configure((Broker)this.broker, this.usageManager, answer);
            }
            answer.init();
            return answer;
        }
        catch (Exception e) {
            LOG.error("Failed to create TopicSubscription ", e);
            JMSException jmsEx = new JMSException("Couldn't create TopicSubscription");
            jmsEx.setLinkedException(e);
            throw jmsEx;
        }
    }

    private boolean hasDurableSubChanged(ConsumerInfo info1, ConsumerInfo info2) {
        if (info1.getSelector() != null ^ info2.getSelector() != null) {
            return true;
        }
        if (info1.getSelector() != null && !info1.getSelector().equals(info2.getSelector())) {
            return true;
        }
        return !info1.getDestination().equals(info2.getDestination());
    }

    @Override
    protected Set<BESMQDestination> getInactiveDestinations() {
        Set<BESMQDestination> inactiveDestinations = super.getInactiveDestinations();
        Iterator<BESMQDestination> iter = inactiveDestinations.iterator();
        while (iter.hasNext()) {
            BESMQDestination dest = iter.next();
            if (dest.isTopic()) continue;
            iter.remove();
        }
        return inactiveDestinations;
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
    }

    public boolean durableSubscriptionExists(SubscriptionKey key) {
        return this.durableSubscriptions.containsKey(key);
    }
}

