/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.cursors.AbstractPendingMessageCursor;
import com.bes.mq.broker.region.cursors.OrderedPendingList;
import com.bes.mq.broker.region.cursors.PendingList;
import com.bes.mq.broker.region.cursors.PrioritizedPendingList;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.MessageRecoveryListener;
import java.util.Iterator;

public abstract class AbstractStoreCursor
extends AbstractPendingMessageCursor
implements MessageRecoveryListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStoreCursor.class);
    protected final Destination regionDestination;
    protected final PendingList batchList;
    private Iterator<MessageReference> iterator = null;
    protected boolean batchResetNeeded = false;
    private boolean storeHasMessages = false;
    protected int size;
    private MessageId lastCachedId;
    private Integer lastCachedPriority;
    private boolean hadSpace = false;
    protected long duplicateMessagesFromProducer;
    protected long duplicateMessagesFromStore;

    protected AbstractStoreCursor(Destination destination) {
        super(destination != null ? destination.isPrioritizedMessages() : false);
        this.regionDestination = destination;
        this.batchList = this.prioritizedMessages ? new PrioritizedPendingList() : new OrderedPendingList();
    }

    public final synchronized void start() throws Exception {
        if (!this.isStarted()) {
            super.start();
            this.resetBatch();
            this.resetSize();
            this.setCacheEnabled(!this.storeHasMessages && this.useCache);
        }
    }

    protected void resetSize() {
        this.size = this.getStoreSize();
        this.storeHasMessages = !this.hasSpace() || this.batchList.size() < this.size;
    }

    public final synchronized void stop() throws Exception {
        this.resetBatch();
        super.stop();
    }

    public final boolean recoverMessage(Message message) throws Exception {
        return this.recoverMessage(message, false);
    }

    public synchronized boolean recoverMessage(Message message, boolean cached) throws Exception {
        boolean recovered = false;
        if (this.recordUniqueId(message.getMessageId())) {
            if (!cached) {
                message.setRegionDestination(this.regionDestination);
                if (message.getMemoryUsage() == null) {
                    message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
                }
                message.incrementReferenceCount();
            }
            this.batchList.addMessageLast(message);
            this.clearIterator(true);
            recovered = true;
        } else if (cached) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + " - cursor got duplicate message from producer: " + message.getMessageId() + ", " + message.getPriority());
            }
            ++this.duplicateMessagesFromProducer;
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + " - cursor got duplicate message from store: " + message.getMessageId() + ", " + message.getPriority());
            }
            ++this.duplicateMessagesFromStore;
        }
        return recovered;
    }

    public final synchronized void reset() {
        try {
            this.fillBatch();
        }
        catch (Exception e) {
            LOG.error(this + " - Failed to fill batch", e);
            throw new RuntimeException(e);
        }
        this.clearIterator(true);
        this.size();
    }

    public synchronized void release() {
        this.clearIterator(false);
    }

    private synchronized void clearIterator(boolean ensureIterator) {
        boolean haveIterator = this.iterator != null;
        this.iterator = null;
        if (haveIterator && ensureIterator) {
            this.ensureIterator();
        }
    }

    private synchronized void ensureIterator() {
        if (this.iterator == null) {
            this.iterator = this.batchList.iterator();
        }
    }

    public final void finished() {
    }

    public final synchronized boolean hasNext() {
        try {
            this.fillBatch();
        }
        catch (Exception e) {
            LOG.error(this + " - Failed to fill batch", e);
            throw new RuntimeException(e);
        }
        this.ensureIterator();
        return this.iterator.hasNext();
    }

    public final synchronized MessageReference next() {
        MessageReference result = null;
        if (!this.batchList.isEmpty() && this.iterator.hasNext()) {
            result = this.iterator.next();
        }
        this.last = result;
        return result;
    }

    public final synchronized void addMessageLast(MessageReference node) throws Exception {
        boolean disableCache = false;
        if (this.hasSpace()) {
            if (!this.isCacheEnabled() && this.size == 0 && this.isStarted() && this.useCache) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + " - enabling cache for empty store " + node.getMessageId());
                }
                this.setCacheEnabled(true);
            }
            if (this.isCacheEnabled()) {
                if (this.recoverMessage(node.getMessage(), true)) {
                    this.lastCachedId = node.getMessageId();
                    this.lastCachedPriority = node.getMessage().getPriority();
                } else {
                    disableCache = true;
                }
            }
        } else {
            disableCache = true;
            this.storeHasMessages = true;
        }
        if (disableCache && this.isCacheEnabled()) {
            this.setCacheEnabled(false);
            if (this.lastCachedId != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + " - disabling cache" + ", lastCachedId: " + this.lastCachedId + " current node Id: " + node.getMessageId() + " batchList size: " + this.batchList.size());
                }
                this.setBatch(this.lastCachedId, this.lastCachedPriority);
                this.lastCachedId = null;
                this.lastCachedPriority = null;
            }
        }
        if (!this.isCacheEnabled()) {
            node.decrementReferenceCount();
            this.storeHasMessages = true;
        }
        ++this.size;
    }

    protected void setBatch(MessageId messageId, Integer priority) throws Exception {
    }

    public final synchronized void addMessageFirst(MessageReference node) throws Exception {
        this.setCacheEnabled(false);
        ++this.size;
    }

    public final synchronized void remove() {
        --this.size;
        if (this.iterator != null) {
            this.iterator.remove();
        }
    }

    public final synchronized void remove(MessageReference node) {
        if (this.batchList.remove(node) != null) {
            --this.size;
            this.setCacheEnabled(false);
        }
    }

    public final synchronized void clear() {
        this.gc();
    }

    public synchronized void gc() {
        for (MessageReference msg : this.batchList) {
            this.rollback(msg.getMessageId());
            msg.decrementReferenceCount();
        }
        this.batchList.clear();
        this.clearIterator(false);
        this.batchResetNeeded = true;
        this.setCacheEnabled(false);
    }

    public boolean hasSpace() {
        this.hadSpace = super.hasSpace();
        return this.hadSpace;
    }

    protected final synchronized void fillBatch() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " - fillBatch");
        }
        if (this.batchResetNeeded) {
            this.resetSize();
            this.setMaxBatchSize(Math.min(this.regionDestination.getMaxPageSize(), this.size));
            this.resetBatch();
            this.batchResetNeeded = false;
        }
        if (this.batchList.isEmpty() && this.storeHasMessages && this.size > 0) {
            try {
                this.doFillBatch();
            }
            catch (Exception e) {
                LOG.error(this + " - Failed to fill batch", e);
                throw new RuntimeException(e);
            }
            this.resetSize();
            this.setCacheEnabled(!this.storeHasMessages && this.useCache);
        }
    }

    public final synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public final synchronized boolean hasMessagesBufferedToDeliver() {
        return !this.batchList.isEmpty();
    }

    public final synchronized int size() {
        if (this.size < 0) {
            this.size = this.getStoreSize();
        }
        return this.size;
    }

    public synchronized boolean isInMemory(MessageReference node) {
        return this.batchList.contains(node);
    }

    public String toString() {
        return super.toString() + ":" + this.regionDestination.getBESMQDestination().getPhysicalName() + ",batchResetNeeded=" + this.batchResetNeeded + ",storeHasMessages=" + this.storeHasMessages + ",size=" + this.size + ",cacheEnabled=" + this.isCacheEnabled() + ",maxBatchSize:" + this.maxBatchSize;
    }

    protected abstract void doFillBatch() throws Exception;

    protected abstract void resetBatch();

    protected abstract int getStoreSize();

    protected abstract boolean isStoreEmpty();

    public long getDuplicateMessagesFromProducer() {
        return this.duplicateMessagesFromProducer;
    }

    public long getDuplicateMessagesFromStore() {
        return this.duplicateMessagesFromStore;
    }
}

