/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.hsdb.util.ByteSequence;
import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.broker.Broker;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.IndirectMessageReference;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.QueueMessageReference;
import com.bes.mq.broker.region.cursors.AbstractPendingMessageCursor;
import com.bes.mq.broker.region.cursors.OrderedPendingList;
import com.bes.mq.broker.region.cursors.PendingList;
import com.bes.mq.broker.region.cursors.PrioritizedPendingList;
import com.bes.mq.command.Message;
import com.bes.mq.filter.NonCachedMessageEvaluationContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.protocolformat.ProtocolFormat;
import com.bes.mq.store.hsdb.plist.PList;
import com.bes.mq.store.hsdb.plist.PListEntry;
import com.bes.mq.store.hsdb.plist.PListStore;
import com.bes.mq.usage.SystemUsage;
import com.bes.mq.usage.Usage;
import com.bes.mq.usage.UsageListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePendingMessageCursor
extends AbstractPendingMessageCursor
implements UsageListener {
    static final Logger LOG = LoggerFactory.getLogger(FilePendingMessageCursor.class);
    private static final AtomicLong NAME_COUNT = new AtomicLong();
    protected Broker broker;
    private final PListStore store;
    private final String name;
    private PendingList memoryList;
    private PList diskList;
    private Iterator<MessageReference> iter;
    private Destination regionDestination;
    private boolean iterating;
    private boolean flushRequired;
    private final AtomicBoolean started = new AtomicBoolean();
    private final ProtocolFormat protocolFormat = new BESMPFormat();

    public FilePendingMessageCursor(Broker broker, String name, boolean prioritizedMessages) {
        super(prioritizedMessages);
        this.memoryList = this.prioritizedMessages ? new PrioritizedPendingList() : new OrderedPendingList();
        this.broker = broker;
        this.store = broker.getTempDataStore();
        this.name = NAME_COUNT.incrementAndGet() + "_" + name;
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            super.start();
            if (this.systemUsage != null) {
                this.systemUsage.getMemoryUsage().addUsageListener(this);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            if (this.systemUsage != null) {
                this.systemUsage.getMemoryUsage().removeUsageListener(this);
            }
            super.stop();
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.memoryList.isEmpty() && this.isDiskListEmpty()) {
            return true;
        }
        Iterator<MessageReference> iterator = this.memoryList.iterator();
        while (iterator.hasNext()) {
            MessageReference node = iterator.next();
            if (node == QueueMessageReference.NULL_MESSAGE) continue;
            if (!node.isDropped()) {
                return false;
            }
            iterator.remove();
        }
        return this.isDiskListEmpty();
    }

    @Override
    public synchronized void reset() {
        this.iterating = true;
        this.last = null;
        this.iter = this.isDiskListEmpty() ? this.memoryList.iterator() : new DiskIterator();
    }

    @Override
    public synchronized void release() {
        this.iterating = false;
        if (this.iter instanceof DiskIterator) {
            ((DiskIterator)this.iter).release();
        }
        if (this.flushRequired) {
            this.flushRequired = false;
            if (!this.hasSpace()) {
                this.flushToDisk();
            }
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        if (this.systemUsage != null) {
            this.systemUsage.getMemoryUsage().removeUsageListener(this);
        }
        for (MessageReference node : this.memoryList) {
            node.decrementReferenceCount();
        }
        this.memoryList.clear();
        this.destroyDiskList();
        this.stop();
    }

    private void destroyDiskList() throws Exception {
        if (this.diskList != null) {
            this.store.removePList(this.name);
            this.diskList = null;
        }
    }

    @Override
    public synchronized LinkedList<MessageReference> pageInList(int maxItems) {
        int count;
        LinkedList<MessageReference> result = new LinkedList<MessageReference>();
        DiskIterator i = this.memoryList.iterator();
        for (count = 0; i.hasNext() && count < maxItems; ++count) {
            MessageReference ref = i.next();
            result.add(ref);
        }
        if (count < maxItems && !this.isDiskListEmpty()) {
            i = new DiskIterator();
            while (i.hasNext() && count < maxItems) {
                Message message = (Message)i.next();
                result.add(message);
                ++count;
            }
        }
        return result;
    }

    @Override
    public synchronized void addMessageLast(MessageReference node) throws Exception {
        this.tryAddMessageLast(node, Long.MAX_VALUE);
    }

    @Override
    public synchronized boolean tryAddMessageLast(MessageReference node, long maxWaitTime) throws Exception {
        if (!node.isExpired()) {
            try {
                this.regionDestination = node.getMessage().getRegionDestination();
                if (this.isDiskListEmpty()) {
                    if (this.hasSpace() || this.store == null) {
                        this.memoryList.addMessageLast(node);
                        this.setCacheEnabled(true);
                        return true;
                    }
                    this.flushToDisk();
                }
                if (!this.systemUsage.getTempUsage().isFull()) {
                    ByteSequence bs = this.getByteSequence(node.getMessage());
                    this.getDiskList().addLast(node.getMessageId().toString(), bs);
                    node.decrementReferenceCount();
                    return true;
                }
                if (maxWaitTime == 0L) {
                    return false;
                }
                this.systemUsage.getTempUsage().waitForSpace(maxWaitTime);
                if (!this.systemUsage.getTempUsage().isFull()) {
                    ByteSequence bs = this.getByteSequence(node.getMessage());
                    this.getDiskList().addLast(node.getMessageId().toString(), bs);
                    node.decrementReferenceCount();
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                LOG.error("Caught an Exception adding a message: " + node + " first to FilePendingMessageCursor ", e);
                throw new RuntimeException(e);
            }
        }
        this.discardExpiredMessage(node);
        return true;
    }

    @Override
    public synchronized void addMessageFirst(MessageReference node) {
        if (!node.isExpired()) {
            try {
                this.regionDestination = node.getMessage().getRegionDestination();
                if (this.isDiskListEmpty()) {
                    if (this.hasSpace()) {
                        this.memoryList.addMessageFirst(node);
                        this.setCacheEnabled(true);
                        return;
                    }
                    this.flushToDisk();
                }
                this.systemUsage.getTempUsage().waitForSpace();
                node.decrementReferenceCount();
                ByteSequence bs = this.getByteSequence(node.getMessage());
                this.getDiskList().addFirst(node.getMessageId().toString(), bs);
            }
            catch (Exception e) {
                LOG.error("Caught an Exception adding a message: " + node + " first to FilePendingMessageCursor ", e);
                throw new RuntimeException(e);
            }
        } else {
            this.discardExpiredMessage(node);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public synchronized MessageReference next() {
        MessageReference reference;
        this.last = reference = this.iter.next();
        return reference;
    }

    @Override
    public synchronized void remove() {
        this.iter.remove();
    }

    @Override
    public synchronized void remove(MessageReference node) {
        if (!this.isDiskListEmpty()) {
            try {
                this.getDiskList().remove(node.getMessageId().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.memoryList.remove(node);
        }
    }

    @Override
    public synchronized int size() {
        return this.memoryList.size() + (this.isDiskListEmpty() ? 0 : (int)this.getDiskList().size());
    }

    @Override
    public synchronized void clear() {
        for (MessageReference ref : this.memoryList) {
            ref.decrementReferenceCount();
        }
        this.memoryList.clear();
        if (!this.isDiskListEmpty()) {
            try {
                this.getDiskList().destroy();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.last = null;
    }

    @Override
    public synchronized boolean isFull() {
        return super.isFull() || !this.isDiskListEmpty() && this.systemUsage != null && this.systemUsage.getTempUsage().isFull();
    }

    @Override
    public boolean hasMessagesBufferedToDeliver() {
        return !this.isEmpty();
    }

    @Override
    public void setSystemUsage(SystemUsage usageManager) {
        super.setSystemUsage(usageManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (!this.hasSpace()) {
            FilePendingMessageCursor filePendingMessageCursor = this;
            synchronized (filePendingMessageCursor) {
                if (!this.flushRequired && this.size() != 0) {
                    this.flushRequired = true;
                    if (!this.iterating) {
                        this.flushToDisk();
                        this.flushRequired = false;
                    }
                }
            }
        }
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    protected boolean isSpaceInMemoryList() {
        return this.hasSpace() && this.isDiskListEmpty();
    }

    protected synchronized void flushToDisk() {
        if (!this.memoryList.isEmpty() && this.store != null) {
            long start = 0L;
            if (LOG.isTraceEnabled()) {
                start = System.currentTimeMillis();
                LOG.trace("" + this.name + ", flushToDisk() mem list size: " + this.memoryList.size() + " " + (this.systemUsage != null ? this.systemUsage.getMemoryUsage() : ""));
            }
            for (MessageReference node : this.memoryList) {
                if (node.isExpired()) {
                    this.discardExpiredMessage(node);
                    continue;
                }
                node.decrementReferenceCount();
                try {
                    ByteSequence bs = this.getByteSequence(node.getMessage());
                    this.getDiskList().addLast(node.getMessageId().toString(), bs);
                }
                catch (IOException e) {
                    LOG.error("Failed to write to disk list", e);
                    throw new RuntimeException(e);
                }
            }
            this.memoryList.clear();
            this.setCacheEnabled(false);
            if (LOG.isTraceEnabled()) {
                LOG.trace("" + this.name + ", flushToDisk() done - " + (System.currentTimeMillis() - start) + "ms " + (this.systemUsage != null ? this.systemUsage.getMemoryUsage() : ""));
            }
        }
    }

    protected boolean isDiskListEmpty() {
        return this.diskList == null || this.diskList.isEmpty();
    }

    protected PList getDiskList() {
        if (this.diskList == null) {
            try {
                this.diskList = this.store.getPList(this.name);
            }
            catch (Exception e) {
                LOG.error("Caught an IO Exception getting the DiskList " + this.name, e);
                throw new RuntimeException(e);
            }
        }
        return this.diskList;
    }

    private void discardExpiredMessage(MessageReference reference) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarding expired message " + reference);
        }
        if (this.broker.isExpired(reference)) {
            ConnectionContext context = new ConnectionContext(new NonCachedMessageEvaluationContext());
            context.setBroker(this.broker);
            reference.getRegionDestination().messageExpired(context, null, new IndirectMessageReference(reference.getMessage()));
        }
    }

    protected ByteSequence getByteSequence(Message message) throws IOException {
        com.bes.mq.util.ByteSequence packet = this.protocolFormat.marshal(message);
        return new ByteSequence(packet.data, packet.offset, packet.length);
    }

    protected Message getMessage(ByteSequence bs) throws IOException {
        com.bes.mq.util.ByteSequence packet = new com.bes.mq.util.ByteSequence(bs.getData(), bs.getOffset(), bs.getLength());
        return (Message)this.protocolFormat.unmarshal(packet);
    }

    @Override
    public void gc() {
        this.flushToDisk();
    }

    @Override
    public synchronized boolean isInMemory(MessageReference node) {
        return this.memoryList.contains(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DiskIterator
    implements Iterator<MessageReference> {
        private final PList.PListIterator iterator;

        DiskIterator() {
            try {
                this.iterator = FilePendingMessageCursor.this.getDiskList().iterator();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() && FilePendingMessageCursor.this.hasSpace();
        }

        @Override
        public MessageReference next() {
            try {
                PListEntry entry = this.iterator.next();
                Message reference = FilePendingMessageCursor.this.getMessage(entry.getByteSequence());
                reference.getMessage().setRegionDestination(FilePendingMessageCursor.this.regionDestination);
                reference.getMessage().setMemoryUsage(FilePendingMessageCursor.this.getSystemUsage().getMemoryUsage());
                reference.getMessage().incrementReferenceCount();
                return reference;
            }
            catch (IOException e) {
                LOG.error("I/O error", e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        public void release() {
            this.iterator.release();
        }
    }
}

