/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.cursors.PendingList;
import com.bes.mq.broker.region.cursors.PendingNode;
import com.bes.mq.command.MessageId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedPendingList
implements PendingList {
    private PendingNode root = null;
    private PendingNode tail = null;
    private final Map<MessageId, PendingNode> map = new LinkedHashMap<MessageId, PendingNode>();

    @Override
    public PendingNode addMessageFirst(MessageReference message) {
        PendingNode pendingNode = new PendingNode(this, message);
        PendingNode previousDuplicatedNode = this.map.put(message.getMessageId(), pendingNode);
        if (previousDuplicatedNode == null) {
            if (this.root == null) {
                this.root = pendingNode;
                this.tail = pendingNode;
            } else {
                this.root.linkBefore(pendingNode);
                this.root = pendingNode;
            }
            return pendingNode;
        }
        this.map.put(previousDuplicatedNode.getMessage().getMessageId(), previousDuplicatedNode);
        return previousDuplicatedNode;
    }

    @Override
    public PendingNode addMessageLast(MessageReference message) {
        PendingNode pendingNode = new PendingNode(this, message);
        PendingNode previousDuplicatedNode = this.map.put(message.getMessageId(), pendingNode);
        if (previousDuplicatedNode == null) {
            if (this.root == null) {
                this.root = pendingNode;
            } else {
                this.tail.linkAfter(pendingNode);
            }
            this.tail = pendingNode;
            return pendingNode;
        }
        this.map.put(previousDuplicatedNode.getMessage().getMessageId(), previousDuplicatedNode);
        return previousDuplicatedNode;
    }

    @Override
    public void clear() {
        this.root = null;
        this.tail = null;
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<MessageReference> iterator() {
        return new Iterator<MessageReference>(){
            private PendingNode current = null;
            private PendingNode next = OrderedPendingList.access$000(OrderedPendingList.this);

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public MessageReference next() {
                MessageReference result = null;
                this.current = this.next;
                result = this.current.getMessage();
                this.next = (PendingNode)this.next.getNext();
                return result;
            }

            @Override
            public void remove() {
                if (this.current != null && this.current.getMessage() != null) {
                    OrderedPendingList.this.remove(this.current.getMessage());
                }
            }
        };
    }

    @Override
    public PendingNode remove(MessageReference message) {
        PendingNode pendingNode = null;
        if (message != null && (pendingNode = this.map.remove(message.getMessageId())) != null) {
            this.removeNode(pendingNode);
        }
        return pendingNode;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    private void removeNode(PendingNode pendingNode) {
        if (pendingNode != null) {
            if (this.root == pendingNode) {
                this.root = (PendingNode)pendingNode.getNext();
            }
            if (this.tail == pendingNode) {
                this.tail = (PendingNode)pendingNode.getPrevious();
            }
            pendingNode.unlink();
        }
    }

    List<PendingNode> getAsList() {
        ArrayList<PendingNode> result = new ArrayList<PendingNode>(this.size());
        for (PendingNode pendingNode = this.root; pendingNode != null; pendingNode = (PendingNode)pendingNode.getNext()) {
            result.add(pendingNode);
        }
        return result;
    }

    public String toString() {
        return "OrderedPendingList(" + System.identityHashCode(this) + ")";
    }

    @Override
    public boolean contains(MessageReference message) {
        PendingNode pendingNode;
        return message != null && (pendingNode = this.map.get(message.getMessageId())) != null && pendingNode.getMessage().equals(message);
    }

    @Override
    public Collection<MessageReference> values() {
        ArrayList<MessageReference> messageReferences = new ArrayList<MessageReference>();
        for (PendingNode pendingNode : this.map.values()) {
            messageReferences.add(pendingNode.getMessage());
        }
        return messageReferences;
    }

    @Override
    public void addAll(PendingList pendingList) {
        if (pendingList != null) {
            for (MessageReference messageReference : pendingList) {
                this.addMessageLast(messageReference);
            }
        }
    }

    static /* synthetic */ PendingNode access$000(OrderedPendingList x0) {
        return x0.root;
    }
}

