/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.cursors.OrderedPendingList;
import com.bes.mq.broker.region.cursors.PendingList;
import com.bes.mq.broker.region.cursors.PendingNode;
import com.bes.mq.command.MessageId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrioritizedPendingList
implements PendingList {
    private static final Integer MAX_PRIORITY = 10;
    private final OrderedPendingList[] lists = new OrderedPendingList[MAX_PRIORITY.intValue()];
    private final Map<MessageId, PendingNode> map = new LinkedHashMap<MessageId, PendingNode>();

    public PrioritizedPendingList() {
        for (int i = 0; i < MAX_PRIORITY; ++i) {
            this.lists[i] = new OrderedPendingList();
        }
    }

    @Override
    public PendingNode addMessageFirst(MessageReference message) {
        PendingNode pendingNode = this.getList(message).addMessageFirst(message);
        this.map.put(message.getMessageId(), pendingNode);
        return pendingNode;
    }

    @Override
    public PendingNode addMessageLast(MessageReference message) {
        PendingNode pendingNode = this.getList(message).addMessageLast(message);
        this.map.put(message.getMessageId(), pendingNode);
        return pendingNode;
    }

    @Override
    public void clear() {
        for (int i = 0; i < MAX_PRIORITY; ++i) {
            this.lists[i].clear();
        }
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<MessageReference> iterator() {
        return new PrioritizedPendingListIterator();
    }

    @Override
    public PendingNode remove(MessageReference message) {
        PendingNode pendingNode = null;
        if (message != null && (pendingNode = this.map.remove(message.getMessageId())) != null) {
            pendingNode.getList().remove(pendingNode.getMessage());
        }
        return pendingNode;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return "PrioritizedPendingList(" + System.identityHashCode(this) + ")";
    }

    protected int getPriority(MessageReference message) {
        int priority = 4;
        if (message.getMessageId() != null) {
            priority = Math.max(message.getMessage().getPriority(), 0);
            priority = Math.min(priority, 9);
        }
        return priority;
    }

    protected OrderedPendingList getList(MessageReference msg) {
        return this.lists[this.getPriority(msg)];
    }

    @Override
    public boolean contains(MessageReference message) {
        PendingNode pendingNode;
        return message != null && (pendingNode = this.map.get(message.getMessageId())) != null && pendingNode.getMessage().equals(message);
    }

    @Override
    public Collection<MessageReference> values() {
        ArrayList<MessageReference> messageReferences = new ArrayList<MessageReference>(this.map.size());
        for (PendingNode pendingNode : this.map.values()) {
            messageReferences.add(pendingNode.getMessage());
        }
        return messageReferences;
    }

    @Override
    public void addAll(PendingList pendingList) {
        for (MessageReference messageReference : pendingList) {
            this.addMessageLast(messageReference);
        }
    }

    static /* synthetic */ Integer access$000() {
        return MAX_PRIORITY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrioritizedPendingListIterator
    implements Iterator<MessageReference> {
        private int currentPriority = PrioritizedPendingList.access$000() - 1;
        private MessageReference currentMessage = null;
        private Iterator<MessageReference> currentIterator = null;

        PrioritizedPendingListIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                this.currentIterator = null;
                while (this.currentPriority >= 0) {
                    OrderedPendingList orderedPendingList = PrioritizedPendingList.this.lists[this.currentPriority];
                    --this.currentPriority;
                    if (orderedPendingList.isEmpty()) continue;
                    this.currentIterator = orderedPendingList.iterator();
                    break;
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public MessageReference next() {
            this.currentMessage = this.currentIterator == null ? null : this.currentIterator.next();
            return this.currentMessage;
        }

        @Override
        public void remove() {
            if (this.currentIterator != null) {
                this.currentIterator.remove();
                PrioritizedPendingList.this.remove(this.currentMessage);
            }
        }
    }
}

