/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker.region.cursors;

import com.bes.mq.broker.region.Queue;
import com.bes.mq.broker.region.cursors.AbstractStoreCursor;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageId;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.MessageStore;
import java.io.IOException;

class QueueStorePrefetch
extends AbstractStoreCursor {
    private static final Logger LOG = LoggerFactory.getLogger(QueueStorePrefetch.class);
    private final MessageStore store;

    public QueueStorePrefetch(Queue queue) {
        super(queue);
        this.store = queue.getMessageStore();
    }

    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
        Message msg = this.store.getMessage(messageReference);
        if (msg != null) {
            return this.recoverMessage(msg);
        }
        String err = "Failed to retrieve message for id: " + messageReference;
        LOG.error(err);
        throw new IOException(err);
    }

    protected synchronized int getStoreSize() {
        try {
            int result = this.store.getMessageCount();
            return result;
        }
        catch (IOException e) {
            LOG.error("Failed to get message count", e);
            throw new RuntimeException(e);
        }
    }

    protected synchronized boolean isStoreEmpty() {
        try {
            return this.store.isEmpty();
        }
        catch (Exception e) {
            LOG.error("Failed to get message count", e);
            throw new RuntimeException(e);
        }
    }

    protected void resetBatch() {
        this.store.resetBatching();
    }

    protected void setBatch(MessageId messageId, Integer priority) throws Exception {
        this.store.setBatch(messageId);
        this.batchResetNeeded = false;
    }

    protected void doFillBatch() throws Exception {
        this.store.recoverNextMessages(this.maxBatchSize, this);
    }
}

